/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class ClosedLinearCurve
extends ACurve
implements ILinearCurve,
IManipulatable {
    public static final long serialVersionUID = 4032153402700153011L;
    public static final long serialVersionUID_old = 8783959934722819851L;
    public final ILinearCurve base;

    public ClosedLinearCurve(ILinearCurve base) {
        assert (base.getNumVerts() >= 3);
        assert (base.getVert(0).epsilonEquals((Tuple3d)base.getVert(base.getNumVerts() - 1), 1.0E-9));
        this.base = base;
    }

    @Override
    public ILinearCurve transform(TransformInfo ti, int options) {
        ILinearCurve newBase = this.base.transform(ti, options);
        if (newBase == this.base) {
            return this;
        }
        return new ClosedLinearCurve(newBase);
    }

    @Override
    public ClosedLinearCurve reverse() {
        return new ClosedLinearCurve(this.base.reverse());
    }

    @Override
    public ILinearCurve optimize(IPointOptimizer pool) {
        ILinearCurve newBase = this.base.optimize(pool);
        if (newBase == this.base) {
            return this;
        }
        return new ClosedLinearCurve(newBase);
    }

    @Override
    public Mesh getSegments(double errorTol) {
        return this.base.getSegments(errorTol);
    }

    @Override
    public Point3d project(Point3d p, double tol) {
        return this.base.project(p, tol);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        return this.base.getBoundingBox(aabb);
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return this.base.getDOF();
    }

    @Override
    public IDOF getRetainingDOF() {
        return this.base.getRetainingDOF();
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        this.base.pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        this.base.pickBox(source, filter, region, isects);
    }

    @Override
    public int getNumVerts() {
        return this.base.getNumVerts();
    }

    @Override
    public Point3d getVert(int ix) {
        return this.base.getVert(ix);
    }

    @Override
    protected int getPrimType() {
        return super.getPrimType();
    }

    @Override
    public ILinearCurve newCurve(Point3d ... points) {
        return new ClosedLinearCurve(this.base.newCurve(points));
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        if (!(this.base instanceof IManipulatable)) {
            return Collections.emptyList();
        }
        ArrayList<? extends IHandle> baseHandles = new ArrayList<IHandle>(this.base.generateManipHandles());
        ArrayList<Handle> handles = new ArrayList<Handle>(baseHandles.size() - 1);
        for (int m = 0; m < baseHandles.size() - 1; ++m) {
            handles.add(new Handle(this.base, (IHandle)baseHandles.get(m), m == 0));
        }
        return handles;
    }

    private static class Handle
    implements IHandle {
        private final ILinearCurve d_baseCurve;
        private final IHandle d_base;
        private final boolean d_first;

        public Handle(ILinearCurve baseCurve, IHandle baseHandle, boolean first) {
            this.d_baseCurve = baseCurve;
            this.d_base = baseHandle;
            this.d_first = first;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_base.equals(this.d_base) && ((Handle)obj).d_first == this.d_first;
        }

        @Override
        public IGeomNode getGeom() {
            return this.d_base.getGeom();
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.d_base.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return this.d_base.getConstraint(handleLoc);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.d_base.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            return this.modify(this.d_base.modify(newLoc));
        }

        @Override
        public Object end() {
            return this.modify(this.d_base.end());
        }

        private Object modify(Object baseObj) {
            if (baseObj instanceof ILinearCurve) {
                ILinearCurve lcurve = (ILinearCurve)baseObj;
                if (!this.d_first) {
                    return new ClosedLinearCurve(lcurve);
                }
                Point3d[] points = new Point3d[lcurve.getNumVerts()];
                for (int m = 0; m < lcurve.getNumVerts() - 1; ++m) {
                    points[m] = lcurve.getVert(m);
                }
                points[points.length - 1] = points[0];
                return new ClosedLinearCurve(this.d_baseCurve.newCurve(points));
            }
            return null;
        }
    }
}

