/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ACubicSpline;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class CatmullRomSpline
extends ACubicSpline {
    static final long serialVersionUID = 1L;
    public final Type type;
    public final Point3d p0;
    public final Point3d p1;
    public final Point3d p2;
    public final Point3d p3;

    public CatmullRomSpline(Type type, Point3d p0, Point3d p1, Point3d p2, Point3d p3) {
        super(CatmullRomSpline.getCoefficients(type, p0, p1, p2, p3));
        this.type = type;
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }

    private static final double[] getCoefficients(Type type, Point3d p0, Point3d p1, Point3d p2, Point3d p3) {
        double dalpha = type.alpha * 0.5;
        double dt0 = Math.pow(p0.distanceSquared(p1), dalpha);
        double dt1 = Math.pow(p1.distanceSquared(p2), dalpha);
        double dt2 = Math.pow(p2.distanceSquared(p3), dalpha);
        if (dt1 < 1.0E-4) {
            dt1 = 1.0;
        }
        if (dt0 < 1.0E-4) {
            dt0 = dt1;
        }
        if (dt2 < 1.0E-4) {
            dt2 = dt1;
        }
        double[] c = new double[12];
        CatmullRomSpline.initNonuniformCatmullRom(c, 0, dt0, dt1, dt2, p0.x, p1.x, p2.x, p3.x);
        CatmullRomSpline.initNonuniformCatmullRom(c, 4, dt0, dt1, dt2, p0.y, p1.y, p2.y, p3.y);
        CatmullRomSpline.initNonuniformCatmullRom(c, 8, dt0, dt1, dt2, p0.z, p1.z, p2.z, p3.z);
        return c;
    }

    private static final void initNonuniformCatmullRom(double[] p, int offset, double dt0, double dt1, double dt2, double x0, double x1, double x2, double x3) {
        double t1 = (x1 - x0) / dt0 - (x2 - x0) / (dt0 + dt1) + (x2 - x1) / dt1;
        double t2 = (x2 - x1) / dt1 - (x3 - x1) / (dt1 + dt2) + (x3 - x2) / dt2;
        CatmullRomSpline.initCubicPoly(p, offset, x1, x2, t1 *= dt1, t2 *= dt1);
    }

    private static final void initCatmullRom(double[] p, int offset, double x0, double x1, double x2, double x3) {
        CatmullRomSpline.initCubicPoly(p, offset, x1, x2, 0.5 * (x2 - x0), 0.5 * (x3 - x1));
    }

    private static final void initCubicPoly(double[] p, int offset, double x0, double x1, double t0, double t1) {
        p[offset + 3] = x0;
        p[offset + 2] = t0;
        p[offset + 1] = -3.0 * x0 + 3.0 * x1 - 2.0 * t0 - t1;
        p[offset + 0] = 2.0 * x0 - 2.0 * x1 + t0 + t1;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public CatmullRomSpline transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Matrix4d xform = ti.getMatrix();
        return new CatmullRomSpline(this.type, Util3D.xform(xform, this.p0), Util3D.xform(xform, this.p1), Util3D.xform(xform, this.p2), Util3D.xform(xform, this.p3));
    }

    @Override
    public CatmullRomSpline optimize(IPointOptimizer pool) {
        Point3d p0a = pool.getExisting(this.p0);
        Point3d p1a = pool.getExisting(this.p1);
        Point3d p2a = pool.getExisting(this.p2);
        Point3d p3a = pool.getExisting(this.p3);
        if (p0a == this.p0 && p1a == this.p1 && p2a == this.p2 && p3a == this.p3) {
            return this;
        }
        return new CatmullRomSpline(this.type, p0a, p1a, p2a, p3a);
    }

    @Override
    public Point3d project(Point3d p, double tol) {
        return p;
    }

    @Override
    public Point3d get(double t) {
        if (t == 0.0) {
            return this.p1;
        }
        if (t == 1.0) {
            return this.p2;
        }
        return super.get(t);
    }

    @Override
    public CatmullRomSpline reverse() {
        return new CatmullRomSpline(this.type, this.p3, this.p2, this.p1, this.p0);
    }

    public static enum Type {
        UNIFORM(0.0),
        CHORDAL(1.0),
        CENTRIPETAL(0.5);

        public final double alpha;

        private Type(double alpha) {
            this.alpha = alpha;
        }
    }
}

