/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.APlaneHandle;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class AARectangle
extends AFace
implements IPolygon,
IManipulatable {
    static final long serialVersionUID = 1L;
    public static final byte X = 0;
    public static final byte Y = 1;
    public static final byte Z = 2;
    public final byte d_plane;
    public final double d_planeVal;
    public final double d_minx;
    public final double d_miny;
    public final double d_maxx;
    public final double d_maxy;
    public final boolean flipped;

    public AARectangle() {
        this(2, 0.0, 0.0, 0.0, 1.0, 1.0, false);
    }

    public AARectangle(byte plane, double planeVal, double minx, double miny, double maxx, double maxy, boolean flipped) {
        this.d_minx = minx;
        this.d_miny = miny;
        this.d_maxx = maxx;
        this.d_maxy = maxy;
        this.d_plane = plane;
        this.d_planeVal = planeVal;
        this.flipped = flipped;
    }

    @Override
    public IPolygon optimize(IPointOptimizer pool) {
        return this;
    }

    public static AARectangle construct(Point3d p1, Point3d p2, boolean flipped) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        double planeVal;
        byte plane;
        if (theUtil.eq(p1.x, p2.x, 1.0E-9)) {
            plane = 0;
            planeVal = p1.x;
            minx = Math.min(p1.y, p2.y);
            maxx = Math.max(p1.y, p2.y);
            miny = Math.min(p1.z, p2.z);
            maxy = Math.max(p1.z, p2.z);
        } else if (theUtil.eq(p1.y, p2.y, 1.0E-9)) {
            plane = 1;
            planeVal = p1.y;
            minx = Math.min(p1.x, p2.x);
            maxx = Math.max(p1.x, p2.x);
            miny = Math.min(p1.z, p2.z);
            maxy = Math.max(p1.z, p2.z);
        } else if (theUtil.eq(p1.z, p2.z, 1.0E-9)) {
            plane = 2;
            planeVal = p1.z;
            minx = Math.min(p1.x, p2.x);
            maxx = Math.max(p1.x, p2.x);
            miny = Math.min(p1.y, p2.y);
            maxy = Math.max(p1.y, p2.y);
        } else {
            return null;
        }
        return new AARectangle(plane, planeVal, minx, miny, maxx, maxy, flipped);
    }

    @Override
    public AARectangle flipOrient() {
        return new AARectangle(this.d_plane, this.d_planeVal, this.d_minx, this.d_miny, this.d_maxx, this.d_maxy, !this.flipped);
    }

    @Override
    public AABox getBoundingBox(AABox bb) {
        switch (this.d_plane) {
            case 0: {
                bb.addPoint(this.d_planeVal, this.d_minx, this.d_miny);
                bb.addPoint(this.d_planeVal, this.d_maxx, this.d_maxy);
                break;
            }
            case 1: {
                bb.addPoint(this.d_minx, this.d_planeVal, this.d_miny);
                bb.addPoint(this.d_maxx, this.d_planeVal, this.d_maxy);
                break;
            }
            case 2: {
                bb.addPoint(this.d_minx, this.d_miny, this.d_planeVal);
                bb.addPoint(this.d_maxx, this.d_maxy, this.d_planeVal);
            }
        }
        return bb;
    }

    @Override
    public void getBoundary(List<ICurve> boundary) {
        PolyUtil.getBoundary(boundary, this);
    }

    public Point2d getMin() {
        return new Point2d(this.d_minx, this.d_miny);
    }

    public Point2d getMax() {
        return new Point2d(this.d_maxx, this.d_maxy);
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.ALIGNED;
    }

    private AARectangle transformAligned(TransformInfo xform) {
        Matrix4d mat = xform.getMatrix();
        AABox bb = this.getBoundingBox(new AABox());
        Point3d min = Util3D.xform(mat, bb.getMin());
        Point3d max = Util3D.xform(mat, bb.getMax());
        return AARectangle.construct(min, max, this.flipped);
    }

    @Override
    public IPolygon transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        if (GeomUtil.test(options, 1) && ti.isAccepted(IDOF.ALIGNED)) {
            return this.transformAligned(ti);
        }
        return this.toQuad(ti.getMatrix());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AARectangle)) {
            return false;
        }
        AARectangle rect = (AARectangle)obj;
        return this.d_plane == rect.d_plane && this.d_planeVal == rect.d_planeVal && this.getMin().equals((Tuple2d)rect.getMin()) && this.getMax().equals((Tuple2d)rect.getMax()) && this.flipped == rect.flipped;
    }

    public int hashCode() {
        return this.d_plane + theUtil.hashCode(this.d_planeVal) + this.getMin().hashCode() + this.getMax().hashCode() + Boolean.hashCode(this.flipped);
    }

    public Quad toQuad(Matrix4d parentXform) {
        Point3d p1 = this.getPoint(0, 0);
        Point3d p2 = this.getPoint(0, 1);
        Point3d p3 = this.getPoint(0, 2);
        Point3d p4 = this.getPoint(0, 3);
        if (parentXform != null) {
            parentXform.transform(p1);
            parentXform.transform(p2);
            parentXform.transform(p3);
            parentXform.transform(p4);
        }
        return new Quad(p1, p2, p3, p4);
    }

    @Override
    public Vector3d getNormalIfValid(boolean ccw) {
        Vector3d norm;
        switch (this.d_plane) {
            case 0: {
                norm = new Vector3d(1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                norm = new Vector3d(0.0, 1.0, 0.0);
                break;
            }
            default: {
                norm = new Vector3d(0.0, 0.0, 1.0);
            }
        }
        if (ccw == this.flipped) {
            norm.negate();
        }
        return norm;
    }

    @Override
    public Plane3d getPlaneIfValid(boolean ccw) {
        Plane3d result;
        switch (this.d_plane) {
            case 0: {
                result = new Plane3d(1.0, 0.0, 0.0, -this.d_planeVal);
                break;
            }
            case 1: {
                result = new Plane3d(0.0, 1.0, 0.0, -this.d_planeVal);
                break;
            }
            case 2: {
                result = new Plane3d(0.0, 0.0, 1.0, -this.d_planeVal);
                break;
            }
            default: {
                return null;
            }
        }
        if (ccw == this.flipped) {
            result.negateEq();
        }
        return result;
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int loop) {
        assert (loop == 0);
        return 4;
    }

    @Override
    public Point3d getPoint(int loop, int ix) {
        assert (ix < 4 && loop == 0);
        if (this.flipped) {
            ix = 3 - ix;
        }
        switch (this.d_plane) {
            case 0: {
                switch (ix) {
                    case 0: {
                        return new Point3d(this.d_planeVal, this.d_minx, this.d_miny);
                    }
                    case 1: {
                        return new Point3d(this.d_planeVal, this.d_maxx, this.d_miny);
                    }
                    case 2: {
                        return new Point3d(this.d_planeVal, this.d_maxx, this.d_maxy);
                    }
                }
                return new Point3d(this.d_planeVal, this.d_minx, this.d_maxy);
            }
            case 1: {
                switch (ix) {
                    case 0: {
                        return new Point3d(this.d_minx, this.d_planeVal, this.d_miny);
                    }
                    case 1: {
                        return new Point3d(this.d_minx, this.d_planeVal, this.d_maxy);
                    }
                    case 2: {
                        return new Point3d(this.d_maxx, this.d_planeVal, this.d_maxy);
                    }
                }
                return new Point3d(this.d_maxx, this.d_planeVal, this.d_miny);
            }
        }
        switch (ix) {
            case 0: {
                return new Point3d(this.d_minx, this.d_miny, this.d_planeVal);
            }
            case 1: {
                return new Point3d(this.d_maxx, this.d_miny, this.d_planeVal);
            }
            case 2: {
                return new Point3d(this.d_maxx, this.d_maxy, this.d_planeVal);
            }
        }
        return new Point3d(this.d_minx, this.d_maxy, this.d_planeVal);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double errorTol, boolean ccw) {
        return this.toQuad(null).triangulate(errorTol, ccw);
    }

    @Override
    public IFace.PointClassify classify(Point3d p, double tol) {
        switch (this.d_plane) {
            case 0: {
                return AARectangle.classify(p.y, p.z, this.d_minx, this.d_maxx, this.d_miny, this.d_maxy, tol);
            }
            case 1: {
                return AARectangle.classify(p.x, p.z, this.d_minx, this.d_maxx, this.d_miny, this.d_maxy, tol);
            }
        }
        return AARectangle.classify(p.x, p.y, this.d_minx, this.d_maxx, this.d_miny, this.d_maxy, tol);
    }

    private static IFace.PointClassify classify(double lx, double ly, double minx, double maxx, double miny, double maxy, double tol) {
        if (theUtil.ge(lx, minx, tol) && theUtil.le(lx, maxx, tol) && theUtil.ge(ly, miny, tol) && theUtil.le(ly, maxy, tol)) {
            if (theUtil.eq(lx, minx, tol) || theUtil.eq(lx, maxx, tol) || theUtil.eq(ly, miny, tol) || theUtil.eq(ly, maxy, tol)) {
                return IFace.PointClassify.ON_BOUNDARY;
            }
            return IFace.PointClassify.INSIDE;
        }
        return IFace.PointClassify.OUTSIDE;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new VertHandle(this, 0, 1), new VertHandle(this, 0, 3), new VertHandle(this, 2, 1), new VertHandle(this, 2, 3), new PlaneHandle(this));
    }

    public static class VertHandle
    implements IHandle {
        public static final int MIN_X = 0;
        public static final int MIN_Y = 1;
        public static final int MAX_X = 2;
        public static final int MAX_Y = 3;
        private AARectangle geom;
        private final double[] bounds;
        private final int[] coords;

        public VertHandle(AARectangle geom, int coordx, int coordy) {
            this.geom = geom;
            double[] maxBounds = new double[]{-1.7976931348623157E308, -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE};
            this.bounds = VertHandle.getCoords(geom);
            this.bounds[coordx] = maxBounds[coordx];
            this.bounds[coordy] = maxBounds[coordy];
            this.coords = new int[]{coordx, coordy};
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof VertHandle && Arrays.equals(((VertHandle)obj).coords, this.coords);
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        private static double[] getCoords(AARectangle geom) {
            return new double[]{geom.d_minx, geom.d_miny, geom.d_maxx, geom.d_maxy};
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(new Point(this.getLocation()));
        }

        protected Point3d getLocation() {
            double[] verts = VertHandle.getCoords(this.geom);
            double lx = verts[this.coords[0]];
            double ly = verts[this.coords[1]];
            double lz = this.geom.d_planeVal;
            switch (this.geom.d_plane) {
                case 0: {
                    return new Point3d(lz, lx, ly);
                }
                case 1: {
                    return new Point3d(lx, lz, ly);
                }
                case 2: {
                    return new Point3d(lx, ly, lz);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return new PlanarConstraint(this.geom.getPlane(true));
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public AARectangle modify(Point3d newLoc) throws ManipException {
            double ly;
            double lx;
            switch (this.geom.d_plane) {
                case 0: {
                    lx = newLoc.y;
                    ly = newLoc.z;
                    break;
                }
                case 1: {
                    lx = newLoc.x;
                    ly = newLoc.z;
                    break;
                }
                case 2: {
                    lx = newLoc.x;
                    ly = newLoc.y;
                    break;
                }
                default: {
                    throw new ManipException();
                }
            }
            if (lx < this.bounds[0]) {
                lx = this.bounds[0];
            } else if (lx > this.bounds[2]) {
                lx = this.bounds[2];
            }
            if (ly < this.bounds[1]) {
                ly = this.bounds[1];
            } else if (ly > this.bounds[3]) {
                ly = this.bounds[3];
            }
            double[] verts = VertHandle.getCoords(this.geom);
            verts[this.coords[0]] = lx;
            verts[this.coords[1]] = ly;
            this.geom = new AARectangle(this.geom.d_plane, this.geom.d_planeVal, verts[0], verts[1], verts[2], verts[3], this.geom.flipped);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }

    public static class PlaneHandle
    extends APlaneHandle<AARectangle> {
        public PlaneHandle(AARectangle geom) {
            super(geom);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof PlaneHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode((IGeom)this.getManipGeom());
        }

        @Override
        protected Vector3d getPlaneNormal(AARectangle geom) {
            return geom.getPlane(true).getNormal();
        }

        @Override
        protected AARectangle modify(AARectangle origGeom, double offset) {
            return new AARectangle(origGeom.d_plane, origGeom.d_planeVal + offset, origGeom.d_minx, origGeom.d_miny, origGeom.d_maxx, origGeom.d_maxy, origGeom.flipped);
        }
    }
}

