/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.Serializable;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.nmt.CloneMap;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Vertex;

public class EdgeUse
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Edge edge;
    public final boolean orient;

    public EdgeUse(Edge edge, boolean orient) {
        this.edge = edge;
        this.orient = orient;
    }

    public Vertex v1() {
        return this.orient ? this.edge.v1 : this.edge.v2;
    }

    public Vertex v2() {
        return this.orient ? this.edge.v2 : this.edge.v1;
    }

    public synchronized IParametric3D curve() {
        return this.orient ? this.edge.curve : this.edge.curve.reverse();
    }

    public String toString() {
        return "[EdgeUse] " + this.orient + ": " + this.edge.v1 + " -> " + this.edge.v2;
    }

    public Vector3d getTangent(double t) {
        if (this.orient) {
            return this.edge.curve.getTangent(t);
        }
        Vector3d tan = this.edge.curve.getTangent(1.0 - t);
        tan.negate();
        return tan;
    }

    public EdgeUse reverse() {
        return new EdgeUse(this.edge, !this.orient);
    }

    public EdgeUse clone(CloneMap cloneMap) {
        return new EdgeUse(cloneMap.get(this.edge), this.orient);
    }
}

