/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.CloneMap;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Vertex;

public class Edge
extends AModelObj {
    static final long serialVersionUID = 1L;
    public Vertex v1;
    public Vertex v2;
    public IParametric3D curve;
    public transient List<Face> faces = new ArrayList<Face>(3);

    public Edge(Vertex v1, Vertex v2, IParametric3D curve) {
        this.v1 = v1;
        this.v2 = v2;
        this.curve = curve;
    }

    @Override
    public AABox getBounds() {
        AABox bb = new AABox();
        bb.add(this.v1.loc, this.v2.loc);
        return bb;
    }

    public String toString() {
        return String.format("[Edge] %s -> %s", this.v1.loc.toString(), this.v2.loc.toString());
    }

    public Edge clone(CloneMap cloneMap) {
        Edge clone = (Edge)this.clone();
        clone.v1 = cloneMap.get(this.v1);
        clone.v2 = cloneMap.get(this.v2);
        clone.faces = new ArrayList<Face>(this.faces.size());
        return clone;
    }

    public boolean isConnected() {
        return !this.faces.isEmpty();
    }

    public void clearConnections() {
        this.v1.edges.remove(this);
        this.v2.edges.remove(this);
    }

    public void buildConnections() {
        this.v1.addEdge(this);
        this.v2.addEdge(this);
    }

    public Vertex otherVert(Vertex v) {
        return v == this.v1 ? this.v2 : this.v1;
    }

    public void addFace(Face face) {
        if (!this.faces.contains(face)) {
            this.faces.add(face);
        }
    }

    public void addAllFaces(Collection<Face> faces) {
        for (Face face : faces) {
            if (this.faces.contains(face)) continue;
            this.faces.add(face);
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.faces);
    }

    @Override
    public void readTopology(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.faces = (List)stream.readObject();
    }
}

