/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.util.Pair;

public class BooleanOp {
    private static final int INCLUDE_POS = 1;
    private static final int INCLUDE_NEG = 2;

    public static Model subtract(Model modelA, boolean model1Solid, Model modelB, boolean model2Solid) {
        return (Model)BooleanOp.intersect((Model)modelA, (boolean)model1Solid, (Model)modelB, (boolean)model2Solid, (boolean)false).v1;
    }

    public static Pair<Model, Model> subtractAndIntersect(Model modelA, boolean model1Solid, Model modelB, boolean model2Solid) {
        return BooleanOp.intersect(modelA, model1Solid, modelB, model2Solid, true);
    }

    private static Pair<Model, Model> intersect(Model modelA, boolean model1Solid, Model modelB, boolean model2Solid, boolean keepSubtractRegion) {
        Supplier<Boolean> testIsModified;
        Consumer<Face> consumeNegAddFaces;
        if (model1Solid && !model2Solid) {
            return new Pair<Model, Object>(modelA, null);
        }
        int keepId = 0x7FFFFFFE;
        int subId = Integer.MAX_VALUE;
        Model pos = (Model)modelA.clone();
        pos.addGroupId(keepId);
        Model model2Clone = (Model)modelB.clone();
        model2Clone.addGroupId(subId);
        pos.merge(model2Clone);
        ArrayList<Face> posDelFaces = new ArrayList<Face>();
        ArrayList negAddFaces = new ArrayList();
        Consumer<Face> consumer = keepSubtractRegion ? negAddFaces::add : (consumeNegAddFaces = f -> {});
        if (model1Solid && model2Solid) {
            for (Face face : pos.getFaces()) {
                int cats = BooleanOp.categorizeIsectFace(modelA, modelB, keepId, subId, pos, face);
                if ((cats & 1) == 0) {
                    posDelFaces.add(face);
                }
                if ((cats & 2) == 0) continue;
                consumeNegAddFaces.accept(face);
            }
        } else if (!model1Solid && model2Solid) {
            for (Face face : pos.getFaces()) {
                if (face.partOfGroup(subId)) {
                    posDelFaces.add(face);
                    if (!face.partOfGroup(keepId)) continue;
                    consumeNegAddFaces.accept(face);
                    continue;
                }
                if (!face.partOfGroup(keepId) || !NmtUtil.faceInSolid(modelB, pos, face)) continue;
                posDelFaces.add(face);
                consumeNegAddFaces.accept(face);
            }
        } else {
            assert (!model1Solid && !model2Solid);
            for (Face face : pos.getFaces()) {
                if (!face.partOfGroup(subId)) continue;
                posDelFaces.add(face);
                if (!face.partOfGroup(keepId)) continue;
                consumeNegAddFaces.accept(face);
            }
        }
        if (!(testIsModified = () -> {
            for (Face delFace : posDelFaces) {
                if (!delFace.partOfGroup(keepId)) continue;
                return true;
            }
            for (Face face : pos.getFaces()) {
                if (!face.partOfGroup(subId) || face.partOfGroup(keepId) || posDelFaces.contains(face)) continue;
                return true;
            }
            return false;
        }).get().booleanValue()) {
            return new Pair<Model, Object>(modelA, null);
        }
        Model neg = null;
        if (keepSubtractRegion) {
            neg = new Model();
            for (Face face : negAddFaces) {
                neg.addFace(face, face.groups);
            }
            neg.removeGroupIds(keepId, subId);
        }
        for (Face delFace : posDelFaces) {
            pos.deleteFace(delFace, true, true);
        }
        pos.removeGroupIds(keepId, subId);
        return new Pair<Model, Model>(pos, neg);
    }

    private static int categorizeIsectFace(Model keepModel, Model subModel, int keepId, int subId, Model model, Face face) {
        boolean partOfSubGroup = face.partOfGroup(subId);
        boolean partOfKeepGroup = face.partOfGroup(keepId);
        if (partOfSubGroup && !partOfKeepGroup && !NmtUtil.faceInSolid(keepModel, model, face)) {
            return 0;
        }
        if (!partOfSubGroup && partOfKeepGroup && NmtUtil.faceInSolid(subModel, model, face)) {
            return 2;
        }
        if (partOfSubGroup && partOfKeepGroup) {
            Point3d testp = model.findPointInFace(face);
            if (testp == null) {
                return 1;
            }
            Vector3d normal = face.plane.getNormal();
            normal.scale(2.0E-6);
            testp.add((Tuple3d)normal);
            boolean inMod1 = keepModel.contains(testp);
            boolean inMod2 = subModel.contains(testp);
            return inMod1 == inMod2 ? 2 : 1;
        }
        return partOfSubGroup ? 3 : 1;
    }
}

