/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;

public class TriInterpolator3d
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Point3d A;
    public final Point2d A2d;
    public final Point2d B2d;
    public final Point2d C2d;
    public final Matrix3d rot;

    public TriInterpolator3d(Point3d A, Point3d B, Point3d C) {
        this.A = A;
        Vector3d e1 = new Vector3d(1.0, 0.0, 0.0);
        Vector3d e2 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d e3 = new Vector3d(0.0, 0.0, 1.0);
        Point3d Btrans = new Point3d(B.x - A.x, B.y - A.y, B.z - A.z);
        Point3d Ctrans = new Point3d(C.x - A.x, C.y - A.y, C.z - A.z);
        Vector3d e1t = new Vector3d((Tuple3d)Btrans);
        Vector3d e3t = Util3D.cross(e1t, new Vector3d((Tuple3d)Ctrans));
        Vector3d e2t = Util3D.cross(e3t, e1t);
        e1t.normalize();
        e2t.normalize();
        e3t.normalize();
        this.rot = new Matrix3d(e1.dot(e1t), e2.dot(e1t), e3.dot(e1t), e1.dot(e2t), e2.dot(e2t), e3.dot(e2t), e1.dot(e3t), e2.dot(e3t), e3.dot(e3t));
        this.rot.transform((Tuple3d)Btrans);
        this.rot.transform((Tuple3d)Ctrans);
        this.A2d = new Point2d(0.0, 0.0);
        this.B2d = new Point2d(Btrans.x, Btrans.y);
        this.C2d = new Point2d(Ctrans.x, Ctrans.y);
    }

    public double[] getParams(Point3d P) {
        Vector3d Ptrans = Util3D.vector(this.A, P);
        this.rot.transform((Tuple3d)Ptrans);
        Point2d P2d = new Point2d(Ptrans.x, Ptrans.y);
        return Util2D.getInterpolateParams(this.A2d, this.B2d, this.C2d, P2d);
    }

    public double interpolate(double[] pparams, double valA, double valB, double valC) {
        return Util2D.interpolate(valA, valB, valC, pparams);
    }

    public double interpolate(Point3d P, double valA, double valB, double valC) {
        if (valA == valB && valA == valC) {
            return valA;
        }
        double[] params = this.getParams(P);
        return this.interpolate(params, valA, valB, valC);
    }
}

