/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.io.Serializable;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Spline2D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theMath;
import thunderheadeng.util.theUtil;

public interface Spline3D
extends IParametric3D {

    public static class Quadratic
    extends Cubic
    implements Spline3D {
        static final long serialVersionUID = 1L;

        public Quadratic(Point3d p1, Point3d c, Point3d p2) {
            super(p1, c, c, p2, 0.0, 0.0, 0.0, p2.x - 2.0 * c.x + p1.x, p2.y - 2.0 * c.y + p1.y, p2.z - 2.0 * c.z + p1.z, 2.0 * c.x - 2.0 * p1.x, 2.0 * c.y - 2.0 * p1.y, 2.0 * c.z - 2.0 * p1.z, p1.x, p1.y, p1.z);
        }

        @Override
        public IParametric2D projectToPlane(Plane3d plane, Matrix4d wlXform) {
            return new Spline2D.Quadratic(Quadratic.project(this.getP1(), plane, wlXform), Quadratic.project(this.getC1(), plane, wlXform), Quadratic.project(this.getP2(), plane, wlXform));
        }

        @Override
        public IParametric3D transform(Matrix4d xform) {
            return new Quadratic(Util3D.xform(xform, this.getP1()), Util3D.xform(xform, this.getC1()), Util3D.xform(xform, this.getP2()));
        }

        @Override
        public IParametric2D transform2D(Matrix4d xform) {
            return new Spline2D.Quadratic(Quadratic.xform2d(xform, this.getP1()), Quadratic.xform2d(xform, this.getC1()), Quadratic.xform2d(xform, this.getP2()));
        }

        @Override
        public IParametric3D reverse() {
            return new Quadratic(this.getP2(), this.getC1(), this.getP1());
        }
    }

    public static class Cubic
    implements Spline3D,
    Serializable {
        static final long serialVersionUID = 1L;
        private final Point3d p1;
        private final Point3d c1;
        private final Point3d c2;
        private final Point3d p2;
        private final double ax;
        private final double bx;
        private final double cx;
        private final double dx;
        private final double ay;
        private final double by;
        private final double cy;
        private final double dy;
        private final double az;
        private final double bz;
        private final double cz;
        private final double dz;

        public Cubic(Point3d p1, Point3d c1, Point3d c2, Point3d p2) {
            this(p1, c1, c2, p2, p2.x - 3.0 * c2.x + 3.0 * c1.x - p1.x, p2.y - 3.0 * c2.y + 3.0 * c1.y - p1.y, p2.z - 3.0 * c2.z + 3.0 * c1.z - p1.z, 3.0 * c2.x - 6.0 * c1.x + 3.0 * p1.x, 3.0 * c2.y - 6.0 * c1.y + 3.0 * p1.y, 3.0 * c2.z - 6.0 * c1.z + 3.0 * p1.z, 3.0 * c1.x - 3.0 * p1.x, 3.0 * c1.y - 3.0 * p1.y, 3.0 * c1.z - 3.0 * p1.z, p1.x, p1.y, p1.z);
        }

        protected Cubic(Point3d p1, Point3d c1, Point3d c2, Point3d p2, double ax, double ay, double az, double bx, double by, double bz, double cx, double cy, double cz, double dx, double dy, double dz) {
            this.p1 = p1;
            this.c1 = c1;
            this.c2 = c2;
            this.p2 = p2;
            this.ax = ax;
            this.ay = ay;
            this.az = az;
            this.bx = bx;
            this.by = by;
            this.bz = bz;
            this.cx = cx;
            this.cy = cy;
            this.cz = cz;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
        }

        @Override
        public boolean isLinear() {
            return false;
        }

        @Override
        public IParametric3D reverse() {
            return new Cubic(this.p2, this.c2, this.c1, this.p1);
        }

        @Override
        public Point3d get(double t) {
            if (t == 1.0) {
                return new Point3d(this.p2);
            }
            double t2 = t * t;
            double t3 = t2 * t;
            return new Point3d(this.ax * t3 + this.bx * t2 + this.cx * t + this.dx, this.ay * t3 + this.by * t2 + this.cy * t + this.dy, this.az * t3 + this.bz * t2 + this.cz * t + this.dz);
        }

        @Override
        public Vector3d getTangent(double t) {
            double t2 = t * t;
            return new Vector3d(3.0 * this.ax * t2 + 2.0 * this.bx * t + this.cx, 3.0 * this.ay * t2 + 2.0 * this.by * t + this.cy, 3.0 * this.az * t2 + 2.0 * this.bz * t + this.cz);
        }

        public Point3d getP1() {
            return this.p1;
        }

        public Point3d getP2() {
            return this.p2;
        }

        public Point3d getC1() {
            return this.c1;
        }

        public Point3d getC2() {
            return this.c2;
        }

        @Override
        public double length() {
            return this.p1.distance(this.c1) + this.c1.distance(this.c2) + this.c2.distance(this.p2);
        }

        @Override
        public double getClosestT(Point3d point) {
            return Double.NaN;
        }

        @Override
        public double[] getIsects(Plane3d plane, double tol) {
            double a = plane.x * this.ax + plane.y * this.ay + plane.z * this.az;
            double b = plane.x * this.bx + plane.y * this.by + plane.z * this.bz;
            double c = plane.x * this.cx + plane.y * this.cy + plane.z * this.cz;
            double d = plane.w;
            double[] roots = theMath.solveCubic(a, b, c, d);
            ArrayList<Double> validRoots = new ArrayList<Double>(roots.length);
            for (int m = 0; m < roots.length; ++m) {
                double clamp = Util.clampTIfValid(roots[m], 0.0, 1.0, tol);
                if (Double.isNaN(clamp)) continue;
                validRoots.add(clamp);
            }
            return theUtil.toDoubleArray(validRoots);
        }

        protected static Point2d project(Point3d p, Plane3d plane, Matrix4d wlXform) {
            Point3d proj = plane.projectOntoPlane(p);
            wlXform.transform(proj);
            return new Point2d(proj.x, proj.y);
        }

        @Override
        public IParametric2D projectToPlane(Plane3d plane, Matrix4d wlXform) {
            return new Spline2D.Cubic(Cubic.project(this.p1, plane, wlXform), Cubic.project(this.c1, plane, wlXform), Cubic.project(this.c2, plane, wlXform), Cubic.project(this.p2, plane, wlXform));
        }

        @Override
        public IParametric3D transform(Matrix4d xform) {
            return new Cubic(Util3D.xform(xform, this.p1), Util3D.xform(xform, this.c1), Util3D.xform(xform, this.c2), Util3D.xform(xform, this.p2));
        }

        @Override
        public IParametric2D transform2D(Matrix4d xform) {
            return new Spline2D.Cubic(Cubic.xform2d(xform, this.p1), Cubic.xform2d(xform, this.c1), Cubic.xform2d(xform, this.c2), Cubic.xform2d(xform, this.p2));
        }

        protected static Point2d xform2d(Matrix4d xform, Point3d p) {
            Point3d pt = Util3D.xform(xform, p);
            return new Point2d(pt.x, pt.y);
        }
    }
}

