/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.awt.geom.QuadCurve2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import thunderheadeng.geometry.AParametric2D;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.LineSeg2D;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.util.theMath;

public interface Spline2D
extends IParametric2D {
    public Shape toShape();

    public static class Quadratic
    extends Cubic
    implements Spline2D,
    Serializable {
        static final long serialVersionUID = 1L;

        public Quadratic(Point2d p1, Point2d c, Point2d p2) {
            super(p1, c, c, p2);
        }

        @Override
        protected void calcParams() {
            this.ay = 0.0;
            this.ax = 0.0;
            this.bx = this.p2.x - 2.0 * this.c1.x + this.p1.x;
            this.by = this.p2.y - 2.0 * this.c1.y + this.p1.y;
            this.cx = 2.0 * this.c1.x - 2.0 * this.p1.x;
            this.cy = 2.0 * this.c1.y - 2.0 * this.p1.y;
            this.dx = this.p1.x;
            this.dy = this.p1.y;
        }

        @Override
        public IParametric2D reverse() {
            return new Quadratic(this.p2, this.c1, this.p1);
        }

        @Override
        public IParametric2D subsegment(double t1, double t2) {
            QuadCurve2D curve;
            if (t2 < t1) {
                curve = (QuadCurve2D)((Quadratic)this.reverse()).toShape();
                double temp = t1;
                t1 = 1.0 - t2;
                t2 = 1.0 - temp;
            } else {
                curve = (QuadCurve2D)this.toShape();
            }
            curve = ShapeUtil.subcurve(curve, t1, t2);
            return new Quadratic(new Point2d(curve.getX1(), curve.getY1()), new Point2d(curve.getCtrlX(), curve.getCtrlY()), new Point2d(curve.getX2(), curve.getY2()));
        }

        @Override
        public Shape toShape() {
            return new QuadCurve2D.Double(this.p1.x, this.p1.y, this.c1.x, this.c1.y, this.p2.x, this.p2.y);
        }

        @Override
        public void append(Path2D.Double path) {
            path.quadTo(this.c1.x, this.c1.y, this.p2.x, this.p2.y);
        }
    }

    public static class Cubic
    extends AParametric2D
    implements Spline2D,
    Serializable {
        static final long serialVersionUID = 1L;
        protected final Point2d p1;
        protected final Point2d c1;
        protected final Point2d c2;
        protected final Point2d p2;
        protected double ax;
        protected double bx;
        protected double cx;
        protected double dx;
        protected double ay;
        protected double by;
        protected double cy;
        protected double dy;

        public Cubic(Point2d p1, Point2d c1, Point2d c2, Point2d p2) {
            this.p1 = p1;
            this.c1 = c1;
            this.c2 = c2;
            this.p2 = p2;
            this.calcParams();
        }

        @Override
        public boolean epsilonEquals(IParametric2D parm2, double tolerance) {
            if (this == parm2) {
                return true;
            }
            if (!(parm2 instanceof Cubic)) {
                return false;
            }
            Cubic cubic = (Cubic)parm2;
            return this.p1.epsilonEquals((Tuple2d)cubic.p1, tolerance) && this.p2.epsilonEquals((Tuple2d)cubic.p2, tolerance) && this.c1.epsilonEquals((Tuple2d)cubic.c1, tolerance) && this.c2.epsilonEquals((Tuple2d)cubic.c2, tolerance);
        }

        @Override
        public Point2d get(double t) {
            if (t == 1.0) {
                return new Point2d(this.p2);
            }
            double t2 = t * t;
            double t3 = t2 * t;
            return new Point2d(this.ax * t3 + this.bx * t2 + this.cx * t + this.dx, this.ay * t3 + this.by * t2 + this.cy * t + this.dy);
        }

        protected void calcParams() {
            this.ax = this.p2.x - 3.0 * this.c2.x + 3.0 * this.c1.x - this.p1.x;
            this.ay = this.p2.y - 3.0 * this.c2.y + 3.0 * this.c1.y - this.p1.y;
            this.bx = 3.0 * this.c2.x - 6.0 * this.c1.x + 3.0 * this.p1.x;
            this.by = 3.0 * this.c2.y - 6.0 * this.c1.y + 3.0 * this.p1.y;
            this.cx = 3.0 * this.c1.x - 3.0 * this.p1.x;
            this.cy = 3.0 * this.c1.y - 3.0 * this.p1.y;
            this.dx = this.p1.x;
            this.dy = this.p1.y;
        }

        @Override
        public Vector2d getTangent(double t) {
            double t2 = t * t;
            return new Vector2d(3.0 * this.ax * t2 + 2.0 * this.bx * t + this.cx, 3.0 * this.ay * t2 + 2.0 * this.by * t + this.cy);
        }

        public Point2d getP1() {
            return this.p1;
        }

        public Point2d getP2() {
            return this.p2;
        }

        public Point2d getC1() {
            return this.c1;
        }

        public Point2d getC2() {
            return this.c2;
        }

        @Override
        public void setBegin(Point2d p) {
            this.p1.set((Tuple2d)p);
            this.calcParams();
        }

        @Override
        public void setEnd(Point2d p) {
            this.p2.set((Tuple2d)p);
            this.calcParams();
        }

        @Override
        public double length() {
            return 0.0;
        }

        @Override
        public boolean isValid(double tol) {
            double testLen = this.p1.distanceLinf(this.c1);
            testLen += this.c1.distanceLinf(this.c2);
            return (testLen += this.c2.distanceLinf(this.p2)) >= tol;
        }

        @Override
        public List<double[]> getIsects(IParametric2D parm2, double tol) {
            if (parm2 instanceof LineSeg2D) {
                LineSeg2D ls = (LineSeg2D)parm2;
                return this.getLinesegIsects(ls.p1, ls.p2, tol);
            }
            if (parm2 instanceof Spline2D) {
                return Collections.EMPTY_LIST;
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<double[][]> getAlignedSegs(IParametric2D parm2, double tol) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public double getClosestT(Point2d point) {
            return this.getClosestPointPW(point, 10, 12);
        }

        private double clamp(double value, double lowerLimit, double upperLimit) {
            if (value < lowerLimit) {
                return lowerLimit;
            }
            if (value > upperLimit) {
                return upperLimit;
            }
            return value;
        }

        private double getClosestPointPW(Point2d testPoint, int numSegments, int maxIterations) {
            if (numSegments < 4) {
                numSegments = 4;
            }
            Point2d[] samplePoints = new Point2d[numSegments + 1];
            samplePoints[0] = this.get(0.0);
            samplePoints[1] = this.get(1.0);
            double mult = 1.0 / (double)numSegments;
            for (int m = 0; m <= numSegments; ++m) {
                double t = (double)m * mult;
                samplePoints[m] = this.get(t);
            }
            ArrayList<double[]> dists = new ArrayList<double[]>();
            for (int m = 0; m < numSegments; ++m) {
                Point2d p1 = samplePoints[m];
                Point2d p2 = samplePoints[m + 1];
                double neart = Inter2D.nearestTOnLineSeg(testPoint, p1, p2);
                double p1t = (double)m * mult;
                double splinet = p1t + neart * mult;
                Point2d nearPt = Util2D.linePoint(p1, p2, neart);
                double dist = nearPt.distanceSquared(testPoint);
                dists.add(new double[]{dist, splinet});
            }
            assert (dists.size() >= 4);
            double closestT = Double.MAX_VALUE;
            double closestDist = Double.MAX_VALUE;
            Collections.sort(dists, (o1, o2) -> Double.compare(o1[0], o2[0]));
            Iterator entryit = dists.iterator();
            for (int m = 0; m < 4; ++m) {
                double[] entry = (double[])entryit.next();
                double refined = this.getClosestTNewton(testPoint, entry[1], maxIterations);
                double dist = this.get(refined).distanceSquared(testPoint);
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closestT = refined;
            }
            return closestT;
        }

        private double getClosestPointBF(Point2d testPoint, double resolution) {
            double closestDist = Double.MAX_VALUE;
            double closestT = -1.0;
            for (double t = 0.0; t <= 1.0; t += resolution) {
                double dist = this.get(t).distanceSquared(testPoint);
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closestT = t;
            }
            return closestT;
        }

        private double getClosestTNewton(Point2d testPoint, double bestGuessT, int maxIterations) {
            double sk = bestGuessT;
            double skLast = bestGuessT;
            double termCond = 1.0E-6;
            for (int m = 0; m < maxIterations; ++m) {
                double grad;
                double sk2 = sk * sk;
                double sk3 = sk2 * sk;
                double sk4 = sk3 * sk;
                double curv = 2.0 * this.cy * this.cy + 2.0 * this.cx * this.cx + (-4.0 * testPoint.x + 4.0 * this.dx + 12.0 * sk * this.cx) * this.bx + 12.0 * sk2 * this.bx * this.bx + (-12.0 * sk * testPoint.y + 12.0 * sk * this.dy + 24.0 * sk2 * this.cy) * this.ay + 30.0 * sk4 * this.ay * this.ay + (-12.0 * sk * testPoint.x + 12.0 * sk * this.dx + 24.0 * sk2 * this.cx + 40.0 * sk3 * this.bx) * this.ax + 30.0 * sk4 * this.ax * this.ax + (-4.0 * testPoint.y + 4.0 * this.dy + 12.0 * sk * this.cy + 40.0 * sk3 * this.ay) * this.by + 12.0 * sk2 * this.by * this.by;
                if (curv == 0.0) {
                    return bestGuessT;
                }
                if ((sk -= (grad = 2.0 * (this.ax * sk3 + this.bx * sk2 + this.cx * sk + this.dx - testPoint.x) * (3.0 * this.ax * sk2 + 2.0 * this.bx * sk + this.cx) + 2.0 * (this.ay * sk3 + this.by * sk2 + this.cy * sk + this.dy - testPoint.y) * (3.0 * this.ay * sk2 + 2.0 * this.by * sk + this.cy)) / curv) < 0.0 || sk > 1.0) {
                    return bestGuessT;
                }
                if (m > 0 && Math.abs(sk - skLast) <= termCond) {
                    return sk;
                }
                skLast = sk;
            }
            return sk;
        }

        private double getClosestPointNM(Point2d testPoint, double s1, double s2, double s3, int maxIterations) {
            double[] s = new double[]{s1, s2, s3};
            double[] Ds = new double[3];
            double sk = Double.MAX_VALUE;
            double skLast = Double.MAX_VALUE;
            double[] Ps = new double[4];
            double termCond = 0.001;
            for (int m = 0; m < maxIterations; ++m) {
                int i;
                Ds[0] = this.get(s[0]).distanceSquared(testPoint);
                Ds[1] = this.get(s[1]).distanceSquared(testPoint);
                Ds[2] = this.get(s[2]).distanceSquared(testPoint);
                double denom = (s[1] - s[2]) * Ds[0] + (s[2] - s[0]) * Ds[1] + (s[0] - s[1]) * Ds[2];
                if (denom == 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                sk = 0.5 * ((s[1] * s[1] - s[2] * s[2]) * Ds[0] + (s[2] * s[2] - s[0] * s[0]) * Ds[1] + (s[0] * s[0] - s[1] * s[1]) * Ds[2]) / denom;
                if (sk < 0.0 || sk > 1.0) {
                    return Double.POSITIVE_INFINITY;
                }
                double grad = (-2.0 * testPoint.y + 2.0 * this.dy) * this.cy + 2.0 * sk * this.cy * this.cy + (-2.0 * testPoint.x + 2.0 * this.dx) * this.cx + 2.0 * sk * this.cx * this.cx + (-4.0 * sk * testPoint.x + 4.0 * sk * this.dx + 6.0 * sk * sk * this.cx) * this.bx + 4.0 * sk * sk * sk * this.bx * this.bx + (-6.0 * sk * sk * testPoint.y + 6.0 * sk * sk * this.dy + 8.0 * sk * sk * sk * this.cy) * this.ay + 6.0 * sk * sk * sk * sk * sk * this.ay * this.ay + (-6.0 * sk * sk * testPoint.x + 6.0 * sk * sk * this.dx + 8.0 * sk * sk * sk * this.cx + 10.0 * sk * sk * sk * sk * this.bx) * this.ax + 6.0 * sk * sk * sk * sk * sk * this.ax * this.ax + (-4.0 * sk * testPoint.y + 4.0 * sk * this.dy + 6.0 * sk * sk * this.cy + 10.0 * sk * sk * sk * sk * this.ay) * this.by + 4.0 * sk * sk * sk * this.by * this.by;
                double curv = 2.0 * this.cy * this.cy + 2.0 * this.cx * this.cx + (-4.0 * testPoint.x + 4.0 * this.dx + 12.0 * sk * this.cx) * this.bx + 12.0 * sk * sk * this.bx * this.bx + (-12.0 * sk * testPoint.y + 12.0 * sk * this.dy + 24.0 * sk * sk * this.cy) * this.ay + 30.0 * sk * sk * sk * sk * this.ay * this.ay + (-12.0 * sk * testPoint.x + 12.0 * sk * this.dx + 24.0 * sk * sk * this.cx + 40.0 * sk * sk * sk * this.bx) * this.ax + 30.0 * sk * sk * sk * sk * this.ax * this.ax + (-4.0 * testPoint.y + 4.0 * this.dy + 12.0 * sk * this.cy + 40.0 * sk * sk * sk * this.ay) * this.by + 12.0 * sk * sk * this.by * this.by;
                if (curv != 0.0 && ((sk -= grad / curv) < 0.0 || sk > 1.0)) {
                    return Double.POSITIVE_INFINITY;
                }
                if (m > 0 && Math.abs(sk - skLast) <= termCond) {
                    return sk;
                }
                skLast = sk;
                Ps[0] = (s[0] - s[1]) * (s[0] - s[2]) / ((s[0] - s[1]) * (s[0] - s[2])) * Ds[0];
                Ps[1] = (s[1] - s[0]) * (s[1] - s[2]) / ((s[1] - s[0]) * (s[1] - s[2])) * Ds[1];
                Ps[2] = (s[2] - s[0]) * (s[2] - s[1]) / ((s[2] - s[0]) * (s[2] - s[1])) * Ds[2];
                Ps[3] = (sk - s[1]) * (sk - s[2]) / ((s[0] - s[1]) * (s[0] - s[2])) * Ds[0] + (sk - s[0]) * (sk - s[2]) / ((s[1] - s[0]) * (s[1] - s[2])) * Ds[1] + (sk - s[0]) * (sk - s[1]) / ((s[2] - s[0]) * (s[2] - s[1])) * Ds[2];
                int biggest = 0;
                for (i = 1; i < 4; ++i) {
                    if (!(Ps[i] > Ps[biggest])) continue;
                    biggest = i;
                }
                if (biggest > 2) continue;
                s[biggest] = sk;
                for (i = 0; i < 3; ++i) {
                    for (int j = i + 1; j < 3; ++j) {
                        if (s[i] != s[j]) continue;
                        s[j] = s[j] < 0.5 ? s[j] + 1.0E-4 : s[j] - 1.0E-4;
                    }
                }
            }
            return sk;
        }

        @Override
        public List<double[]> getLineIsects(Point2d l1, Vector2d dir, double tol) {
            ArrayList<double[]> isects = new ArrayList<double[]>();
            double idirlen = 1.0 / dir.length();
            Vector2d t = new Vector2d(dir);
            t.scale(idirlen);
            Vector2d n = new Vector2d();
            n.set(-t.y, t.x);
            double k1 = this.ax * n.x + this.ay * n.y;
            double k2 = this.bx * n.x + this.by * n.y;
            double k3 = this.cx * n.x + this.cy * n.y;
            double k4 = (this.dx - l1.x) * n.x + (this.dy - l1.y) * n.y;
            double[] splineRoots = theMath.solveCubic(k1, k2, k3, k4);
            if (splineRoots.length == 0) {
                return isects;
            }
            double k1a = this.ax * t.x + this.ay * t.y;
            double k2a = this.bx * t.x + this.by * t.y;
            double k3a = this.cx * t.x + this.cy * t.y;
            double k4a = (this.dx - l1.x) * t.x + (this.dy - l1.y) * t.y;
            for (double splineRoot : splineRoots) {
                if (Double.isNaN(splineRoot = Util.clampTIfValid(splineRoot, 0.0, 1.0, tol))) continue;
                double sr2 = splineRoot * splineRoot;
                double sr3 = sr2 * splineRoot;
                double lineRoot = k1a * sr3 + k2a * sr2 + k3a * splineRoot + k4a;
                isects.add(new double[]{splineRoot, lineRoot *= idirlen});
            }
            return isects;
        }

        @Override
        public IParametric2D reverse() {
            return new Cubic(this.p2, this.c2, this.c1, this.p1);
        }

        @Override
        public IParametric2D subsegment(double t1, double t2) {
            CubicCurve2D curve;
            if (t2 < t1) {
                curve = (CubicCurve2D)((Cubic)this.reverse()).toShape();
                double temp = t1;
                t1 = 1.0 - t2;
                t2 = 1.0 - temp;
            } else {
                curve = (CubicCurve2D)this.toShape();
            }
            curve = ShapeUtil.subcurve(curve, t1, t2);
            return new Cubic(new Point2d(curve.getX1(), curve.getY1()), new Point2d(curve.getCtrlX1(), curve.getCtrlY1()), new Point2d(curve.getCtrlX2(), curve.getCtrlY2()), new Point2d(curve.getX2(), curve.getY2()));
        }

        @Override
        public Shape toShape() {
            return new CubicCurve2D.Double(this.p1.x, this.p1.y, this.c1.x, this.c1.y, this.c2.x, this.c2.y, this.p2.x, this.p2.y);
        }

        @Override
        public void append(Path2D.Double path) {
            path.curveTo(this.c1.x, this.c1.y, this.c2.x, this.c2.y, this.p2.x, this.p2.y);
        }
    }
}

