/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SerPathIterator
implements Serializable {
    static final long serialVersionUID = 1L;
    private List<PathSegment> segs;
    private int windRule;

    public SerPathIterator(PathIterator pi) {
        if (pi == null) {
            this.segs = null;
            this.windRule = -1;
            return;
        }
        this.segs = new ArrayList<PathSegment>();
        this.windRule = pi.getWindingRule();
        double[] coords6 = new double[6];
        while (!pi.isDone()) {
            int op = pi.currentSegment(coords6);
            double[] coords = new double[this.opArgs(op)];
            System.arraycopy(coords6, 0, coords, 0, coords.length);
            this.segs.add(new PathSegment(op, coords));
            pi.next();
        }
    }

    public List<PathSegment> getSegs() {
        return this.segs;
    }

    public int getWindRule() {
        return this.windRule;
    }

    public void dump(PrintStream out) {
        for (PathSegment seg : this.segs) {
            out.println(this.op2str(seg.segType) + "  " + Arrays.toString(seg.dcoords));
        }
    }

    private int opArgs(int op) {
        switch (op) {
            case 4: {
                return 0;
            }
            case 3: {
                return 6;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return -1;
    }

    private String op2str(int op) {
        switch (op) {
            case 4: {
                return "SEG_CLOSE";
            }
            case 3: {
                return "SEG_CUBICTO";
            }
            case 1: {
                return "SEG_LINETO";
            }
            case 0: {
                return "SEG_MOVETO";
            }
            case 2: {
                return "SEG_QUADTO";
            }
        }
        return "Invalid function input: op2str(" + op + ")";
    }

    public Path2D.Double toPath() {
        if (this.segs == null) {
            return null;
        }
        Path2D.Double gp = new Path2D.Double(this.windRule, this.segs.size());
        for (PathSegment seg : this.segs) {
            switch (seg.segType) {
                case 4: {
                    gp.closePath();
                    break;
                }
                case 3: {
                    gp.curveTo(seg.dcoords[0], seg.dcoords[1], seg.dcoords[2], seg.dcoords[3], seg.dcoords[4], seg.dcoords[5]);
                    break;
                }
                case 1: {
                    gp.lineTo(seg.dcoords[0], seg.dcoords[1]);
                    break;
                }
                case 0: {
                    gp.moveTo(seg.dcoords[0], seg.dcoords[1]);
                    break;
                }
                case 2: {
                    gp.quadTo(seg.dcoords[0], seg.dcoords[1], seg.dcoords[2], seg.dcoords[3]);
                }
            }
        }
        return gp;
    }

    public static class PathSegment
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final int segType;
        public final float[] coords;
        public double[] dcoords;

        public PathSegment(int segType, double[] coords) {
            this.segType = segType;
            this.dcoords = coords;
            this.coords = null;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.dcoords == null) {
                assert (this.coords != null);
                this.dcoords = new double[this.coords.length];
                for (int m = 0; m < this.coords.length; ++m) {
                    this.dcoords[m] = this.coords[m];
                }
            }
        }

        public int getNumPoints() {
            switch (this.segType) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 0;
                }
            }
            return 0;
        }

        public void getPoint(int ix, double[] dstCoords) {
            assert (ix < this.getNumPoints() && dstCoords.length >= 2);
            int offset = ix * 2;
            dstCoords[0] = this.dcoords[offset];
            dstCoords[1] = this.dcoords[offset + 1];
        }

        public void setPoint(int ix, double[] srcCoords) {
            assert (ix < this.getNumPoints() && srcCoords.length >= 2);
            int offset = ix * 2;
            this.dcoords[offset] = srcCoords[0];
            this.dcoords[offset + 1] = srcCoords[1];
        }
    }
}

