/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point2d;
import thunderheadeng.geometry.Util2D;

public final class RotatingCalipers {
    static final double A90 = 1.5707963267948966;
    static final double A180 = Math.PI;
    static final double A270 = Math.toRadians(270.0);
    static final double A360 = Math.PI * 2;

    public static double getArea(Point2d[] rectangle) {
        double deltaXAB = rectangle[0].x - rectangle[1].x;
        double deltaYAB = rectangle[0].y - rectangle[1].y;
        double deltaXBC = rectangle[1].x - rectangle[2].x;
        double deltaYBC = rectangle[1].y - rectangle[2].y;
        double lengthAB = Math.sqrt(deltaXAB * deltaXAB + deltaYAB * deltaYAB);
        double lengthBC = Math.sqrt(deltaXBC * deltaXBC + deltaYBC * deltaYBC);
        return lengthAB * lengthBC;
    }

    public static List<Point2d[]> getAllBoundingRectangles(int[] xs, int[] ys) throws IllegalArgumentException {
        if (xs.length != ys.length) {
            throw new IllegalArgumentException("xs and ys don't have the same size");
        }
        ArrayList<Point2d> points = new ArrayList<Point2d>();
        for (int i = 0; i < xs.length; ++i) {
            points.add(new Point2d((double)xs[i], (double)ys[i]));
        }
        return RotatingCalipers.getAllBoundingRectangles(points);
    }

    public static List<Point2d[]> getAllBoundingRectangles(Collection<Point2d> points) {
        ArrayList<Point2d[]> rectangles = new ArrayList<Point2d[]>();
        Collection<Point2d> convexHullColl = Util2D.getConvexHull(points);
        List<Object> convexHull = convexHullColl instanceof List ? (List<Object>)convexHullColl : new ArrayList<Point2d>(convexHullColl);
        Caliper I = new Caliper((List<Point2d>)convexHull, RotatingCalipers.getIndex((List<Point2d>)convexHull, Corner.UPPER_RIGHT), 1.5707963267948966);
        Caliper J = new Caliper((List<Point2d>)convexHull, RotatingCalipers.getIndex((List<Point2d>)convexHull, Corner.UPPER_LEFT), Math.PI);
        Caliper K = new Caliper((List<Point2d>)convexHull, RotatingCalipers.getIndex((List<Point2d>)convexHull, Corner.LOWER_LEFT), A270);
        Caliper L = new Caliper((List<Point2d>)convexHull, RotatingCalipers.getIndex((List<Point2d>)convexHull, Corner.LOWER_RIGHT), 0.0);
        while (L.currentAngle < 1.5707963267948966) {
            rectangles.add(new Point2d[]{L.getIntersection(I), I.getIntersection(J), J.getIntersection(K), K.getIntersection(L)});
            double smallestTheta = RotatingCalipers.getSmallestTheta(I, J, K, L);
            I.rotateBy(smallestTheta);
            J.rotateBy(smallestTheta);
            K.rotateBy(smallestTheta);
            L.rotateBy(smallestTheta);
        }
        return rectangles;
    }

    public static Point2d[] getMinimumBoundingRectangle(int[] xs, int[] ys) throws IllegalArgumentException {
        if (xs.length != ys.length) {
            throw new IllegalArgumentException("xs and ys don't have the same size");
        }
        ArrayList<Point2d> points = new ArrayList<Point2d>();
        for (int i = 0; i < xs.length; ++i) {
            points.add(new Point2d((double)xs[i], (double)ys[i]));
        }
        return RotatingCalipers.getMinimumBoundingRectangle(points);
    }

    public static Point2d[] getMinimumBoundingRectangle(Collection<Point2d> points) {
        List<Point2d[]> rectangles = RotatingCalipers.getAllBoundingRectangles(points);
        Point2d[] minimum = null;
        double area = 9.223372036854776E18;
        for (Point2d[] rectangle : rectangles) {
            double tempArea = RotatingCalipers.getArea(rectangle);
            if (minimum != null && !(tempArea < area)) continue;
            minimum = rectangle;
            area = tempArea;
        }
        return minimum;
    }

    private static double getSmallestTheta(Caliper I, Caliper J, Caliper K, Caliper L) {
        double thetaI = I.getDeltaAngleNextPoint();
        double thetaJ = J.getDeltaAngleNextPoint();
        double thetaK = K.getDeltaAngleNextPoint();
        double thetaL = L.getDeltaAngleNextPoint();
        if (thetaI <= thetaJ && thetaI <= thetaK && thetaI <= thetaL) {
            return thetaI;
        }
        if (thetaJ <= thetaK && thetaJ <= thetaL) {
            return thetaJ;
        }
        if (thetaK <= thetaL) {
            return thetaK;
        }
        return thetaL;
    }

    protected static int getIndex(List<Point2d> convexHull, Corner corner) {
        int index = 0;
        Point2d point = convexHull.get(index);
        for (int i = 1; i < convexHull.size(); ++i) {
            Point2d temp = convexHull.get(i);
            boolean change = false;
            switch (corner) {
                case UPPER_RIGHT: {
                    change = temp.x > point.x || temp.x == point.x && temp.y > point.y;
                    break;
                }
                case UPPER_LEFT: {
                    change = temp.y > point.y || temp.y == point.y && temp.x < point.x;
                    break;
                }
                case LOWER_LEFT: {
                    change = temp.x < point.x || temp.x == point.x && temp.y < point.y;
                    break;
                }
                case LOWER_RIGHT: {
                    boolean bl = change = temp.y < point.y || temp.y == point.y && temp.x > point.x;
                }
            }
            if (!change) continue;
            index = i;
            point = temp;
        }
        return index;
    }

    protected static class Caliper {
        static final double SIGMA = 1.0E-11;
        final List<Point2d> convexHull;
        int pointIndex;
        double currentAngle;

        Caliper(List<Point2d> convexHull, int pointIndex, double currentAngle) {
            this.convexHull = convexHull;
            this.pointIndex = pointIndex;
            this.currentAngle = currentAngle;
        }

        double getAngleNextPoint() {
            Point2d p1 = this.convexHull.get(this.pointIndex);
            Point2d p2 = this.convexHull.get((this.pointIndex + 1) % this.convexHull.size());
            double deltaY = p2.y - p1.y;
            double deltaX = p2.x - p1.x;
            double angle = Math.atan2(deltaY, deltaX);
            return angle < 0.0 ? Math.PI * 2 + angle : angle;
        }

        double getConstant() {
            Point2d p = this.convexHull.get(this.pointIndex);
            return p.y - this.getSlope() * p.x;
        }

        double getDeltaAngleNextPoint() {
            double angle = this.getAngleNextPoint();
            angle = angle < 0.0 ? Math.PI * 2 + angle - this.currentAngle : angle - this.currentAngle;
            return angle < 0.0 ? Math.PI * 2 : angle;
        }

        Point2d getIntersection(Caliper that) {
            double x = this.isVertical() ? this.convexHull.get((int)this.pointIndex).x : (this.isHorizontal() ? that.convexHull.get((int)that.pointIndex).x : (that.getConstant() - this.getConstant()) / (this.getSlope() - that.getSlope()));
            double y = this.isVertical() ? that.getConstant() : (this.isHorizontal() ? this.getConstant() : this.getSlope() * x + this.getConstant());
            return new Point2d(x, y);
        }

        double getSlope() {
            return Math.tan(this.currentAngle);
        }

        boolean isHorizontal() {
            return Math.abs(this.currentAngle) < 1.0E-11 || Math.abs(this.currentAngle - Math.PI) < 1.0E-11;
        }

        boolean isVertical() {
            return Math.abs(this.currentAngle - 1.5707963267948966) < 1.0E-11 || Math.abs(this.currentAngle - A270) < 1.0E-11;
        }

        void rotateBy(double angle) {
            if (this.getDeltaAngleNextPoint() == angle) {
                this.pointIndex = (this.pointIndex + 1) % this.convexHull.size();
            }
            this.currentAngle += angle;
        }
    }

    protected static enum Corner {
        UPPER_RIGHT,
        UPPER_LEFT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }
}

