/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;

public class Ray3d {
    public final Point3d origin;
    public final Vector3d dir;
    public final double length;

    public Ray3d(Point3d origin, Vector3d dir, double length) {
        this.origin = origin;
        this.dir = dir;
        this.length = length;
    }

    public Ray3d(Point3d p1, Point3d p2) {
        this.origin = p1;
        this.dir = Util3D.vector(p1, p2);
        this.length = Util3D.safeNormalize(this.dir, 0.0);
    }

    public Point3d p1() {
        return this.origin;
    }

    public Point3d p2() {
        return this.get(this.length);
    }

    public Point3d evaluate(double dist) {
        return this.get(dist);
    }

    public Point3d get(double dist) {
        return new Point3d(this.origin.x + this.dir.x * dist, this.origin.y + this.dir.y * dist, this.origin.z + this.dir.z * dist);
    }

    public double distance(Point3d p) {
        double dx = p.x - this.origin.x;
        double dy = p.y - this.origin.y;
        double dz = p.z - this.origin.z;
        return dx * this.dir.x + dy * this.dir.y + dz * this.dir.z;
    }
}

