/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import javax.vecmath.Point3d;
import thunderheadeng.geometry.IFace3d;
import thunderheadeng.geometry.Plane3d;

public class Quad3d
implements IFace3d {
    private final Plane3d d_plane = new Plane3d();
    private Point3d d_p0;
    private Point3d d_p1;
    private Point3d d_p2;
    private Point3d d_p3;

    public Quad3d() {
        this(new Point3d(), new Point3d(), new Point3d(), new Point3d());
    }

    public Quad3d(Point3d p0, Point3d p1, Point3d p2, Point3d p3) {
        this.set(p0, p1, p2, p3);
    }

    public void set(Point3d p0, Point3d p1, Point3d p2, Point3d p3) {
        this.d_p0 = p0;
        this.d_p1 = p1;
        this.d_p2 = p2;
        this.d_p3 = p3;
        this.d_plane.set(true, p0, p1, p2, this.d_p3);
    }

    public void invalidatePoints() {
        this.d_plane.set(true, this.d_p0, this.d_p1, this.d_p2, this.d_p3);
    }

    @Override
    public Plane3d getPlane() {
        return this.d_plane;
    }

    @Override
    public int getNumPoints() {
        return 4;
    }

    @Override
    public Point3d getPoint(int index) {
        switch (index) {
            case 0: {
                return this.d_p0;
            }
            case 1: {
                return this.d_p1;
            }
            case 2: {
                return this.d_p2;
            }
            case 3: {
                return this.d_p3;
            }
        }
        return this.d_p0;
    }

    public void updatePlane() {
        this.d_plane.set(true, this.d_p0, this.d_p1, this.d_p2, this.d_p3);
    }
}

