/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.io.Serializable;
import java.util.Arrays;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class Plane3d
implements Serializable {
    static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Plane3d() {
    }

    public Plane3d(Plane3d p) {
        this(p.x, p.y, p.z, p.w);
    }

    public Plane3d(double x, double y, double z, double w) {
        this.set(x, y, z, w);
    }

    public Plane3d(Vector3d normal, Point3d pointOnPlane) {
        this.x = normal.x;
        this.y = normal.y;
        this.z = normal.z;
        this.w = Plane3d.calcD(normal, pointOnPlane);
    }

    public Plane3d(boolean ccw, Point3d ... points) {
        this.set(ccw, points);
    }

    public Plane3d normalize() {
        double ilen = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Plane3d(this.x * ilen, this.y * ilen, this.z * ilen, this.w * ilen);
    }

    public static Vector4d normalizeEq(Vector4d val) {
        double ilen = 1.0 / Math.sqrt(val.x * val.x + val.y * val.y + val.z * val.z);
        val.x *= ilen;
        val.y *= ilen;
        val.z *= ilen;
        val.w *= ilen;
        return val;
    }

    public boolean isValid() {
        return this.x != 0.0 || this.y != 0.0 || this.z != 0.0;
    }

    public boolean isParallel(Plane3d plane, double tol) {
        double ndot = plane.x * this.x + plane.y * this.y + plane.z * this.z;
        return theUtil.eq(Math.abs(ndot), 1.0, tol);
    }

    public void set(double tol, boolean ccw, Point3d ... points) {
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(points), ccw, tol);
        if (plane == null) {
            this.set(0.0, 0.0, 0.0, 0.0);
        } else {
            this.set(plane);
        }
    }

    public void set(boolean ccw, Point3d ... points) {
        this.set(0.0, ccw, points);
    }

    public void set(Vector4d vec) {
        this.set(vec.x, vec.y, vec.z, vec.w);
    }

    public void set(Plane3d p) {
        this.set(p.x, p.y, p.z, p.w);
    }

    public void set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4d toVec4d() {
        return new Vector4d(this.x, this.y, this.z, this.w);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Plane3d)) {
            return false;
        }
        Plane3d p = (Plane3d)o;
        return this == p || this.x == p.x && this.y == p.y && this.z == p.z && this.w == p.w;
    }

    public boolean epsilonEquals(Plane3d p2, double epsilon) {
        if (this == p2) {
            return true;
        }
        double linf = Math.max(Math.abs(this.x - p2.x), Math.abs(this.y - p2.y));
        linf = Math.max(linf, Math.abs(this.z - p2.z));
        return (linf = Math.max(linf, Math.abs(this.w - p2.w))) <= epsilon;
    }

    public Vector3d getNormal() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public void getNormal(Vector3d normal) {
        normal.set(this.x, this.y, this.z);
    }

    public void negateEq() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
    }

    public Plane3d negate() {
        return new Plane3d(-this.x, -this.y, -this.z, -this.w);
    }

    private static double calcD(Vector3d normal, Point3d pointOnPlane) {
        return -normal.x * pointOnPlane.x - normal.y * pointOnPlane.y - normal.z * pointOnPlane.z;
    }

    public double distance(Point3d p) {
        double m = Math.abs(this.x * p.x + this.y * p.y + this.z * p.z + this.w);
        double n = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return m / n;
    }

    public Point3d projectOntoPlane(Point3d p) {
        double dist = this.dot(p);
        p = new Point3d(p);
        p.x -= this.x * dist;
        p.y -= this.y * dist;
        p.z -= this.z * dist;
        return p;
    }

    public double dot(Point3d p) {
        return this.x * p.x + this.y * p.y + this.z * p.z + this.w;
    }

    public double dot(double px, double py, double pz) {
        return this.x * px + this.y * py + this.z * pz + this.w;
    }

    public Point3d getPointOnPlane() {
        if (theUtil.eq(1.0, this.x * this.x + this.y * this.y + this.z * this.z, 1.0E-9)) {
            return new Point3d(-this.x * this.w, -this.y * this.w, -this.z * this.w);
        }
        if (!theUtil.eq0(this.x, 1.0E-9)) {
            return new Point3d(-this.w / this.x, 0.0, 0.0);
        }
        if (!theUtil.eq0(this.y, 1.0E-9)) {
            return new Point3d(0.0, -this.w / this.y, 0.0);
        }
        if (!theUtil.eq0(this.z, 1.0E-9)) {
            return new Point3d(0.0, 0.0, -this.w / this.z);
        }
        return new Point3d(0.0, 0.0, 0.0);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public Plane3d transformBy(Matrix4d xform) {
        Vector3d lx = new Vector3d();
        Vector3d ly = new Vector3d();
        Util.constructOrthogonalAxes(this.getNormal(), lx, ly);
        Point3d pOnPlane = new Point3d(-this.x * this.w, -this.y * this.w, -this.z * this.w);
        xform.transform(pOnPlane);
        xform.transform(lx);
        xform.transform(ly);
        Vector3d normal = Util3D.cross(lx, ly);
        normal.normalize();
        return new Plane3d(normal, pOnPlane);
    }
}

