/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.util.Random;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import thunderheadeng.delaunay.GeomTests;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class Inter2D {
    public static double ISECT_TOL = 1.0E-7;
    private static final ToDoubleFunction<Point2d> s_xidentiy = p -> p.x;
    private static final ToDoubleFunction<Point2d> s_yidentiy = p -> p.y;

    public static double[] isectLinesegLineseg(Point2d l1a, Point2d l1b, Point2d l2a, Point2d l2b, double tol) {
        double[] isect = Inter2D.isectLineLine(l1a, Util2D.vector(l1a, l1b), l2a, Util2D.vector(l2a, l2b), 1.0E-12);
        if (isect == null) {
            return null;
        }
        if (!Util.clampTIfValid(isect, 0.0, 1.0, tol)) {
            return null;
        }
        return isect;
    }

    public static boolean copLineSegLineSegCrossExact(Point2d l1a, Point2d l1b, Point2d l2a, Point2d l2b) {
        return Inter2D.copLineSegLineSegCrossExact(l1a.x, l1a.y, l1b.x, l1b.y, l2a.x, l2a.y, l2b.x, l2b.y);
    }

    public static boolean copLineSegLineSegCrossExact(double l1ax, double l1ay, double l1bx, double l1by, double l2ax, double l2ay, double l2bx, double l2by) {
        double side1a = GeomTests.orient2d(l2ax, l2ay, l2bx, l2by, l1ax, l1ay);
        double side1b = GeomTests.orient2d(l2ax, l2ay, l2bx, l2by, l1bx, l1by);
        if (side1a < 0.0 && side1b < 0.0 || side1a > 0.0 && side1b > 0.0 || side1a == 0.0 && side1b == 0.0) {
            return false;
        }
        double side2a = GeomTests.orient2d(l1ax, l1ay, l1bx, l1by, l2ax, l2ay);
        double side2b = GeomTests.orient2d(l1ax, l1ay, l1bx, l1by, l2bx, l2by);
        assert (side2a != 0.0 || side2b != 0.0);
        return side2a >= 0.0 && side2b <= 0.0 || side2a <= 0.0 && side2b >= 0.0;
    }

    public static double[] isectLineLine(double p1x, double p1y, double v1x, double v1y, double p2x, double p2y, double v2x, double v2y, double tol) {
        double[] st = new double[2];
        return (double[])(Inter2D.isectLineLine(p1x, p1y, v1x, v1y, p2x, p2y, v2x, v2y, tol, st) ? st : null);
    }

    public static boolean isectLineLine(double p1x, double p1y, double v1x, double v1y, double p2x, double p2y, double v2x, double v2y, double tol, double[] st) {
        assert (st.length >= 2);
        double denom = v2y * v1x - v2x * v1y;
        if (theUtil.eq0(denom, tol)) {
            return false;
        }
        double idenom = 1.0 / denom;
        double ydiff = p1y - p2y;
        double xdiff = p1x - p2x;
        double t1 = (v2x * ydiff - v2y * xdiff) * idenom;
        double t2 = (v1x * ydiff - v1y * xdiff) * idenom;
        st[0] = t1;
        st[1] = t2;
        return true;
    }

    public static double[] isectLineLine(Point2d p1, Vector2d v1, Point2d p2, Vector2d v2, double tol) {
        return Inter2D.isectLineLine(p1.x, p1.y, v1.x, v1.y, p2.x, p2.y, v2.x, v2.y, tol);
    }

    public static double[] isectLineSegLineSeg(double p1x, double p1y, double p2x, double p2y, double p3x, double p3y, double p4x, double p4y, double tol) {
        double[] st = new double[2];
        return (double[])(Inter2D.isectLineSegLineSeg(p1x, p1y, p2x, p2y, p3x, p3y, p4x, p4y, tol, st) ? st : null);
    }

    public static boolean isectLineSegLineSeg(double p1x, double p1y, double p2x, double p2y, double p3x, double p3y, double p4x, double p4y, double tol, double[] st) {
        return Inter2D.isectLineLine(p1x, p1y, p2x - p1x, p2y - p1y, p3x, p3y, p4x - p3x, p4y - p3y, tol, st) && Util.clampTIfValid(st, 0.0, 1.0, tol);
    }

    public static double[] isectLineSegLineSeg(Point2d p1, Point2d p2, Point2d p3, Point2d p4, double tol) {
        return Inter2D.isectLineSegLineSeg(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y, tol);
    }

    public static Point2d[] extendSeg(Point2d p1, Point2d p2, Point2d l1, Vector2d ldir, double tol) {
        Vector2d dir = Util2D.vector(p1, p2);
        double[] isect = Inter2D.isectLineLine(p1, dir, l1, ldir, tol);
        if (isect != null) {
            if (isect[0] < 0.0) {
                return new Point2d[]{Util2D.linePoint(p1, dir, isect[0]), p2};
            }
            if (isect[0] > 1.0) {
                return new Point2d[]{p1, Util2D.linePoint(p1, dir, isect[0])};
            }
        }
        return new Point2d[]{p1, p2};
    }

    public static double[][] lineSeglineSegOverlap(Point2d p1a, Point2d p2a, Point2d p1b, Point2d p2b, double tol) {
        double t2a;
        Vector2d dirb;
        Vector2d dira = Util2D.vector(p1a, p2a);
        if (!Util2D.areLinesAligned(p1a, dira, p1b, dirb = Util2D.vector(p1b, p2b), tol)) {
            return null;
        }
        double t1a = Util2D.tOnLine(p1a, dira, p1b);
        if (t1a > (t2a = Util2D.tOnLine(p1a, dira, p2b))) {
            double temp = t1a;
            t1a = t2a;
            t2a = temp;
        }
        if (theUtil.gt(t1a, 1.0, tol) || theUtil.lt0(t2a, -tol)) {
            return null;
        }
        t1a = Util.clampT(t1a, 0.0, 1.0);
        t2a = Util.clampT(t2a, 0.0, 1.0);
        double t1b = Util2D.tOnLine(p1b, dirb, Util2D.linePoint(p1a, dira, t1a));
        double t2b = Util2D.tOnLine(p1b, dirb, Util2D.linePoint(p1a, dira, t2a));
        t1b = Util.clampT(t1b, 0.0, 1.0);
        t2b = Util.clampT(t2b, 0.0, 1.0);
        return new double[][]{{t1a, t2a}, {t1b, t2b}};
    }

    public static Point2d nearestToLineSeg(Point2d tp, Point2d p1, Point2d p2) {
        return Util2D.linePoint(p1, p2, Inter2D.nearestTOnLineSeg(tp, p1, p2));
    }

    public static Point2d nearestPtOnLine(Point2d p1, Vector2d vec, Point2d tp) {
        return Util2D.linePoint(p1, vec, Inter2D.nearestTOnLine(p1, vec, tp));
    }

    public static double nearestTOnLine(Point2d p1, Vector2d vec, Point2d tp) {
        return Inter2D.nearestTOnLine(p1.x, p1.y, vec.x, vec.y, tp.x, tp.y);
    }

    public static double distSqToNearestPtOnLineSeg(double l1x, double l1y, double l2x, double l2y, double px, double py) {
        double v1x = l2x - l1x;
        double v1y = l2y - l1y;
        double lensq = v1x * v1x + v1y * v1y;
        double v2x = px - l1x;
        double v2y = py - l1y;
        if (lensq == 0.0) {
            return v2x * v2x + v2y * v2y;
        }
        double dot = v1x * v2x + v1y * v2y;
        if (dot <= 0.0) {
            return v2x * v2x + v2y * v2y;
        }
        if (dot >= lensq) {
            v2x = px - l2x;
            v2y = py - l2y;
            return v2x * v2x + v2y * v2y;
        }
        return Math.max(0.0, v2x * v2x + v2y * v2y - dot * dot / lensq);
    }

    public static double distSqToNearestPtOnLine(double l1x, double l1y, double vx, double vy, double px, double py) {
        double lensq = vx * vx + vy * vy;
        double dx = px - l1x;
        double dy = py - l1y;
        double dot = vx * dx + vy * dy;
        return dx * dx + dy * dy - dot * dot / lensq;
    }

    public static double distSqToNearestPtOnLine2(double l1x, double l1y, double l2x, double l2y, double px, double py) {
        return Inter2D.distSqToNearestPtOnLine(l1x, l1y, l2x - l1x, l2y - l1y, px, py);
    }

    public static double[] projectPointLine(double px, double py, double l1x, double l1y, double v1x, double v1y, boolean isLineSeg) {
        double[] result = new double[2];
        Inter2D.projectPointLine(px, py, l1x, l1y, v1x, v1y, isLineSeg, result);
        return result;
    }

    public static boolean projectPointLine(double px, double py, double l1x, double l1y, double lx, double ly, boolean isLineSeg, double[] result) {
        double t;
        double lensq = lx * lx + ly * ly;
        double v2x = px - l1x;
        double v2y = py - l1y;
        if (lensq == 0.0) {
            result[0] = 0.0;
            result[1] = v2x * v2x + v2y * v2y;
            return false;
        }
        double dot = lx * v2x + ly * v2y;
        if (isLineSeg) {
            if (dot <= 0.0) {
                result[0] = 0.0;
                result[1] = v2x * v2x + v2y * v2y;
                return true;
            }
            if (dot >= lensq) {
                v2x = px - (l1x + lx);
                v2y = py - (l1y + ly);
                result[0] = 1.0;
                result[1] = v2x * v2x + v2y * v2y;
                return true;
            }
        }
        result[0] = t = dot / lensq;
        result[1] = Math.max(0.0, v2x * v2x + v2y * v2y - t * dot);
        return true;
    }

    public static double nearestTOnLine(double p1x, double p1y, double vecx, double vecy, double tpx, double tpy) {
        double lensq = vecx * vecx + vecy * vecy;
        if (lensq == 0.0) {
            return Double.NaN;
        }
        double dx = tpx - p1x;
        double dy = tpy - p1y;
        return (vecx * dx + vecy * dy) / lensq;
    }

    public static double nearestTOnLineSeg(double tpx, double tpy, double p1x, double p1y, double p2x, double p2y) {
        double nearestT = Inter2D.nearestTOnLine(p1x, p1y, p2x - p1x, p2y - p1y, tpx, tpy);
        return Double.isNaN(nearestT) ? 0.0 : Util.clampT(nearestT, 0.0, 1.0);
    }

    public static double nearestTOnLineSeg(Point2d tp, Point2d p1, Point2d p2) {
        return Inter2D.nearestTOnLineSeg(tp.x, tp.y, p1.x, p1.y, p2.x, p2.y);
    }

    public static double pointOnLine(Point2d l1, Vector2d vec, Point2d p, double tolSq) {
        if (!Util2D.areLinesParallel(vec, Util2D.vector(l1, p), tolSq)) {
            return Double.NaN;
        }
        return Inter2D.nearestTOnLine(l1, vec, p);
    }

    public static double pointOnLineSeg(Point2d l1, Point2d l2, Point2d p, double tolSq) {
        double t = Inter2D.pointOnLine(l1, Util2D.vector(l1, l2), p, tolSq);
        if (Double.isNaN(t)) {
            return t;
        }
        double[] ts = new double[]{t};
        return Util.clampTIfValid(ts, 0.0, 1.0, tolSq) ? ts[0] : Double.NaN;
    }

    public static boolean aabbAABBIntersect(double minx1, double miny1, double maxx1, double maxy1, double minx2, double miny2, double maxx2, double maxy2, double tol) {
        return minx2 - tol <= maxx1 + tol && maxx2 + tol >= minx1 - tol && miny2 - tol <= maxy1 + tol && maxy2 + tol >= miny1 - tol;
    }

    public static boolean aabbAABBIntersect(double minx1, double miny1, double maxx1, double maxy1, double minx2, double miny2, double maxx2, double maxy2) {
        return minx2 <= maxx1 && maxx2 >= minx1 && miny2 <= maxy1 && maxy2 >= miny1;
    }

    public static double[] lineCircleIsect(double lpx, double lpy, double ldx, double ldy, double cx, double cy, double r, double tol) {
        double[] dArray;
        double t2;
        double c;
        double delta;
        double b = 2.0 * (ldx * (lpx -= cx) + ldy * (lpy -= cy));
        double a = ldx * ldx + ldy * ldy;
        if (theUtil.lt0(delta = b * b - 4.0 * a * (c = lpx * lpx + lpy * lpy - r * r), tol)) {
            return null;
        }
        if (theUtil.le0(delta, tol)) {
            double t = -b / (2.0 * a);
            return new double[]{t, t};
        }
        double i2a = 0.5 / a;
        double deltasqrt = Math.sqrt(delta);
        double t1 = (-b + deltasqrt) * i2a;
        if (t1 <= (t2 = (-b - deltasqrt) * i2a)) {
            double[] dArray2 = new double[2];
            dArray2[0] = t1;
            dArray = dArray2;
            dArray2[1] = t2;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = t2;
            dArray = dArray3;
            dArray3[1] = t1;
        }
        return dArray;
    }

    public static boolean pointInSimplePoly(double tol, Point2d tp, Point2d ... points) {
        Random rand = new Random(0L);
        boolean[] result = new boolean[2];
        for (int m = 0; m < 15; ++m) {
            Vector2d v = Util2D.newRandomVec2D(rand);
            if (!Inter2D.testPointInSimplePoly(points, tp, v, tol, result)) continue;
            return result[0] || result[1];
        }
        System.err.println("Could not complete Inter2D.pointInSimplePoly using test point = " + tp.toString());
        return false;
    }

    private static boolean testPointInSimplePoly(Point2d[] points, Point2d tp, Vector2d dir, double tol, boolean[] result) {
        assert (result.length >= 2);
        int numIsects = 0;
        for (int m = 0; m < points.length; ++m) {
            Point2d e1 = points[m];
            Point2d e2 = points[(m + 1) % points.length];
            Vector2d edir = Util2D.vector(e1, e2);
            double[] isect = Inter2D.isectLineLine(tp, dir, e1, edir, tol);
            if (isect == null || !Util.checkRange(0.0, 1.0, isect[1], tol)) continue;
            double tr = isect[0];
            double tcurve = isect[1];
            if (theUtil.eq0(tr, tol)) {
                result[0] = true;
                result[1] = false;
                return true;
            }
            if (tr < 0.0) continue;
            if (theUtil.eq0(tcurve, tol) || theUtil.eq(tcurve, 1.0, tol)) {
                return false;
            }
            ++numIsects;
        }
        result[0] = false;
        result[1] = numIsects % 2 != 0;
        return true;
    }

    public static boolean pointInConvexPoly(double tol, Point2d pt, Point2d ... polyPoints) {
        return Inter2D.pointInConvexPoly(tol, s_xidentiy, s_yidentiy, pt.x, pt.y, polyPoints);
    }

    public static <T> boolean pointInConvexPoly(double tol, ToDoubleFunction<T> getX, ToDoubleFunction<T> getY, double ptx, double pty, T ... polyPoints) {
        assert (polyPoints.length >= 3);
        Vector2d vp = new Vector2d();
        Vector2d vt = new Vector2d();
        double lastCross = Double.NaN;
        int inCount = 0;
        double tolSq = tol * tol;
        T p1 = polyPoints[polyPoints.length - 1];
        double p1x = getX.applyAsDouble(p1);
        double p1y = getY.applyAsDouble(p1);
        for (int m = 0; m < polyPoints.length; ++m) {
            T p2 = polyPoints[m];
            double p2x = getX.applyAsDouble(p2);
            double p2y = getY.applyAsDouble(p2);
            vt.set(p2x - p1x, p2y - p1y);
            if (!theUtil.eq0(vt.lengthSquared(), tolSq)) {
                vp.set(ptx - p1x, pty - p1y);
                double currentCross = Util2D.cross(vt, vp);
                if (theUtil.eq0(currentCross, tol)) {
                    double dot = vp.dot(vt);
                    return Util.checkRange(0.0, vt.dot(vt), dot, tol);
                }
                if (Double.isNaN(lastCross)) {
                    lastCross = currentCross;
                } else {
                    if (lastCross < 0.0 && currentCross > 0.0 || lastCross > 0.0 && currentCross < 0.0) {
                        return false;
                    }
                    ++inCount;
                }
            }
            p1x = p2x;
            p1y = p2y;
            p1 = p2;
        }
        return inCount > 0;
    }

    public static boolean pointInPoly(double tol, Point2d pt, boolean polyConvex, Point2d ... polyPoints) {
        return polyConvex && Inter2D.pointInConvexPoly(tol, pt, polyPoints) || !polyConvex && Inter2D.pointInSimplePoly(tol, pt, polyPoints);
    }

    public static boolean testCPolyCPoly(Point2d[] a, Point2d[] b, double tol) {
        return Inter2D.testCPolyCPoly(a, b, s_xidentiy, s_yidentiy, tol);
    }

    public static <T> boolean testCPolyCPoly(T[] a, T[] b, ToDoubleFunction<T> getX, ToDoubleFunction<T> getY, double tol) {
        if (a.length == 0 || b.length == 0) {
            return false;
        }
        for (int x = 0; x < 2; ++x) {
            T[] polygon = x == 0 ? a : b;
            T p1 = polygon[polygon.length - 1];
            double p1x = getX.applyAsDouble(p1);
            double p1y = getY.applyAsDouble(p1);
            for (T p2 : polygon) {
                double p2x = getX.applyAsDouble(p2);
                double p2y = getY.applyAsDouble(p2);
                double normalx = p2y - p1y;
                double normaly = p1x - p2x;
                double minA = Double.MAX_VALUE;
                double maxA = -1.7976931348623157E308;
                for (T p : a) {
                    double projected = normalx * getX.applyAsDouble(p) + normaly * getY.applyAsDouble(p);
                    if (projected < minA) {
                        minA = projected;
                    }
                    if (!(projected > maxA)) continue;
                    maxA = projected;
                }
                double minB = Double.MAX_VALUE;
                double maxB = -1.7976931348623157E308;
                for (T p : b) {
                    double projected = normalx * getX.applyAsDouble(p) + normaly * getY.applyAsDouble(p);
                    if (projected < minB) {
                        minB = projected;
                    }
                    if (!(projected > maxB)) continue;
                    maxB = projected;
                }
                if (maxA < minB || maxB < minA) {
                    return false;
                }
                p1 = p2;
                p1x = p2x;
                p1y = p2y;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        int m;
        Point2d[] poly1 = new Point2d[]{new Point2d(0.0, 0.0), new Point2d(3.0, 0.0), new Point2d(3.0, 2.0), new Point2d(1.5, 3.0), new Point2d(0.0, 2.0)};
        Point2d[] poly2 = new Point2d[]{new Point2d(2.0, 2.0), new Point2d(3.0, 4.0), new Point2d(1.0, 4.0), new Point2d(1.0, 3.0)};
        Point2d[] poly3 = new Point2d[]{new Point2d(-4.0, 2.0), new Point2d(-2.0, 2.0), new Point2d(-2.0, 3.5), new Point2d(-4.0, 3.5)};
        Point2d[] poly4 = new Point2d[]{new Point2d(1.0, 1.0), new Point2d(1.5, 1.0), new Point2d(1.5, 2.5), new Point2d(1.0, 2.5)};
        theTimer timer = new theTimer();
        for (m = 0; m < 7000000; ++m) {
            Inter2D.testCPolyCPoly(poly1, poly2, 1.0E-6);
        }
        for (m = 0; m < 7000000; ++m) {
            Inter2D.testCPolyCPoly(poly1, poly3, 1.0E-6);
        }
        for (m = 0; m < 7000000; ++m) {
            Inter2D.testCPolyCPoly(poly1, poly4, 1.0E-6);
        }
        double t = timer.curr();
        System.out.println(t);
    }
}

