/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.TrimmedCurve3D;

public interface IParametric3D {
    public Point3d get(double var1);

    public Vector3d getTangent(double var1);

    public double length();

    public double getClosestT(Point3d var1);

    public double[] getIsects(Plane3d var1, double var2);

    public IParametric2D projectToPlane(Plane3d var1, Matrix4d var2);

    public IParametric3D transform(Matrix4d var1);

    public IParametric2D transform2D(Matrix4d var1);

    public IParametric3D reverse();

    public boolean isLinear();

    default public IParametric3D trim(double t1, double t2) {
        if (t1 == 0.0 && t2 == 1.0) {
            return this;
        }
        if (t2 == 0.0 && t1 == 1.0) {
            return this.reverse();
        }
        return new TrimmedCurve3D(this, t1, t2);
    }
}

