/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.theUtil;

public class Box3d
implements ITest<AABox> {
    private final Point3d[] d_verts;
    private final Point3d[][] d_faces;
    private final Plane3d[] d_planes;

    public Box3d(Point3d ... verts) {
        assert (verts.length == 8);
        this.d_verts = verts;
        this.d_faces = new Point3d[][]{{verts[0], verts[1], verts[2], verts[3]}, {verts[6], verts[5], verts[4], verts[7]}, {verts[4], verts[0], verts[3], verts[7]}, {verts[1], verts[5], verts[6], verts[2]}, {verts[2], verts[6], verts[7], verts[3]}, {verts[0], verts[4], verts[5], verts[1]}};
        this.d_planes = new Plane3d[6];
        for (int m = 0; m < 6; ++m) {
            this.d_planes[m] = new Plane3d(true, this.d_faces[m]);
        }
    }

    public Box3d(AABox bounds) {
        this(bounds.Mmm(), bounds.MMm(), bounds.MMM(), bounds.MmM(), bounds.mmm(), bounds.mMm(), bounds.mMM(), bounds.mmM());
    }

    public Point3d[] getVerts() {
        return this.d_verts;
    }

    public Point3d[][] getFaces() {
        return this.d_faces;
    }

    public Plane3d[] getPlanes() {
        return this.d_planes;
    }

    public int contains(Point3d ... points) {
        return thunderheadeng.geometry.Containment.convert(this.test(points));
    }

    @Override
    public Containment test(Point3d ... points) {
        int totalIn = 0;
        for (Point3d p : points) {
            if (!this.contains(p)) continue;
            ++totalIn;
        }
        if (totalIn == 0) {
            return Containment.OUTSIDE;
        }
        if (totalIn == points.length) {
            return Containment.INSIDE;
        }
        return Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(Point3d ... points) {
        return this.test(points) != Containment.OUTSIDE;
    }

    public boolean contains(Point3d p) {
        return this.contains(p, 0.0);
    }

    public boolean contains(Point3d p, double tol) {
        for (int m = 0; m < 6; ++m) {
            double dot = this.d_planes[m].dot(p);
            if (!theUtil.gt0(dot, tol)) continue;
            return false;
        }
        return true;
    }

    public int contains(AABox bb) {
        return thunderheadeng.geometry.Containment.convert(this.test(bb));
    }

    @Override
    public Containment test(AABox bb) {
        if (bb.getMin().equals((Tuple3d)bb.getMax())) {
            return this.contains(bb.getMin()) ? Containment.INSIDE : Containment.OUTSIDE;
        }
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        int totalIn = 0;
        for (int m = 0; m < 6; ++m) {
            int inCount = 8;
            int ptIn = 1;
            Plane3d plane = this.d_planes[m];
            if (plane.dot(min.x, min.y, min.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(min.x, min.y, max.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(min.x, max.y, min.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(min.x, max.y, max.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(max.x, min.y, min.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(max.x, min.y, max.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(max.x, max.y, min.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(max.x, max.y, max.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (inCount == 0) {
                return Containment.OUTSIDE;
            }
            totalIn += ptIn;
        }
        return totalIn == 6 ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(AABox bb) {
        return this.test(bb) != Containment.OUTSIDE;
    }

    public int contains(BoundingSphere bs) {
        return thunderheadeng.geometry.Containment.convert(this.test(bs));
    }

    @Override
    public Containment test(BoundingSphere bs) {
        int partialIn = 0;
        for (int m = 0; m < 6; ++m) {
            Plane3d plane = this.d_planes[m];
            double dist = plane.dot(bs.center);
            if (dist < bs.radius) {
                ++partialIn;
                continue;
            }
            if (!(dist >= 0.0)) continue;
            return Containment.OUTSIDE;
        }
        return partialIn == 0 ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(BoundingSphere bs) {
        return this.test(bs) != Containment.OUTSIDE;
    }

    public boolean intersectsLineSeg(Point3d p1, Point3d p2, double tol) {
        if (this.contains(p1, tol) || this.contains(p2, tol)) {
            return true;
        }
        for (int m = 0; m < 6; ++m) {
            Point3d isect = Inter3D.lineSegPolyIntersection(p1, p2, this.d_planes[m], tol, this.d_faces[m]);
            if (isect == null) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsConvexPoly(double tol, Point3d ... poly) {
        for (Point3d p : poly) {
            if (!this.contains(p, tol)) continue;
            return true;
        }
        for (int m = 0; m < 6; ++m) {
            if (!Inter3D.faceFaceIsect(this.d_faces[m], poly, tol)) continue;
            return true;
        }
        return false;
    }

    public ConvexHull toConvexHull() {
        return new ConvexHull(this.d_planes);
    }

    public Box3d transform(Matrix4d mat) {
        Point3d[] newVerts = new Point3d[this.d_verts.length];
        for (int m = 0; m < this.d_verts.length; ++m) {
            newVerts[m] = Util3D.xform(mat, this.d_verts[m]);
        }
        return new Box3d(newVerts);
    }
}

