/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.delaunay;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Point2d;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.io.IOUtil;

public class TriangulationViewer
extends JPanel {
    private Vector<Point2d> d_points = new Vector();
    private Vector<Edge> d_edges = new Vector();
    private Vector<Tri> d_tris = new Vector();
    private Vector<Point2d> d_voronoiPts = new Vector();
    private Vector<int[]> d_voronoiPolys = new Vector();
    private double d_xmin;
    private double d_xmax;
    private double d_ymin;
    private double d_ymax;
    private AffineTransform d_transform = new AffineTransform();
    private float d_size = 0.0f;
    static boolean dirty = true;
    GeneralPath path;

    public static void main(String[] args) {
        System.out.println("Triangle...");
        JFrame frame = new JFrame("Triangle");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        frame.getContentPane().add(new TriangulationViewer());
        frame.pack();
        frame.setVisible(true);
    }

    public static void view(JDialog parent, TriangulatorInfo ti) {
        guiDialog dlg = new guiDialog((Window)parent, "Triangle", 1);
        dlg.getDialogPane().setLayout(new BorderLayout());
        dlg.getDialogPane().add(new TriangulationViewer(ti));
        dlg.doModal();
    }

    public TriangulationViewer() {
        this((TriangulatorInfo)null);
    }

    public TriangulationViewer(final TriangulatorInfo ti) {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                System.out.println("key pressed");
                if (e.getKeyCode() == 82) {
                    TriangulationViewer.this.init(ti);
                    TriangulationViewer.this.repaint();
                }
            }
        });
        this.init(ti);
        this.setPreferredSize(new Dimension(800, 800));
        this.setFocusable(true);
    }

    private void init(TriangulatorInfo ti) {
        if (ti != null) {
            this.initData(ti);
        } else {
            this.readFile();
        }
    }

    private void clearMinMax() {
        this.d_xmin = Double.MAX_VALUE;
        this.d_ymin = Double.MAX_VALUE;
        this.d_xmax = -1.7976931348623157E308;
        this.d_ymax = -1.7976931348623157E308;
    }

    private void updateMinMax(Point2d p) {
        if (p.x < this.d_xmin) {
            this.d_xmin = p.x;
        }
        if (p.x > this.d_xmax) {
            this.d_xmax = p.x;
        }
        if (p.y < this.d_ymin) {
            this.d_ymin = p.y;
        }
        if (p.y > this.d_ymax) {
            this.d_ymax = p.y;
        }
    }

    private void initData(TriangulatorInfo ti) {
        assert (ti.colors != null);
        this.d_points.clear();
        this.d_tris.clear();
        this.d_points.addAll(Arrays.asList(ti.points));
        for (int m = 0; m < ti.triangles.length; m += 3) {
            int t = m / 3;
            int c = ti.colors[t];
            int v1 = ti.triangles[m];
            int v2 = ti.triangles[m + 1];
            int v3 = ti.triangles[m + 2];
            this.updateMinMax(this.d_points.get(v1));
            this.updateMinMax(this.d_points.get(v2));
            this.updateMinMax(this.d_points.get(v3));
            this.d_tris.add(new Tri(v1, v2, v3, c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile() {
        int i;
        int numVerts;
        String line;
        this.d_points.clear();
        this.d_tris.clear();
        this.clearMinMax();
        BufferedReader file = null;
        try {
            file = new BufferedReader(new FileReader("triangle.data"));
            line = file.readLine();
            numVerts = Integer.parseInt(line);
            for (i = 0; i < numVerts; ++i) {
                line = file.readLine();
                String[] coords = line.split(",");
                double x = Double.parseDouble(coords[0]);
                double y = Double.parseDouble(coords[1]);
                Point2d p = new Point2d(x, y);
                this.d_points.add(p);
            }
            line = file.readLine();
            int numTris = Integer.parseInt(line);
            for (int i2 = 0; i2 < numTris; ++i2) {
                line = file.readLine();
                String[] verts = line.split(" ");
                int v1 = Integer.parseInt(verts[0]);
                int v2 = Integer.parseInt(verts[1]);
                int v3 = Integer.parseInt(verts[2]);
                int c = Integer.parseInt(verts[3]);
                this.updateMinMax(this.d_points.get(v1));
                this.updateMinMax(this.d_points.get(v2));
                this.updateMinMax(this.d_points.get(v3));
                this.d_tris.add(new Tri(v1, v2, v3, c));
            }
            while ((line = file.readLine()) != null) {
                System.out.println(line);
            }
            IOUtil.closeSilently(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtil.closeSilently(file);
        }
        file = null;
        try {
            file = new BufferedReader(new FileReader("voronoi.data"));
            line = file.readLine();
            numVerts = Integer.parseInt(line);
            for (i = 0; i < numVerts; ++i) {
                line = file.readLine();
                String[] coords = line.split(" ");
                double x = Double.parseDouble(coords[0]);
                double y = Double.parseDouble(coords[1]);
                Point2d p = new Point2d(x, y);
                this.d_voronoiPts.add(p);
            }
            line = file.readLine();
            int numPolys = Integer.parseInt(line);
            for (int i3 = 0; i3 < numPolys; ++i3) {
                line = file.readLine();
                String[] verts = line.split(" ");
                int[] poly = new int[verts.length - 1];
                for (int j = 1; j < verts.length; ++j) {
                    poly[j - 1] = Integer.parseInt(verts[j]);
                }
                this.d_voronoiPolys.add(poly);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtil.closeSilently(file);
        }
    }

    @Override
    public void paint(Graphics g) {
        int i;
        Point2D.Double p3;
        Point2D.Double p2;
        Point2D.Double p1;
        Point2d v3;
        Point2d v2;
        Point2d v1;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(SystemColor.window);
        g2d.fill(new Rectangle(this.getSize()));
        this.updateTransform();
        g2d.setPaint(Color.LIGHT_GRAY);
        this.path = new GeneralPath();
        Color[] colors = new Color[]{new Color(207, 226, 172), new Color(184, 211, 136), new Color(161, 196, 104), new Color(131, 177, 66)};
        for (Tri tri : this.d_tris) {
            g2d.setPaint(colors[tri.color]);
            this.path.reset();
            v1 = this.d_points.get(tri.p1);
            v2 = this.d_points.get(tri.p2);
            v3 = this.d_points.get(tri.p3);
            p1 = new Point2D.Double(v1.x, v1.y);
            p2 = new Point2D.Double(v2.x, v2.y);
            p3 = new Point2D.Double(v3.x, v3.y);
            this.d_transform.transform(p1, p1);
            this.d_transform.transform(p2, p2);
            this.d_transform.transform(p3, p3);
            this.path.moveTo((float)p1.x, (float)p1.y);
            this.path.lineTo((float)p2.x, (float)p2.y);
            this.path.lineTo((float)p3.x, (float)p3.y);
            this.path.lineTo((float)p1.x, (float)p1.y);
            g2d.fill(this.path);
        }
        for (int i2 = 0; i2 < this.d_tris.size(); ++i2) {
            Tri tri;
            dirty = false;
            tri = this.d_tris.get(i2);
            v1 = this.d_points.get(tri.p1);
            v2 = this.d_points.get(tri.p2);
            v3 = this.d_points.get(tri.p3);
            p1 = new Point2D.Double(v1.x, v1.y);
            p2 = new Point2D.Double(v2.x, v2.y);
            p3 = new Point2D.Double(v3.x, v3.y);
            this.d_transform.transform(p1, p1);
            this.d_transform.transform(p2, p2);
            this.d_transform.transform(p3, p3);
            this.path.moveTo((float)p1.x, (float)p1.y);
            this.path.lineTo((float)p2.x, (float)p2.y);
            this.path.lineTo((float)p3.x, (float)p3.y);
            this.path.lineTo((float)p1.x, (float)p1.y);
        }
        g2d.setColor(Color.GRAY);
        g2d.draw(this.path);
        g2d.setColor(Color.BLUE);
        for (i = 0; i < this.d_voronoiPts.size(); ++i) {
            Point2d pt = this.d_voronoiPts.get(i);
            Point2D.Double pt2 = new Point2D.Double(pt.x, pt.y);
            this.d_transform.transform(pt2, pt2);
            this.drawCircle(g2d, pt2.x, pt2.y, 1);
        }
        this.path = new GeneralPath();
        for (i = 0; i < this.d_voronoiPolys.size(); ++i) {
            int[] poly = this.d_voronoiPolys.get(i);
            int n = poly.length;
            System.out.println(n);
            for (int j = 0; j < n; ++j) {
                Point2d v12 = this.d_voronoiPts.get(poly[j]);
                System.out.println(j + " " + (j + 1) % n);
                Point2d v22 = this.d_voronoiPts.get(poly[(j + 1) % n]);
                p1 = new Point2D.Double(v12.x, v12.y);
                p2 = new Point2D.Double(v22.x, v22.y);
                this.d_transform.transform(p1, p1);
                this.d_transform.transform(p2, p2);
                this.path.moveTo((float)p1.x, (float)p1.y);
                this.path.lineTo((float)p2.x, (float)p2.y);
            }
        }
        g2d.setColor(Color.RED);
        g2d.draw(this.path);
    }

    private void updateTransform() {
        double xmin = this.d_xmin;
        double xmax = this.d_xmax;
        double ymin = this.d_ymin;
        double ymax = this.d_ymax;
        Dimension dim = this.getSize();
        this.d_transform.setToIdentity();
        double scale = Math.min((double)dim.width / (xmax - xmin) / 1.4, (double)dim.height / (ymax - ymin) / 1.4);
        this.d_transform.scale(scale, -scale);
        this.d_transform.translate(-(xmin - 0.2 * (xmax - xmin)), -(ymax + 0.2 * (ymax - ymin)));
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.updateTransform();
        this.d_size = (float)w / 800.0f;
    }

    private void drawCircle(Graphics2D gra, double x, double y, int filled) {
        Arc2D.Double circle = new Arc2D.Double(x - (double)(3.5f * this.d_size), y - (double)(3.5f * this.d_size), 7.0f * this.d_size, 7.0f * this.d_size, 0.0, 360.0, 0);
        if (filled == 0) {
            gra.draw(circle);
        } else {
            gra.fill(circle);
        }
    }

    private static class Tri {
        public int p1;
        public int p2;
        public int p3;
        public int color;

        public Tri(int v1, int v2, int v3, int c) {
            this.p1 = v1;
            this.p2 = v2;
            this.p3 = v3;
            this.color = c;
        }
    }

    private static class Edge {
        public int p1;
        public int p2;

        public Edge(int v1, int v2) {
            this.p1 = v1;
            this.p2 = v2;
        }
    }
}

