/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.delaunay;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import thunderheadeng.delaunay.GeomTests;
import thunderheadeng.delaunay.TriangulateFilter;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.delaunay.VoronoiInfo;
import thunderheadeng.util.Pair;

public class Mesh {
    public static final int EDGEID_UNCONSTRAINED = 0;
    public static final int EDGEID_BOUNDARY = 1;
    public static final int EDGEID_DEFAULT = 2;
    public static final int EDGEID_CUSTOM_OFFSET = 3;
    public static final int OPTION_REFINE = 1;
    public static final int OPTION_COLOR_DISPLAY = 2;
    public static final int OUTOPT_ADJACENCY = 1;
    public static final int OUTOPT_COLORS = 2;
    public static final int OUTOPT_EDGES = 4;
    public static final int REFOPT_CONFORMING = 1;
    public static final int REFOPT_SPLIT_BOUNDARY_EDGES = 2;
    public static final int REFOPT_DEFAULT = 3;
    private static final Logger LOGGER = Logger.getLogger(Mesh.class.getName());
    private static final double UNUSED_AREA = Double.MAX_VALUE;
    private List<Vertex> d_verts = new ArrayList<Vertex>();
    private List<Triangle> d_tris = new ArrayList<Triangle>();
    private List<Edge> d_edges = new ArrayList<Edge>();
    private Handle d_outside;
    private Vertex d_infV1;
    private Vertex d_infV2;
    private Vertex d_infV3;
    private Random d_random;
    private int[] d_resultTris;
    private boolean d_checkArea = false;
    private double d_maxArea = Double.MAX_VALUE;
    private int d_refOpts = 3;
    private int d_defEdgeId = 2;
    public static final double DEF_MIN_ANGLE = 20.0;
    double minAngle = 20.0;
    double cosmin = Math.cos(this.minAngle * Math.PI / 180.0);
    double cos2min = this.cosmin * this.cosmin;
    PriorityQueue<QTri> badTriQ = new PriorityQueue();
    Queue<QEdge> badEdgeQ = new ArrayDeque<QEdge>();
    Deque<Handle> d_undoStack = new ArrayDeque<Handle>();
    int d_undoType = 0;
    Handle d_undoVertexTri1;
    Handle d_undoVertexTri2;
    private static int SUCCESS = 0;
    private static int ENCROACHING = 1;
    private static int ERROR = -1;
    private List<Point2d> d_voronoiVerts;
    private Map<Pair<Integer, Integer>, Integer> d_voronoiMidPts;
    private List<List<Integer>> d_polys;
    private List<List<Integer>> d_adjPolys;
    private int[] d_polymap;
    private int SAMPLES = 0;
    public static final int INTRIANGLE = 1;
    public static final int ONEDGE = 2;
    public static final int ONVERTEX = 3;
    public static final int OUTSIDE = 4;

    public void setDefaultEdgeId(int id) {
        if (id == 0) {
            return;
        }
        this.d_defEdgeId = id;
    }

    public int getDefaultEdgeId() {
        return this.d_defEdgeId;
    }

    public Vertex newVertex(double x, double y) {
        return this.newVertex(x, y, Double.MAX_VALUE);
    }

    public Vertex newVertex(double x, double y, double maxArea) {
        Vertex v = new Vertex(x, y, maxArea);
        this.d_verts.add(v);
        v.id = this.d_verts.size();
        return v;
    }

    public Vertex getInfV1() {
        return this.d_infV1;
    }

    public Vertex getInfV2() {
        return this.d_infV2;
    }

    public Vertex getInfV3() {
        return this.d_infV3;
    }

    public Handle getOutside() {
        return this.d_outside;
    }

    public List<Vertex> getVerts() {
        return this.d_verts;
    }

    public List<Triangle> getTris() {
        return this.d_tris;
    }

    private Handle newTriangle(Vertex a, Vertex b, Vertex c) {
        Triangle t = new Triangle(a, b, c);
        this.d_tris.add(t);
        t.id = this.d_tris.size();
        return new Handle(t, 0);
    }

    public void addPoint(double x, double y) {
        this.addPoint(x, y, Double.MAX_VALUE);
    }

    public void addPoint(double x, double y, double maxArea) {
        this.newVertex(x, y, maxArea);
    }

    public void addPoints(double ... points) {
        assert (points.length % 2 == 0);
        for (int m = 0; m < points.length - 1; m += 2) {
            this.addPoint(points[m], points[m + 1]);
        }
    }

    public void addPoints(DoubleBuffer buffer) {
        buffer = buffer.duplicate();
        while (buffer.hasRemaining()) {
            double x = buffer.get();
            double y = buffer.get();
            this.addPoint(x, y);
        }
    }

    public void addPoints(Collection<? extends Point2d> points) {
        for (Point2d point2d : points) {
            this.addPoint(point2d.x, point2d.y);
        }
    }

    public void addEdge(int v1, int v2) {
        this.addEdge(v1, v2, this.d_defEdgeId);
    }

    public void addEdge(int v1, int v2, int id) {
        this.d_edges.add(new Edge(v1 + 1, v2 + 1, id));
    }

    public void addEdges(int ... edges) {
        assert (edges.length % 2 == 0);
        for (int m = 0; m < edges.length - 1; m += 2) {
            this.addEdge(edges[m], edges[m + 1]);
        }
    }

    public void addIdEdges(int ... edges) {
        assert (edges.length % 3 == 0);
        for (int m = 0; m < edges.length - 1; m += 3) {
            this.addEdge(edges[m], edges[m + 1], edges[m + 2]);
        }
    }

    public void addEdges(IntBuffer buffer) {
        buffer = buffer.duplicate();
        while (buffer.hasRemaining()) {
            int i1 = buffer.get();
            int i2 = buffer.get();
            this.addEdge(i1, i2);
        }
    }

    public void addIdEdges(IntBuffer buffer) {
        buffer = buffer.duplicate();
        while (buffer.hasRemaining()) {
            int i1 = buffer.get();
            int i2 = buffer.get();
            int id = buffer.get();
            this.addEdge(i1, i2, id);
        }
    }

    public void addEdges(List<Integer> edges) {
        if (edges == null) {
            return;
        }
        Iterator<Integer> it = edges.iterator();
        while (it.hasNext()) {
            int ix1 = it.next();
            if (!it.hasNext()) continue;
            int ix2 = it.next();
            this.addEdge(ix1, ix2);
        }
    }

    public void addEdges(IntStream edges) {
        int[] ix = new int[]{0};
        int[] buf = new int[2];
        edges.forEachOrdered(i -> {
            int n = ix[0];
            nArray2[0] = n + 1;
            nArray[n] = i;
            if (ix[0] == buf.length) {
                this.addEdge(buf[0], buf[1]);
                nArray2[0] = 0;
            }
        });
    }

    public void addIdEdges(IntStream edges) {
        int[] ix = new int[]{0};
        int[] buf = new int[3];
        edges.forEachOrdered(i -> {
            int n = ix[0];
            nArray2[0] = n + 1;
            nArray[n] = i;
            if (ix[0] == buf.length) {
                this.addEdge(buf[0], buf[1], buf[2]);
                nArray2[0] = 0;
            }
        });
    }

    public double checkQuality(PriorityQueue<QTri> badTriQ, Handle tri) {
        double cos2;
        Handle minAngleVertex;
        double min2;
        if (tri.tri.color == 0) {
            return 0.0;
        }
        Vertex v1 = tri.getA();
        Vertex v2 = tri.getB();
        Vertex v3 = tri.getC();
        Point2d a = v1.pt;
        Point2d b = v2.pt;
        Point2d c = v3.pt;
        double dxab = a.x - b.x;
        double dyab = a.y - b.y;
        double dxbc = b.x - c.x;
        double dybc = b.y - c.y;
        double dxca = c.x - a.x;
        double dyca = c.y - a.y;
        double dxab2 = dxab * dxab;
        double dyab2 = dyab * dyab;
        double dxbc2 = dxbc * dxbc;
        double dybc2 = dybc * dybc;
        double dxca2 = dxca * dxca;
        double dyca2 = dyca * dyca;
        double ab2 = dxab2 + dyab2;
        double bc2 = dxbc2 + dybc2;
        double ca2 = dxca2 + dyca2;
        if (ab2 < bc2 && ab2 < ca2) {
            min2 = ab2;
            minAngleVertex = tri.getHandleC();
            double C = dxca * dxbc + dyca * dybc;
            cos2 = C * C / (ca2 * bc2);
        } else if (bc2 < ca2) {
            min2 = bc2;
            minAngleVertex = tri;
            double A = dxab * dxca + dyab * dyca;
            cos2 = A * A / (ab2 * ca2);
        } else {
            min2 = ca2;
            minAngleVertex = tri.getHandleB();
            double B = dxbc * dxab + dybc * dyab;
            cos2 = B * B / (bc2 * ab2);
        }
        if (this.d_checkArea) {
            double area = 0.5 * (dxab * dybc - dyab * dxbc);
            double maxArea = this.d_maxArea;
            if (v1.maxArea < maxArea) {
                maxArea = v1.maxArea;
            }
            if (v2.maxArea < maxArea) {
                maxArea = v2.maxArea;
            }
            if (v3.maxArea < maxArea) {
                maxArea = v3.maxArea;
            }
            if (area > maxArea) {
                badTriQ.offer(new QTri(tri.tri, tri.tri.v[0], tri.tri.v[1], tri.tri.v[2], min2));
            }
        }
        if (cos2 > this.cos2min) {
            boolean constrained;
            boolean bl = constrained = minAngleVertex.isConstrained() && minAngleVertex.getHandleC().isConstrained();
            if (!constrained) {
                badTriQ.offer(new QTri(tri.tri, tri.tri.v[0], tri.tri.v[1], tri.tri.v[2], min2));
            }
        }
        return cos2;
    }

    public static int encroachSeg(Point2d a, Point2d b, Point2d c) {
        double v1x = a.x - c.x;
        double v2x = b.x - c.x;
        double v1y = a.y - c.y;
        double v2y = b.y - c.y;
        double dot = v1x * v2x + v1y * v2y;
        if (dot > 0.0) {
            return 0;
        }
        return 1;
    }

    private static boolean isBoundary(Handle edge) {
        boolean t1In = edge.tri.color != 0;
        boolean t2In = edge.getNeighborA() != null && edge.getNeighborA().tri.color != 0;
        return t1In != t2In;
    }

    private boolean checkEncroach(Queue<QEdge> badEdgeQ, Handle tri) {
        Point2d a = tri.getA().pt;
        Point2d b = tri.getB().pt;
        Point2d c = tri.getC().pt;
        if (tri.isConstrained() && Mesh.encroachSeg(a, b, c) == 1) {
            if (this.getRefinementOpt(1) && (this.getRefinementOpt(2) || !Mesh.isBoundary(tri))) {
                badEdgeQ.offer(new QEdge(new Handle(tri.tri, tri.orient), tri.getA(), tri.getB()));
                Handle mate = tri.getNeighborA();
                badEdgeQ.offer(new QEdge(new Handle(mate.tri, mate.orient), tri.getB(), tri.getA()));
            }
            return true;
        }
        return false;
    }

    private void checkEncroach(Queue<QEdge> badEdgeQ, Triangle tri) {
        this.checkEncroach(badEdgeQ, new Handle(tri, 0));
        this.checkEncroach(badEdgeQ, new Handle(tri, 1));
        this.checkEncroach(badEdgeQ, new Handle(tri, 2));
    }

    private boolean refine() {
        for (Triangle tri : this.d_tris) {
            this.checkEncroach(this.badEdgeQ, new Handle(tri, 0));
            this.checkEncroach(this.badEdgeQ, new Handle(tri, 1));
            this.checkEncroach(this.badEdgeQ, new Handle(tri, 2));
        }
        for (Triangle tri : this.d_tris) {
            this.checkQuality(this.badTriQ, new Handle(tri, 0));
        }
        while (!this.badTriQ.isEmpty() || !this.badEdgeQ.isEmpty()) {
            if (!this.badEdgeQ.isEmpty()) {
                Handle h1;
                QEdge qedge = this.badEdgeQ.remove();
                if (qedge.tri.getA() != qedge.a || qedge.tri.getB() != qedge.b) continue;
                boolean smallA = false;
                boolean smallB = false;
                if (qedge.tri.tri.color != 0 && qedge.tri.getHandleC().isConstrained()) {
                    smallA = true;
                }
                if (qedge.tri.tri.color != 0 && qedge.tri.getHandleB().isConstrained()) {
                    smallB = true;
                }
                Handle mate = qedge.tri.getNeighborA();
                if (mate.tri.color != 0 && mate.getHandleC().isConstrained()) {
                    smallB = true;
                }
                if (mate.tri.color != 0 && mate.getHandleB().isConstrained()) {
                    smallA = true;
                }
                double ax = qedge.a.pt.x;
                double ay = qedge.a.pt.y;
                double bx = qedge.b.pt.x;
                double by = qedge.b.pt.y;
                double split = 0.5;
                if (smallA && smallB) {
                    split = 0.5;
                } else if (smallA || smallB) {
                    double len = Math.sqrt((bx - ax) * (bx - ax) + (by - ay) * (by - ay));
                    double nearestpoweroftwo = 1.0;
                    while (len > 3.0 * nearestpoweroftwo) {
                        nearestpoweroftwo *= 2.0;
                    }
                    while (len < 1.5 * nearestpoweroftwo) {
                        nearestpoweroftwo *= 0.5;
                    }
                    split = nearestpoweroftwo / len;
                    if (smallB) {
                        split = 1.0 - split;
                    }
                }
                Point2d ctr = new Point2d(ax + (bx - ax) * split, ay + (by - ay) * split);
                if (ctr.x == ax && ctr.y == ay || ctr.x == bx && ctr.y == by) {
                    LOGGER.log(Level.WARNING, "Split edge too many times!");
                    return false;
                }
                Vertex v = this.newVertex(ctr.x, ctr.y);
                Handle[] newtri = new Handle[2];
                this.splitEdge(qedge.tri, v, newtri);
                Handle start = h1 = qedge.tri.getHandleC();
                Handle tri2 = h1;
                while (true) {
                    Vertex opp = tri2.getNeighborA().getC();
                    Point2d a = tri2.getA().pt;
                    Point2d b = tri2.getB().pt;
                    Point2d c = tri2.getC().pt;
                    if (!tri2.isConstrained() && GeomTests.inCircle(a, b, c, opp.pt) > 0.0) {
                        if (Mesh.swap(tri2)) continue;
                        return false;
                    }
                    this.checkEncroach(this.badEdgeQ, tri2.tri);
                    this.checkQuality(this.badTriQ, tri2);
                    if (Mesh.sameHandle(tri2 = tri2.getNeighborB().getHandleB(), start)) break;
                }
                continue;
            }
            QTri qtri = (QTri)this.badTriQ.remove();
            Triangle tri = qtri.tri;
            if (tri.v[0] != qtri.a || tri.v[1] != qtri.b || tri.v[2] != qtri.c) continue;
            Point2d ctr = this.circumcenter(new Handle(tri, 0));
            Vertex v = this.newVertex(ctr.x, ctr.y);
            int result = this.insertVertex(v, new Handle(tri, 0), true);
            if (result != ENCROACHING) continue;
            this.undoVertex();
        }
        return true;
    }

    private void CheckSuperTriColor() {
        for (Triangle tri : this.d_tris) {
            if (tri.v[0].id != this.d_infV1.id && tri.v[0].id != this.d_infV2.id && tri.v[0].id != this.d_infV3.id && tri.v[1].id != this.d_infV1.id && tri.v[1].id != this.d_infV2.id && tri.v[1].id != this.d_infV3.id && tri.v[2].id != this.d_infV1.id && tri.v[2].id != this.d_infV2.id && tri.v[2].id != this.d_infV3.id || tri.color == 0) continue;
            LOGGER.log(Level.WARNING, "bad color on outer triangle");
        }
    }

    private Point2d circumcenter(Handle tri) {
        Point2d a = tri.getA().pt;
        Point2d b = tri.getB().pt;
        Point2d c = tri.getC().pt;
        double xdo = b.x - a.x;
        double ydo = b.y - a.y;
        double xao = c.x - a.x;
        double yao = c.y - a.y;
        double dodist = xdo * xdo + ydo * ydo;
        double aodist = xao * xao + yao * yao;
        double denominator = 0.5 / GeomTests.orient2d(b, c, a);
        double dx = (yao * dodist - ydo * aodist) * denominator;
        double dy = (xdo * aodist - xao * dodist) * denominator;
        return new Point2d(a.x + dx, a.y + dy);
    }

    public void setMinAngle(double angle) {
        this.minAngle = angle;
        this.cosmin = Math.cos(angle * Math.PI / 180.0);
        this.cos2min = this.cosmin * this.cosmin;
    }

    public void setRefinementOptions(int options) {
        this.d_refOpts = options;
    }

    public int getRefinementOptions() {
        return this.d_refOpts;
    }

    public void setMaxArea(double area) {
        this.d_maxArea = area;
        this.d_checkArea = area < Double.MAX_VALUE;
    }

    private boolean getRefinementOpt(int option) {
        return (this.d_refOpts & option) == option;
    }

    public boolean triangulateEvenOdd(int options) {
        return this.triangulateEvenOdd(options, 20.0);
    }

    public boolean triangulateEvenOdd(int options, double minAngleDeg) {
        if (this.d_edges.size() < 3) {
            return false;
        }
        return this.triangulate(options, minAngleDeg, new TriangulateFilter(){

            @Override
            public boolean filter(int level, Point2d p) {
                return level % 2 != 0;
            }
        });
    }

    public boolean triangulateConvexHull(int options) {
        return this.triangulateConvexHull(options, this.minAngle);
    }

    public boolean triangulateConvexHull(int options, double minAngleDeg) {
        return this.triangulate(options, minAngleDeg, new TriangulateFilter(){

            @Override
            public boolean filter(int level, Point2d p) {
                return false;
            }
        });
    }

    public boolean triangulate(int options, double minAngleDeg, TriangulateFilter filter) {
        if (this.d_verts.size() < 3) {
            return false;
        }
        this.minAngle = minAngleDeg;
        this.cosmin = Math.cos(minAngleDeg * Math.PI / 180.0);
        this.cos2min = this.cosmin * this.cosmin;
        this.d_random = new Random(0L);
        this.init();
        Handle h1 = new Handle(this.d_tris.get(0), 0);
        for (Vertex v : this.d_verts) {
            if (v.id == this.d_verts.size() - 2) break;
            int success = this.insertVertex(v, null);
            if (success != ERROR) continue;
            return false;
        }
        ArrayDeque<Edge> queue = new ArrayDeque<Edge>();
        ArrayDeque<Edge> newEdges = new ArrayDeque<Edge>();
        for (Edge e : this.d_edges) {
            int numSwaps;
            Point2d p1 = this.d_verts.get((int)(e.v1 - 1)).pt;
            Point2d p2 = this.d_verts.get((int)(e.v2 - 1)).pt;
            int findResult = this.findTriangle(p1, null, h1);
            findResult = this.findEdgeStart(new Handle(h1), p2, h1);
            queue.clear();
            newEdges.clear();
            if (findResult == 2) {
                if (h1.getB().pt.equals((Tuple2d)p2)) {
                    Mesh.markEdge(h1, e.id);
                    continue;
                }
                if (h1.getC().pt.equals((Tuple2d)p2)) {
                    Mesh.markEdge(h1.getHandleC(), e.id);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Triangulation error imposing constraints");
                return false;
            }
            queue.offer(new Edge(h1.getB().id, h1.getC().id, -1));
            Handle tri = h1.getNeighborB();
            while (true) {
                double orient;
                if ((orient = GeomTests.orient2d(p1, p2, tri.getC().pt)) > 0.0) {
                    queue.offer(new Edge(tri.getB().id, tri.getC().id, -1));
                    tri = tri.getNeighborB();
                    continue;
                }
                if (orient < 0.0) {
                    queue.offer(new Edge(tri.getA().id, tri.getC().id, -1));
                    tri = tri.getNeighborC();
                    continue;
                }
                if (orient == 0.0) break;
            }
            if (!tri.getC().pt.equals((Tuple2d)p2)) assert (false);
            while (!queue.isEmpty()) {
                Edge edg = (Edge)queue.remove();
                Handle diag = this.findEdge(edg.v1, edg.v2);
                if (diag == null) {
                    // empty if block
                }
                if (this.isConvex(diag)) {
                    if (!Mesh.swap(diag)) {
                        return false;
                    }
                    int v1 = diag.getB().id;
                    int v2 = diag.getC().id;
                    if (v1 != e.v1 && v1 != e.v2 && v2 != e.v1 && v2 != e.v2) {
                        double ccw1 = GeomTests.orient2d(p1, p2, diag.getB().pt);
                        double ccw2 = GeomTests.orient2d(p1, p2, diag.getC().pt);
                        if (ccw1 < 0.0 && ccw2 > 0.0 || ccw1 > 0.0 && ccw2 < 0.0) {
                            ccw1 = GeomTests.orient2d(diag.getB().pt, diag.getC().pt, p1);
                            ccw2 = GeomTests.orient2d(diag.getB().pt, diag.getC().pt, p2);
                            if (ccw1 < 0.0 && ccw2 > 0.0 || ccw1 > 0.0 && ccw2 < 0.0) {
                                queue.offer(new Edge(v1, v2, -1));
                                continue;
                            }
                        }
                    }
                    if (!(v1 != e.v1 && v1 != e.v2 || v2 != e.v1 && v2 != e.v2)) {
                        Mesh.markEdge(diag.getHandleB(), e.id);
                        continue;
                    }
                    newEdges.offer(new Edge(v1, v2, -1));
                    continue;
                }
                queue.offer(edg);
            }
            do {
                numSwaps = 0;
                for (Edge edg : newEdges) {
                    Point2d d;
                    Point2d c;
                    Point2d b;
                    Point2d a;
                    Handle abc = this.findEdge(edg.v1, edg.v2);
                    if (abc == null || !(GeomTests.inCircle(a = abc.getA().pt, b = abc.getB().pt, c = abc.getC().pt, d = abc.getNeighborA().getC().pt) > 0.0)) continue;
                    if (!this.isConvex(abc)) {
                        return false;
                    }
                    if (!Mesh.swap(abc)) {
                        return false;
                    }
                    edg.v1 = abc.getB().id;
                    edg.v2 = abc.getC().id;
                    ++numSwaps;
                }
            } while (numSwaps > 0);
        }
        int numRegions = this.classify(filter);
        assert (numRegions > 0);
        if ((options & 1) == 1) {
            this.refine();
        }
        if ((options & 2) == 2) {
            this.colorTriangles();
        }
        this.markBoundary();
        return true;
    }

    private void markBoundary() {
        for (Triangle tri : this.d_tris) {
            for (int m = 0; m < 3; ++m) {
                Handle edge = new Handle(tri, m);
                if (!Mesh.isBoundary(edge) || edge.isConstrained()) continue;
                Mesh.markEdge(edge, 1);
            }
        }
    }

    private int insertVertex(Vertex v, Handle searchTri) {
        return this.insertVertex(v, searchTri, false);
    }

    private int insertVertex(Vertex v, Handle searchTri, boolean refine) {
        Handle h1 = new Handle();
        int findResult = this.findTriangle(v.pt, searchTri, h1);
        Handle[] newtri = new Handle[2];
        if (findResult == 1) {
            if (refine && h1.tri.color == 0) {
                return 4;
            }
            this.split(h1, v, newtri);
        } else if (findResult == 2) {
            if (refine && h1.isConstrained()) {
                return 4;
            }
            this.splitEdge(h1, v, newtri);
            h1 = h1.getHandleC();
        } else {
            if (findResult == 4) {
                return 4;
            }
            if (findResult == 3) {
                LOGGER.log(Level.WARNING, "***ERROR - hit vertex during insert");
                return 3;
            }
        }
        this.d_undoType = findResult;
        this.d_undoVertexTri1 = newtri[0];
        this.d_undoVertexTri2 = newtri[1];
        this.d_undoStack.clear();
        boolean encroaching = false;
        Handle tri = h1;
        Vertex start = tri.getA();
        while (true) {
            Vertex opp = tri.getNeighborA().getC();
            Point2d a = tri.getA().pt;
            Point2d b = tri.getB().pt;
            Point2d c = tri.getC().pt;
            if (!tri.isConstrained() && GeomTests.inCircle(a, b, c, opp.pt) > 0.0) {
                if (!Mesh.swap2(tri)) {
                    return ERROR;
                }
                this.d_undoStack.push(tri);
                tri = tri.getHandleC();
                continue;
            }
            if (refine) {
                this.checkQuality(this.badTriQ, tri);
                if (this.checkEncroach(this.badEdgeQ, tri) || this.checkEncroach(this.badEdgeQ, tri.getHandleB()) || this.checkEncroach(this.badEdgeQ, tri.getHandleC())) {
                    encroaching = true;
                }
            }
            if ((tri = tri.getNeighborB().getHandleB()).getA() == start) break;
        }
        if (encroaching) {
            return ENCROACHING;
        }
        return SUCCESS;
    }

    private boolean undoVertex() {
        while (!this.d_undoStack.isEmpty()) {
            Handle tri = this.d_undoStack.pop();
            Mesh.unswap(tri);
        }
        Vertex v = this.d_undoVertexTri1.getC();
        if (this.d_undoType == 1) {
            this.unsplit(this.d_undoVertexTri1, this.d_undoVertexTri2);
            this.deleteVertex(v);
        } else if (this.d_undoType == 2) {
            this.unsplitEdge(this.d_undoVertexTri1, this.d_undoVertexTri2);
            this.deleteVertex(v);
        }
        return true;
    }

    private void unsplit(Handle t1, Handle t2) {
        assert (t1.getC().id == t2.getC().id);
        Handle cb = t1.getNeighborA();
        Handle ac = t2.getNeighborA();
        Vertex c = t1.getB();
        Handle tri = t1.getNeighborC().getHandleC();
        tri.setC(c);
        Mesh.bond(tri.getHandleB(), cb);
        Mesh.bond(tri.getHandleC(), ac);
        assert (!tri.getHandleB().isConstrained());
        assert (!tri.getHandleC().isConstrained());
        tri.getHandleB().setEdgeId(cb.getEdgeId());
        tri.getHandleC().setEdgeId(ac.getEdgeId());
        this.deleteTriangle(t2.tri);
        this.deleteTriangle(t1.tri);
    }

    private void unsplitEdge(Handle t1, Handle t2) {
        assert (t1.getC().id == t2.getC().id);
        Handle cb = t1.getNeighborA();
        Handle bd = t2.getNeighborA();
        Vertex b = t1.getA();
        Handle tri = t1.getNeighborB().getHandleC();
        Handle mate = t2.getNeighborC().getHandleB();
        tri.setB(b);
        mate.setA(b);
        Mesh.bond(tri.getHandleB(), cb);
        Mesh.bond(mate.getHandleC(), bd);
        tri.getHandleB().setEdgeId(cb.getEdgeId());
        mate.getHandleC().setEdgeId(bd.getEdgeId());
        this.deleteTriangle(t2.tri);
        this.deleteTriangle(t1.tri);
    }

    private static <T> void rremove(List<T> list, T item) {
        for (int m = list.size() - 1; m >= 0; --m) {
            if (!list.get(m).equals(item)) continue;
            list.remove(m);
            return;
        }
    }

    private void deleteTriangle(Triangle tri) {
        assert (tri.id == this.d_tris.size());
        Mesh.rremove(this.d_tris, tri);
        tri.id = -1;
        tri.v[2] = null;
        tri.v[1] = null;
        tri.v[0] = null;
        tri.tri[2] = null;
        tri.tri[1] = null;
        tri.tri[0] = null;
    }

    private void deleteVertex(Vertex v) {
        assert (v.id == this.d_verts.size());
        Mesh.rremove(this.d_verts, v);
    }

    private int addVoronoiVertex(Point2d pt) {
        this.d_voronoiVerts.add(pt);
        return this.d_voronoiVerts.size();
    }

    private int getVoronoiMidVertex(int v1, int v2) {
        assert (v1 != v2);
        Pair<Integer, Integer> key = v1 < v2 ? new Pair<Integer, Integer>(v1, v2) : new Pair<Integer, Integer>(v2, v1);
        if (this.d_voronoiMidPts.containsKey(key)) {
            int id = this.d_voronoiMidPts.get(key);
            return id;
        }
        Point2d p1 = this.d_verts.get((int)(v1 - 1)).pt;
        Point2d p2 = this.d_verts.get((int)(v2 - 1)).pt;
        double x = (p1.x + p2.x) / 2.0;
        double y = (p1.y + p2.y) / 2.0;
        Point2d mid = new Point2d(x, y);
        int id = this.addVoronoiVertex(mid);
        this.d_voronoiMidPts.put(key, id);
        return id;
    }

    private List<Integer> newPolygon() {
        ArrayList<Integer> poly = new ArrayList<Integer>();
        this.d_polys.add(poly);
        return poly;
    }

    private List<Integer> newPolygonAdj() {
        ArrayList<Integer> adjpoly = new ArrayList<Integer>();
        this.d_adjPolys.add(adjpoly);
        return adjpoly;
    }

    private void updateVoronoiData() {
        this.d_polys = new ArrayList<List<Integer>>();
        this.d_adjPolys = new ArrayList<List<Integer>>();
        this.d_voronoiVerts = new ArrayList<Point2d>();
        this.d_voronoiMidPts = new HashMap<Pair<Integer, Integer>, Integer>();
        this.d_polymap = new int[this.d_verts.size()];
        int count = 0;
        for (Triangle tri : this.d_tris) {
            assert (++count == tri.id);
            Point2d ctr = this.circumcenter(new Handle(tri, 0));
            this.addVoronoiVertex(ctr);
        }
        double big_area = GeomTests.orient2d(this.d_infV1.pt, this.d_infV2.pt, this.d_infV3.pt);
        double TOL = big_area * 1.0E-20;
        int polycount = 0;
        for (Vertex v : this.d_verts) {
            if (v.id == this.d_infV1.id || v.id == this.d_infV2.id || v.id == this.d_infV3.id) {
                this.d_polymap[v.id - 1] = -1;
                continue;
            }
            this.d_polymap[v.id - 1] = polycount++;
        }
        for (Vertex v : this.d_verts) {
            if (v.id == this.d_infV1.id || v.id == this.d_infV2.id || v.id == this.d_infV3.id) continue;
            Handle tri = new Handle(this.d_tris.get(0), 0);
            int result = this.findTriangle(v.pt, null, tri);
            if (result != 3) {
                LOGGER.log(Level.WARNING, "not ONVERTEX in updateVoronoiData");
                continue;
            }
            List<Integer> polys = this.newPolygon();
            List<Integer> adjpolys = this.newPolygonAdj();
            int start = tri.tri.id;
            Point2d exitPt = null;
            Point2d enterPt = null;
            do {
                int corner;
                double ccw;
                Point2d midPt;
                Handle prev = tri.getNeighborA().getHandleB();
                Handle next = tri.getNeighborC();
                if (prev.tri.color != 0 && tri.tri.color == 0) {
                    Point2d corner2;
                    double ccw2;
                    int mid = this.getVoronoiMidVertex(v.id, tri.getB().id);
                    exitPt = this.d_voronoiVerts.get(mid - 1);
                    this.addPolyPoint(polys, mid - 1, adjpolys, -1);
                    if (tri.tri.color == 0 && next.tri.color != 0) {
                        int mid2 = this.getVoronoiMidVertex(v.id, next.getB().id);
                        midPt = this.d_voronoiVerts.get(mid2 - 1);
                        ccw = GeomTests.orient2d(exitPt, midPt, v.pt);
                        if (Math.abs(ccw) > TOL) {
                            corner = this.addVoronoiVertex(v.pt);
                            this.addPolyPoint(polys, corner - 1, adjpolys, -1);
                        }
                        this.addPolyPoint(polys, mid2 - 1, adjpolys, next.getB().id - 1);
                    } else if (enterPt != null && Math.abs(ccw2 = GeomTests.orient2d(exitPt, enterPt, corner2 = this.d_voronoiVerts.get(polys.get(0)))) <= TOL) {
                        polys.remove(0);
                        adjpolys.remove(0);
                    }
                } else if (tri.tri.color == 0 && next.tri.color != 0) {
                    int mid;
                    if (exitPt != null) {
                        Point2d lastPt = exitPt;
                        mid = this.getVoronoiMidVertex(v.id, next.getB().id);
                        enterPt = midPt = this.d_voronoiVerts.get(mid - 1);
                        ccw = GeomTests.orient2d(lastPt, midPt, v.pt);
                        if (Math.abs(ccw) > TOL) {
                            corner = this.addVoronoiVertex(v.pt);
                            this.addPolyPoint(polys, corner - 1, adjpolys, -1);
                        }
                        this.addPolyPoint(polys, mid - 1, adjpolys, next.getB().id - 1);
                    } else {
                        int corner3 = this.addVoronoiVertex(v.pt);
                        this.addPolyPoint(polys, corner3 - 1, adjpolys, -1);
                        mid = this.getVoronoiMidVertex(v.id, next.getB().id);
                        this.addPolyPoint(polys, mid - 1, adjpolys, next.getB().id - 1);
                        enterPt = this.d_voronoiVerts.get(mid - 1);
                    }
                } else if (!(prev.tri.color == 0 && tri.tri.color == 0 && next.tri.color == 0 || prev.tri.color != 0 && tri.tri.color == 0 && next.tri.color != 0)) {
                    this.addPolyPoint(polys, tri.tri.id - 1, adjpolys, tri.getC().id - 1);
                }
                tri = next;
            } while (tri.tri.id != start);
            this.checkPoly(polys, adjpolys);
        }
    }

    private boolean addPolyPoint(List<Integer> poly, int vert, List<Integer> adj, int adjPoly) {
        adjPoly = adjPoly == -1 ? -1 : this.d_polymap[adjPoly];
        int size = poly.size();
        if (size > 0 && this.d_voronoiVerts.get(poly.get(size - 1)).equals((Tuple2d)this.d_voronoiVerts.get(vert))) {
            adj.set(adj.size() - 1, adjPoly);
            return false;
        }
        poly.add(vert);
        adj.add(adjPoly);
        return true;
    }

    private void checkPoly(List<Integer> poly, List<Integer> adjpolys) {
        if (poly.isEmpty()) {
            return;
        }
        if (this.d_voronoiVerts.get(poly.get(0)).equals((Tuple2d)this.d_voronoiVerts.get(poly.get(poly.size() - 1)))) {
            poly.remove(poly.size() - 1);
            adjpolys.remove(adjpolys.size() - 1);
        }
        assert (poly.size() == adjpolys.size());
    }

    public VoronoiInfo getVoronoiOutput() {
        int j;
        int i;
        this.updateVoronoiData();
        VoronoiInfo vi = new VoronoiInfo();
        Point2d[] usedPoints = new Point2d[this.d_voronoiVerts.size()];
        for (int i2 = 0; i2 < this.d_polys.size(); ++i2) {
            List<Integer> poly = this.d_polys.get(i2);
            for (int j2 = 0; j2 < poly.size(); ++j2) {
                int ix = (Integer)poly.get(j2);
                usedPoints[ix] = this.d_voronoiVerts.get(ix);
            }
        }
        int numUsed = 0;
        for (Point2d point2d : usedPoints) {
            if (point2d == null) continue;
            ++numUsed;
        }
        int pix = 0;
        vi.points = new Point2d[numUsed];
        int[] pLookup = new int[usedPoints.length];
        for (i = 0; i < usedPoints.length; ++i) {
            int newix;
            Point2d point2d = usedPoints[i];
            if (point2d == null) continue;
            pLookup[i] = newix = pix++;
            vi.points[newix] = point2d;
        }
        vi.polys = new int[this.d_polys.size()][];
        for (i = 0; i < this.d_polys.size(); ++i) {
            List<Integer> list = this.d_polys.get(i);
            vi.polys[i] = new int[list.size()];
            for (j = 0; j < list.size(); ++j) {
                vi.polys[i][j] = pLookup[list.get(j)];
            }
        }
        vi.adjPolys = new int[this.d_adjPolys.size()][];
        for (i = 0; i < this.d_adjPolys.size(); ++i) {
            List<Integer> list = this.d_adjPolys.get(i);
            vi.adjPolys[i] = new int[list.size()];
            for (j = 0; j < list.size(); ++j) {
                vi.adjPolys[i][j] = list.get(j);
            }
        }
        return vi;
    }

    public void writeVoronoi() {
        try {
            int i;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("voronoi.data")));
            VoronoiInfo vi = this.getVoronoiOutput();
            out.println(vi.points.length);
            for (i = 0; i < vi.points.length; ++i) {
                Point2d ctr = vi.points[i];
                out.println(ctr.x + " " + ctr.y);
            }
            out.println(vi.polys.length);
            for (i = 0; i < vi.polys.length; ++i) {
                int[] poly = vi.polys[i];
                out.print(poly.length);
                for (int j = 0; j < poly.length; ++j) {
                    out.print(" " + poly[j]);
                }
                out.println();
            }
            out.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    public void writeVoronoiOld() {
        try {
            int i;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("voronoi.data")));
            int count = 0;
            for (Triangle tri : this.d_tris) {
                assert (++count == tri.id);
                Point2d ctr = this.circumcenter(new Handle(tri, 0));
                this.addVoronoiVertex(ctr);
            }
            for (Vertex v : this.d_verts) {
                if (v.id == this.d_infV1.id || v.id == this.d_infV2.id || v.id == this.d_infV3.id) continue;
                LOGGER.log(Level.FINER, "around v " + v.id);
                Handle tri = new Handle(this.d_tris.get(0), 0);
                int result = this.findTriangle(v.pt, null, tri);
                assert (result == 3);
                List<Integer> polys = this.newPolygon();
                int start = tri.tri.id;
                do {
                    Handle prev = tri.getNeighborA().getHandleB();
                    Handle next = tri.getNeighborC();
                    LOGGER.log(Level.FINER, prev.tri.color + " " + tri.tri.color + " " + next.tri.color);
                    if (prev.tri.color != 0 && tri.tri.color == 0) {
                        LOGGER.log(Level.FINER, "leaving mesh, use midpoint " + v.id);
                        int mid = this.getVoronoiMidVertex(v.id, tri.getB().id);
                        LOGGER.log(Level.FINER, "  mid: " + mid);
                        polys.add(mid - 1);
                    } else if (tri.tri.color == 0 && next.tri.color != 0) {
                        LOGGER.log(Level.FINER, "entering mesh, use midpoint " + v.id);
                        int corner = this.addVoronoiVertex(v.pt);
                        polys.add(corner - 1);
                        int mid = this.getVoronoiMidVertex(v.id, next.getB().id);
                        polys.add(mid - 1);
                        LOGGER.log(Level.FINER, "  mid: " + mid);
                    } else if (prev.tri.color == 0 && tri.tri.color == 0 && next.tri.color == 0) {
                        LOGGER.log(Level.FINER, "corner??? " + v.id);
                    } else if (prev.tri.color != 0 && tri.tri.color == 0 && next.tri.color != 0) {
                        LOGGER.log(Level.FINER, "corner 2 ??? " + v.id);
                    } else {
                        polys.add(tri.tri.id - 1);
                    }
                    tri = next;
                } while (tri.tri.id != start);
            }
            out.println(this.d_voronoiVerts.size());
            for (i = 0; i < this.d_voronoiVerts.size(); ++i) {
                Point2d ctr = this.d_voronoiVerts.get(i);
                out.println(ctr.x + " " + ctr.y);
            }
            out.println(this.d_verts.size() - 3);
            for (i = 0; i < this.d_polys.size(); ++i) {
                List<Integer> poly = this.d_polys.get(i);
                out.print(poly.size());
                for (int j = 0; j < poly.size(); ++j) {
                    out.print(" " + poly.get(j));
                }
                out.println();
            }
            out.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    boolean isConvex(Handle abc) {
        Point2d a = abc.getA().pt;
        Point2d b = abc.getB().pt;
        Point2d c = abc.getC().pt;
        Point2d d = abc.getNeighborA().getC().pt;
        double ccw1 = GeomTests.orient2d(c, d, b);
        double ccw2 = GeomTests.orient2d(d, c, a);
        return ccw1 > 0.0 && ccw2 > 0.0;
    }

    public static void markEdge(Handle abc, int edgeId) {
        abc.setEdgeId(edgeId);
        abc.getNeighborA().setEdgeId(edgeId);
    }

    Handle findEdge(int v1, int v2) {
        Handle tri = new Handle(this.d_tris.get(0), 0);
        int result = this.findTriangle(this.d_verts.get((int)(v1 - 1)).pt, null, tri);
        assert (result == 3);
        int start = tri.getB().id;
        do {
            if (tri.getB().id == v2) {
                return tri;
            }
            tri = tri.getNeighborC();
        } while (tri.getB().id != start);
        return null;
    }

    int findEdgeStart(Handle start, Point2d end, Handle result) {
        boolean bLeft;
        boolean cRight;
        Point2d a = start.getA().pt;
        Point2d c = start.getC().pt;
        double cOrient = GeomTests.orient2d(a, end, c);
        boolean bl = cRight = cOrient < 0.0;
        while (cRight) {
            start = start.getNeighborC();
            cOrient = GeomTests.orient2d(start.getA().pt, end, start.getC().pt);
            cRight = cOrient < 0.0;
        }
        double bOrient = GeomTests.orient2d(start.getA().pt, end, start.getB().pt);
        boolean bl2 = bLeft = bOrient > 0.0;
        while (bLeft) {
            start = start.getNeighborA().getHandleB();
            bOrient = GeomTests.orient2d(start.getA().pt, end, start.getB().pt);
            bLeft = bOrient > 0.0;
        }
        result.tri = start.tri;
        result.orient = start.orient;
        cOrient = GeomTests.orient2d(start.getA().pt, end, start.getC().pt);
        if (cOrient == 0.0 || bOrient == 0.0) {
            return 2;
        }
        return 1;
    }

    public static boolean swap(Handle edge) {
        if (edge.isConstrained()) {
            LOGGER.log(Level.WARNING, "error -- trying to swap constrained edge");
            return false;
        }
        Vertex c = edge.getC();
        Handle mate = edge.getNeighborA();
        Vertex d = mate.getC();
        if (edge.tri.color == 0 || mate.tri.color == 0) {
            edge.tri.color = 0;
            mate.tri.color = 0;
        }
        edge.setB(d);
        mate.setB(c);
        Mesh.bond(mate.getNeighborB(), edge);
        Mesh.bond(edge.getNeighborB(), mate);
        Mesh.bond(edge.getHandleB(), mate.getHandleB());
        Mesh.markEdge(edge, mate.getHandleB().getEdgeId());
        mate.getHandleB().setUnconstrained();
        Mesh.markEdge(mate, edge.getHandleB().getEdgeId());
        edge.getHandleB().setUnconstrained();
        return true;
    }

    public static boolean swap2(Handle edge) {
        if (edge.isConstrained()) {
            LOGGER.log(Level.WARNING, "error -- trying to swap constrained edge");
            return false;
        }
        Vertex a = edge.getA();
        Vertex b = edge.getB();
        Vertex c = edge.getC();
        Handle mate = edge.getNeighborA();
        Vertex d = mate.getC();
        if (edge.tri.color == 0 || mate.tri.color == 0) {
            edge.tri.color = 0;
            mate.tri.color = 0;
        }
        edge.setA(d);
        edge.setB(c);
        edge.setC(a);
        mate.setA(c);
        mate.setB(d);
        mate.setC(b);
        Handle cb = edge.getNeighborB();
        Handle ac = edge.getNeighborC();
        Handle da = mate.getNeighborB();
        Handle bd = mate.getNeighborC();
        Mesh.bond(edge.getHandleB(), ac);
        Mesh.bond(edge.getHandleC(), da);
        Mesh.bond(mate.getHandleB(), bd);
        Mesh.bond(mate.getHandleC(), cb);
        Arrays.fill(edge.tri.edgeIds, 0);
        Arrays.fill(mate.tri.edgeIds, 0);
        Mesh.markEdge(cb, cb.getEdgeId());
        Mesh.markEdge(ac, ac.getEdgeId());
        Mesh.markEdge(da, da.getEdgeId());
        Mesh.markEdge(bd, bd.getEdgeId());
        return true;
    }

    public static boolean unswap(Handle edge) {
        if (edge.isConstrained()) {
            LOGGER.log(Level.WARNING, "error -- trying to swap constrained edge");
            return false;
        }
        Vertex a = edge.getA();
        Vertex b = edge.getB();
        Vertex c = edge.getC();
        Handle mate = edge.getNeighborA();
        Vertex d = mate.getC();
        if (edge.tri.color == 0 || mate.tri.color == 0) {
            edge.tri.color = 0;
            mate.tri.color = 0;
        }
        edge.setA(c);
        edge.setB(d);
        edge.setC(b);
        mate.setA(d);
        mate.setB(c);
        mate.setC(a);
        Handle cb = edge.getNeighborB();
        Handle ac = edge.getNeighborC();
        Handle da = mate.getNeighborB();
        Handle bd = mate.getNeighborC();
        Mesh.bond(mate.getHandleB(), ac);
        Mesh.bond(mate.getHandleC(), da);
        Mesh.bond(edge.getHandleB(), bd);
        Mesh.bond(edge.getHandleC(), cb);
        Arrays.fill(edge.tri.edgeIds, 0);
        Arrays.fill(mate.tri.edgeIds, 0);
        Mesh.markEdge(cb, cb.getEdgeId());
        Mesh.markEdge(ac, ac.getEdgeId());
        Mesh.markEdge(da, da.getEdgeId());
        Mesh.markEdge(bd, bd.getEdgeId());
        return true;
    }

    private int classify(TriangulateFilter filter) {
        this.initAndMarkBoundary();
        ArrayDeque<Triangle> stack1 = new ArrayDeque<Triangle>();
        ArrayDeque stack2 = new ArrayDeque();
        ArrayDeque<Triangle> neighbors = stack1;
        boolean trisOnLevel1 = this.markLevel1Tris(filter, neighbors);
        ArrayDeque<Triangle> work = neighbors;
        neighbors = stack2;
        int level = 2;
        while (!work.isEmpty()) {
            Triangle tri = (Triangle)work.pop();
            if (tri.color == -1) {
                this.markTriangle(tri, (short)level, neighbors, filter);
            }
            if (!work.isEmpty()) continue;
            ++level;
            ArrayDeque<Triangle> tmp = work;
            work = neighbors;
            neighbors = tmp;
        }
        int numLevels = level;
        if (!trisOnLevel1) {
            --numLevels;
        }
        return numLevels;
    }

    private void initAndMarkBoundary() {
        for (Triangle tri : this.d_tris) {
            if (tri.v[0].id == this.d_infV1.id || tri.v[0].id == this.d_infV2.id || tri.v[0].id == this.d_infV3.id || tri.v[1].id == this.d_infV1.id || tri.v[1].id == this.d_infV2.id || tri.v[1].id == this.d_infV3.id || tri.v[2].id == this.d_infV1.id || tri.v[2].id == this.d_infV2.id || tri.v[2].id == this.d_infV3.id) {
                tri.color = 0;
                continue;
            }
            tri.color = (short)-1;
        }
    }

    private boolean markLevel1Tris(TriangulateFilter filter, Deque<Triangle> neighbors) {
        boolean trisOnLevel1 = false;
        for (Triangle tri : this.d_tris) {
            if (tri.color != 0) continue;
            for (int m = 0; m < 3; ++m) {
                if (tri.tri[m].tri.color == -1 && tri.isConstrained(m)) {
                    neighbors.add(tri.tri[m].tri);
                    continue;
                }
                if (tri.tri[m].tri.color != -1 || tri.isConstrained(m)) continue;
                trisOnLevel1 = true;
                this.markTriangle(tri.tri[m].tri, (short)1, neighbors, filter);
            }
        }
        return trisOnLevel1;
    }

    private static Point2d centroid(Point2d p1, Point2d p2, Point2d p3) {
        return new Point2d((p1.x + p2.x + p3.x) / 3.0, (p1.y + p2.y + p3.y) / 3.0);
    }

    private void markTriangle(Triangle t, short color, Deque<Triangle> neighbors, TriangulateFilter filter) {
        assert (t.color == -1);
        boolean shouldFilter = filter.filter(color, t.centroid());
        if (shouldFilter) {
            color = 0;
        }
        ArrayDeque<Triangle> stack = new ArrayDeque<Triangle>();
        stack.push(t);
        while (!stack.isEmpty()) {
            Triangle tri = (Triangle)stack.pop();
            if (tri.color == color) continue;
            tri.color = color;
            for (int m = 0; m < 3; ++m) {
                boolean constrained = tri.isConstrained(m);
                if (constrained && tri.tri[m].tri.color == -1) {
                    neighbors.push(tri.tri[m].tri);
                    continue;
                }
                if (constrained || tri.tri[m].tri.color != -1) continue;
                stack.push(tri.tri[m].tri);
            }
        }
    }

    public void colorTriangles() {
        ArrayDeque<Handle> stack = new ArrayDeque<Handle>();
        stack.push(this.d_outside);
        while (!stack.isEmpty()) {
            Handle tri = (Handle)stack.pop();
            int colorA = tri.getNeighborA().tri.color2;
            int colorB = tri.getNeighborB().tri.color2;
            int colorC = tri.getNeighborC().tri.color2;
            tri.tri.color2 = this.chooseColor(colorA, colorB, colorC);
            if (colorA == -1) {
                stack.push(tri.getNeighborA());
            }
            if (colorB == -1) {
                stack.push(tri.getNeighborB());
            }
            if (colorC != -1) continue;
            stack.push(tri.getNeighborC());
        }
    }

    private int chooseColor(int a, int b, int c) {
        boolean used0 = false;
        boolean used1 = false;
        boolean used2 = false;
        boolean used3 = false;
        if (a == 0 || b == 0 || c == 0) {
            used0 = true;
        }
        if (a == 1 || b == 1 || c == 1) {
            used1 = true;
        }
        if (a == 2 || b == 2 || c == 2) {
            used2 = true;
        }
        if (a == 3 || b == 3 || c == 3) {
            used3 = true;
        }
        if (!used0) {
            return 0;
        }
        if (!used1) {
            return 1;
        }
        if (!used2) {
            return 2;
        }
        if (!used3) {
            return 3;
        }
        return -1;
    }

    public void init() {
        this.d_resultTris = null;
        this.d_tris.clear();
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        for (Vertex v : this.d_verts) {
            xmin = Math.min(xmin, v.pt.x);
            xmax = Math.max(xmax, v.pt.x);
            ymin = Math.min(ymin, v.pt.y);
            ymax = Math.max(ymax, v.pt.y);
        }
        double w = Math.max(xmax - xmin, ymax - ymin);
        Vertex v1 = this.d_infV1 = this.newVertex(xmin - 50.0 * w, ymin - 40.0 * w);
        Vertex v2 = this.d_infV2 = this.newVertex(xmax + 50.0 * w, ymin - 40.0 * w);
        Vertex v3 = this.d_infV3 = this.newVertex(xmin + 0.5 * w, ymax + 60.0 * w);
        Triangle out = new Triangle(v1, v3, v2);
        this.d_outside = new Handle(out, 0);
        Handle tri = this.newTriangle(v1, v2, v3);
        Mesh.bond(tri, this.d_outside.getHandleC());
        Mesh.bond(tri.getHandleB(), this.d_outside.getHandleB());
        Mesh.bond(tri.getHandleC(), this.d_outside);
    }

    public static void bond(Handle t1, Handle t2) {
        assert (t1.getA() == t2.getB());
        assert (t2.getA() == t1.getB());
        t1.setNeighborA(t2);
        t2.setNeighborA(t1);
    }

    public void split(Handle tri, Vertex v, Handle[] newtri) {
        Vertex a = tri.getA();
        Vertex b = tri.getB();
        Vertex c = tri.getC();
        tri.setC(v);
        Handle t1 = this.newTriangle(b, c, v);
        Handle t2 = this.newTriangle(c, a, v);
        t1.tri.color = tri.tri.color;
        t2.tri.color = tri.tri.color;
        Mesh.bond(t1, tri.getNeighborB());
        Mesh.bond(t2, tri.getNeighborC());
        Mesh.bond(t1.getHandleB(), t2.getHandleC());
        Mesh.bond(t2.getHandleB(), tri.getHandleC());
        Mesh.bond(tri.getHandleB(), t1.getHandleC());
        t1.setEdgeId(tri.getHandleB().getEdgeId());
        t2.setEdgeId(tri.getHandleC().getEdgeId());
        tri.getHandleB().setUnconstrained();
        tri.getHandleC().setUnconstrained();
        newtri[0] = t1;
        newtri[1] = t2;
    }

    public void splitEdge(Handle tri, Vertex v, Handle[] newtri) {
        Vertex b = tri.getB();
        Vertex c = tri.getC();
        Handle mate = tri.getNeighborA();
        Vertex d = mate.getC();
        tri.setB(v);
        mate.setA(v);
        Handle t1 = this.newTriangle(b, c, v);
        Handle t2 = this.newTriangle(d, b, v);
        t1.tri.color = tri.tri.color;
        t2.tri.color = mate.tri.color;
        Mesh.bond(t1, tri.getNeighborB());
        Mesh.bond(t2, mate.getNeighborC());
        Mesh.bond(mate.getHandleC(), t2.getHandleC());
        Mesh.bond(tri.getHandleB(), t1.getHandleB());
        Mesh.bond(t1.getHandleC(), t2.getHandleB());
        t1.getHandleC().setEdgeId(tri.getEdgeId());
        t2.getHandleB().setEdgeId(mate.getEdgeId());
        t1.setEdgeId(tri.getHandleB().getEdgeId());
        t2.setEdgeId(mate.getHandleC().getEdgeId());
        tri.getHandleB().setUnconstrained();
        mate.getHandleC().setUnconstrained();
        newtri[0] = t1;
        newtri[1] = t2;
    }

    public Triangle findTriangleSlow(Point2d p) {
        for (Triangle t : this.d_tris) {
            Point2d a = t.v[0].pt;
            Point2d b = t.v[1].pt;
            Point2d c = t.v[2].pt;
            if (!(GeomTests.orient2d(a, b, p) > 0.0) || !(GeomTests.orient2d(b, c, p) > 0.0) || !(GeomTests.orient2d(c, a, p) > 0.0)) continue;
            return t;
        }
        return null;
    }

    public int findOutputTriangle(double x, double y) {
        Triangle t = this.findTriangle(new Point2d(x, y));
        if (t == null) {
            return -1;
        }
        this.updateOutputTris();
        int ix = Arrays.binarySearch(this.d_resultTris, t.id - 1);
        return ix < 0 ? -1 : ix;
    }

    public Triangle findTriangle(Point2d p) {
        if (this.d_tris.isEmpty()) {
            return null;
        }
        Handle find = new Handle(this.d_tris.get(0), 0);
        this.findTriangle(p, this.d_outside.getNeighborA(), find);
        return find.tri;
    }

    public int find(Point2d p) {
        Triangle t = this.findTriangle(p);
        if (t == null) {
            return -1;
        }
        return t.id - 1;
    }

    public int findTriangle(Point2d p, Handle start, Handle result) {
        if (start == null) {
            while (this.SAMPLES * this.SAMPLES * this.SAMPLES < this.d_tris.size()) {
                ++this.SAMPLES;
            }
            double minDist = Double.MAX_VALUE;
            int best = 0;
            for (int i = 0; i < this.SAMPLES; ++i) {
                int idx = (int)(this.d_random.nextDouble() * (double)this.d_tris.size());
                Point2d test = this.d_tris.get((int)idx).v[0].pt;
                double dist = test.distance(p);
                if (!(dist < minDist)) continue;
                minDist = dist;
                best = idx;
            }
            start = new Handle(this.d_tris.get(best), 0);
            if (start.getA().pt.equals((Tuple2d)p)) {
                result.tri = start.tri;
                result.orient = start.orient;
                return 3;
            }
            if (start.getB().pt.equals((Tuple2d)p)) {
                start = start.getHandleB();
                result.tri = start.tri;
                result.orient = start.orient;
                return 3;
            }
        }
        Handle tri = start;
        if (GeomTests.orient2d(tri.getA().pt, tri.getB().pt, p) < 0.0) {
            tri = tri.getNeighborA();
        }
        do {
            Point2d a = tri.getA().pt;
            Point2d b = tri.getB().pt;
            Point2d c = tri.getC().pt;
            if (c.x == p.x && c.y == p.y) {
                tri = tri.getHandleC();
                result.tri = tri.tri;
                result.orient = tri.orient;
                return 3;
            }
            double orientB = GeomTests.orient2d(c, b, p);
            double orientC = GeomTests.orient2d(a, c, p);
            boolean moveToC = false;
            if (orientB > 0.0) {
                if (orientC > 0.0) {
                    double dot = (c.x - p.x) * (b.x - a.x) + (c.y - p.y) * (b.y - a.y);
                    if (dot > 0.0) {
                        moveToC = true;
                    }
                } else {
                    moveToC = false;
                }
            } else if (orientC > 0.0) {
                moveToC = true;
            } else {
                if (orientB == 0.0) {
                    Handle hb = tri.getHandleB();
                    result.tri = hb.tri;
                    result.orient = hb.orient;
                    return 2;
                }
                if (orientC == 0.0) {
                    Handle hc = tri.getHandleC();
                    result.tri = hc.tri;
                    result.orient = hc.orient;
                    return 2;
                }
                result.tri = tri.tri;
                result.orient = tri.orient;
                return 1;
            }
            tri = moveToC ? tri.getNeighborC() : tri.getNeighborB();
        } while (tri.tri != this.d_outside.tri);
        return 4;
    }

    public Triangle getOutputTriangle(int ix) {
        this.updateOutputTris();
        return this.d_tris.get(this.d_resultTris[ix]);
    }

    private void updateOutputTris() {
        if (this.d_resultTris != null) {
            return;
        }
        int[] result = new int[this.d_tris.size()];
        int count = 0;
        for (int m = 0; m < this.d_tris.size(); ++m) {
            Triangle tri = this.d_tris.get(m);
            if (tri.color == 0) continue;
            result[count++] = m;
        }
        this.d_resultTris = Arrays.copyOfRange(result, 0, count);
    }

    public TriangulatorInfo getOutput() {
        return this.getOutput(0);
    }

    public TriangulatorInfo getOutput(int options) {
        TriangulatorInfo ti = new TriangulatorInfo();
        this.updateOutputTris();
        Point2d[] usedPoints = new Point2d[this.d_verts.size()];
        for (int triix : this.d_resultTris) {
            Triangle tri = this.d_tris.get(triix);
            for (int m = 0; m < 3; ++m) {
                Vertex vert = tri.v[m];
                usedPoints[vert.id - 1] = vert.pt;
            }
        }
        int numUsed = 0;
        for (Point2d p : usedPoints) {
            if (p == null) continue;
            ++numUsed;
        }
        int pix = 0;
        ti.points = new Point2d[numUsed];
        int[] pLookup = new int[usedPoints.length];
        for (int i = 0; i < usedPoints.length; ++i) {
            int newix;
            Point2d p;
            p = usedPoints[i];
            if (p == null) continue;
            pLookup[i] = newix = pix++;
            ti.points[newix] = p;
        }
        ToIntFunction<Vertex> vIxLookup = v -> pLookup[v.id - 1];
        boolean includeColors = (options & 2) != 0;
        ti.triangles = new int[this.d_resultTris.length * 3];
        ti.colors = includeColors ? new int[this.d_resultTris.length] : null;
        int ix = 0;
        for (Object triix : (Vertex)this.d_resultTris) {
            Triangle tri = this.d_tris.get((int)triix);
            if (includeColors) {
                ti.colors[ix / 3] = tri.color2;
            }
            for (int m = 0; m < 3; ++m) {
                ti.triangles[ix++] = vIxLookup.applyAsInt(tri.v[m]);
            }
        }
        if ((options & 1) != 0) {
            ti.adjTris = new int[this.d_resultTris.length * 3];
            int adjix = 0;
            for (int m = 0; m < this.d_resultTris.length; ++m) {
                int triix = this.d_resultTris[m];
                Triangle tri = this.d_tris.get(triix);
                for (int n = 0; n < 3; ++n) {
                    Triangle adjTri;
                    Handle adjHandle = tri.tri[n];
                    Triangle triangle = adjTri = adjHandle != null ? adjHandle.tri : null;
                    if (adjTri == null || adjTri.color == 0) {
                        ti.adjTris[adjix++] = -1;
                        continue;
                    }
                    int adjTriIx = Arrays.binarySearch(this.d_resultTris, adjTri.id - 1);
                    assert (adjTriIx >= 0);
                    ti.adjTris[adjix++] = adjTriIx;
                }
            }
        }
        if ((options & 4) != 0) {
            LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
            for (int triix : this.d_resultTris) {
                Triangle tri = this.d_tris.get(triix);
                for (int m = 0; m < 3; ++m) {
                    if (!tri.isConstrained(m)) continue;
                    int id = tri.edgeIds[m];
                    Vertex v1 = tri.v[m];
                    Vertex v2 = tri.v[Handle.plus1mod3[m]];
                    Edge e = new Edge(vIxLookup.applyAsInt(v1), vIxLookup.applyAsInt(v2), id);
                    edges.add(e);
                }
            }
            ti.edges = new int[edges.size() * 2];
            ti.edgeIds = new int[edges.size()];
            int eix = 0;
            int eidix = 0;
            for (Edge e : edges) {
                ti.edges[eix++] = e.v1;
                ti.edges[eix++] = e.v2;
                ti.edgeIds[eidix++] = e.id;
            }
        }
        return ti;
    }

    public void writeMesh() {
        int tricount = 0;
        for (Triangle tri : this.d_tris) {
            if (tri.color < 1) continue;
            ++tricount;
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("triangle.data")));
            out.println(this.d_verts.size());
            for (Vertex v : this.d_verts) {
                out.println(v.pt.x + ", " + v.pt.y);
            }
            out.println(tricount);
            for (Triangle tri : this.d_tris) {
                if (tri.color < 1) continue;
                short color = tri.color;
                if (tri.isConstrained(0) || tri.isConstrained(1) || tri.isConstrained(2)) {
                    color = 1;
                }
                out.println(tri.v[0].id - 1 + " " + (tri.v[1].id - 1) + " " + (tri.v[2].id - 1) + " " + color);
            }
            out.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    public boolean checkDelaunay() {
        int count = 0;
        int fixed = 0;
        for (Triangle tri : this.d_tris) {
            Point2d d;
            Handle h = new Handle(tri, 0);
            Point2d a = h.getA().pt;
            Point2d b = h.getB().pt;
            Point2d c = h.getC().pt;
            Handle nbr = h.getNeighborA();
            if (nbr.isConstrained()) {
                ++fixed;
            }
            if (nbr.tri != this.d_outside.tri && !nbr.isConstrained() && GeomTests.inCircle(a, b, c, d = nbr.getC().pt) > 0.0) {
                ++count;
                LOGGER.log(Level.FINER, "non D: " + h.getA().id + " " + h.getB().id);
                LOGGER.log(Level.FINER, "" + GeomTests.inCircle(a, b, c, d));
            }
            if ((nbr = h.getNeighborB()).isConstrained()) {
                ++fixed;
            }
            if (nbr.tri != this.d_outside.tri && !nbr.isConstrained() && GeomTests.inCircle(a, b, c, d = nbr.getC().pt) > 0.0) {
                ++count;
                LOGGER.log(Level.FINER, "non D: " + h.getB().id + " " + h.getC().id);
                LOGGER.log(Level.FINER, "" + GeomTests.inCircle(a, b, c, d));
            }
            if ((nbr = h.getNeighborC()).isConstrained()) {
                ++fixed;
            }
            if (nbr.tri != this.d_outside.tri && !nbr.isConstrained() && GeomTests.inCircle(a, b, c, d = nbr.getC().pt) > 0.0) {
                ++count;
                LOGGER.log(Level.FINER, "non D: " + h.getC().id + " " + h.getA().id);
                LOGGER.log(Level.FINER, "" + GeomTests.inCircle(a, b, c, d));
            }
            if (!(GeomTests.orient2d(a, b, c) <= 0.0) && !(GeomTests.orient2d(b, c, a) <= 0.0) && !(GeomTests.orient2d(c, a, b) <= 0.0)) continue;
            LOGGER.log(Level.WARNING, "***** NEGATIVE AREA TRIANGLE ****");
        }
        if (count > 0) {
            LOGGER.log(Level.FINE, "non-Delaunay: ");
        }
        LOGGER.log(Level.FINE, "Constraints: " + fixed / 2);
        return count == 0;
    }

    public static boolean sameHandle(Handle t1, Handle t2) {
        return t1.tri == t2.tri && t1.orient == t2.orient;
    }

    private static class QEdge {
        public Handle tri;
        public Vertex a;
        public Vertex b;

        public QEdge(Handle t, Vertex v1, Vertex v2) {
            this.tri = t;
            this.a = v1;
            this.b = v2;
        }
    }

    private static class QTri
    implements Comparable {
        public Triangle tri;
        public Vertex a;
        public Vertex b;
        public Vertex c;
        public double key;

        public QTri(Triangle t, Vertex v1, Vertex v2, Vertex v3, double k) {
            this.tri = t;
            this.a = v1;
            this.b = v2;
            this.c = v3;
            this.key = k;
        }

        public int compareTo(Object o) {
            double diff = this.key - ((QTri)o).key;
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }
    }

    public static class Handle {
        static final int[] plus1mod3 = new int[]{1, 2, 0};
        static final int[] plus2mod3 = new int[]{2, 0, 1};
        public Triangle tri;
        public int orient;

        public Handle() {
            this(null, 0);
        }

        public Handle(Triangle t, int o) {
            this.tri = t;
            this.orient = o;
        }

        public Handle(Handle h) {
            this.tri = h.tri;
            this.orient = h.orient;
        }

        public Vertex getA() {
            return this.tri.v[this.orient];
        }

        public Vertex getB() {
            return this.tri.v[plus1mod3[this.orient]];
        }

        public Vertex getC() {
            return this.tri.v[plus2mod3[this.orient]];
        }

        public void setA(Vertex v) {
            this.tri.v[this.orient] = v;
        }

        public void setB(Vertex v) {
            this.tri.v[Handle.plus1mod3[this.orient]] = v;
        }

        public void setC(Vertex v) {
            this.tri.v[Handle.plus2mod3[this.orient]] = v;
        }

        public Handle getNeighborA() {
            return this.tri.tri[this.orient];
        }

        public Handle getNeighborB() {
            return this.tri.tri[plus1mod3[this.orient]];
        }

        public Handle getNeighborC() {
            return this.tri.tri[plus2mod3[this.orient]];
        }

        public void setNeighborA(Handle nbr) {
            this.tri.tri[this.orient] = new Handle(nbr);
        }

        public void setNeighborB(Handle nbr) {
            this.tri.tri[Handle.plus1mod3[this.orient]] = new Handle(nbr);
        }

        public void setNeighborC(Handle nbr) {
            this.tri.tri[Handle.plus2mod3[this.orient]] = new Handle(nbr);
        }

        public Handle getHandleB() {
            return new Handle(this.tri, plus1mod3[this.orient]);
        }

        public Handle getHandleC() {
            return new Handle(this.tri, plus2mod3[this.orient]);
        }

        public void setEdgeId(int edgeId) {
            this.tri.edgeIds[this.orient] = edgeId;
        }

        public int getEdgeId() {
            return this.tri.edgeIds[this.orient];
        }

        public void setUnconstrained() {
            this.tri.edgeIds[this.orient] = 0;
        }

        public boolean isConstrained() {
            return this.getEdgeId() != 0;
        }
    }

    public static class Edge {
        public int v1;
        public int v2;
        public final int id;

        public Edge(int start, int end, int id) {
            this.v1 = start;
            this.v2 = end;
            this.id = id;
        }

        public int hashCode() {
            return 0x23498F ^ this.v1 + this.v2 + this.id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Edge)) {
                return false;
            }
            Edge e = (Edge)obj;
            return this.id == e.id && (this.v1 == e.v1 && this.v2 == e.v2 || this.v1 == e.v2 && this.v2 == e.v1);
        }

        public String toString() {
            return "[Edge: " + (this.v1 - 1) + " -> " + (this.v2 - 1) + "]";
        }
    }

    public static class Triangle {
        public int id = -1;
        public Vertex[] v = new Vertex[3];
        public Handle[] tri = new Handle[3];
        public int[] edgeIds = new int[3];
        public short color = (short)-1;
        public int color2 = -1;

        public Triangle(Vertex a, Vertex b, Vertex c) {
            this.v[0] = a;
            this.v[1] = b;
            this.v[2] = c;
            Arrays.fill(this.edgeIds, 0);
        }

        public Point2d centroid() {
            return Mesh.centroid(this.v[0].pt, this.v[1].pt, this.v[2].pt);
        }

        public boolean isConstrained(int edge) {
            return this.edgeIds[edge] != 0;
        }
    }

    public static class Vertex {
        public int id = -1;
        public Point2d pt;
        public double maxArea;

        public Vertex(double x, double y) {
            this(x, y, Double.MAX_VALUE);
        }

        public Vertex(double x, double y, double maxArea) {
            this.pt = new Point2d(x, y);
            this.maxArea = maxArea;
        }

        public String toString() {
            return this.pt.toString();
        }
    }
}

