/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.out;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Matrix4d;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.io.DataOutputProxy;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.scene3d.GeomWriter;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.LinkedIdentityHashMap;

public class TeciGeomWriter {
    private static final Logger LOGGER = Logger.getLogger(TeciGeomWriter.class.getName());

    public static void writeVis(File f, Options options, Collection<? extends IObject> displays, Collection<? extends BGImage> bgImages) throws IOException {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
            out.writeInt(Version.curr().value());
            TeciGeomWriter.writeBGImages(f, out, bgImages);
            TeciGeomWriter.writeGeom(f, out, options, displays);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    public static String writeImage(File outDir, String imgName, IImage img) {
        File imageFile = new File(img.getFilename());
        String imageName = imageFile.getName();
        File outputImageFile = new File(outDir, imageName);
        int saveOptions = 1;
        if (!outputImageFile.exists()) {
            LOGGER.log(Level.INFO, String.format("Saving image %s...", imageName));
            img.save(outputImageFile.getAbsolutePath(), saveOptions);
            LOGGER.log(Level.INFO, "Done");
        } else if (TeciGeomWriter.getWriteAlternateImage(img, outputImageFile)) {
            String imageNameAlt = String.format("%d-%dx%d.png", imgName.hashCode(), img.getWidth(), img.getHeight());
            outputImageFile = new File(outDir, imageNameAlt);
            LOGGER.log(Level.INFO, String.format("A file called \"%s\" already exists! Using alternate name \"%s\"%n", imageName, imageNameAlt));
            img.save(outputImageFile.getPath(), saveOptions);
            imageName = imageNameAlt;
        }
        return imageName;
    }

    private static boolean getWriteAlternateImage(IImage img, File outputImageFile) {
        String outPath = outputImageFile.getPath();
        IStreamSrc src = FileSystem.INSTANCE.getStreamSrc(outPath, 3);
        try {
            Image existing = Image.load(outPath, src);
            if (new HashableImage(existing).equals(existing)) {
                LOGGER.log(Level.INFO, String.format("Image \"%s\" already exists and is equal. Write skipped.%n", outputImageFile.getName()));
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
        return true;
    }

    private static void writeBGImages(File file, DataOutputStream fWrite, Collection<? extends BGImage> bgimages) throws IOException {
        File outputDir = file.getParentFile();
        fWrite.writeInt(bgimages.size());
        for (BGImage bGImage : bgimages) {
            String imageName = TeciGeomWriter.writeImage(outputDir, bGImage.getName(), bGImage.getImage());
            Matrix4d iwXform = bGImage.getLWXform();
            TeciGeomWriter.writeString(fWrite, imageName);
            fWrite.writeFloat(bGImage.getOpacity());
            for (int m = 0; m < 4; ++m) {
                for (int n = 0; n < 4; ++n) {
                    fWrite.writeFloat((float)iwXform.getElement(m, n));
                }
            }
        }
    }

    private static void writeGeom(File outFile, DataOutputStream output, Options options, Collection<? extends IObject> objects) throws IOException {
        output.writeInt(GeomWriter.CURR_VERSION);
        LinkedIdentityHashMap<IMaterial, Integer> matIds = new LinkedIdentityHashMap<IMaterial, Integer>();
        IdentityHashMap<IObject, DisplayGeom> geoms = new IdentityHashMap<IObject, DisplayGeom>();
        for (IObject iObject : objects) {
            DisplayGeom obj = geoms.computeIfAbsent(iObject, IObject::getDisplay);
            IGeomNode geom = obj.node;
            IPropsSrc iPropsSrc = obj.props;
            int numPrims = geom.getNumPrims(7);
            for (int m = 0; m < numPrims; ++m) {
                Integer id;
                IPrimProps pprops = iPropsSrc.get(m);
                IMaterial mat = pprops.getMaterial();
                if (mat == null || (id = (Integer)matIds.get(mat)) != null) continue;
                id = matIds.size();
                matIds.put(mat, id);
            }
        }
        File outDir = outFile.getParentFile();
        output.flush();
        MatlWriter matlWriter = new MatlWriter(output, outDir);
        matlWriter.writeInt(matIds.size());
        for (IMaterial mat : matIds.keySet()) {
            GeomWriter.write((ObjectOutput)matlWriter, mat);
        }
        matlWriter.flush();
        output.flush();
        MatlRefWriter objOutput = new MatlRefWriter(output, matIds);
        objOutput.writeInt(geoms.size());
        for (IObject iObject : objects) {
            DisplayGeom geom = geoms.computeIfAbsent(iObject, IObject::getDisplay);
            objOutput.writeInt(iObject.getType().ordinal());
            TeciGeomWriter.writeString(objOutput, iObject.getName());
            Collection<Integer> fdsIds = iObject.getFDSRepIds();
            objOutput.writeInt(fdsIds.size());
            for (int i : fdsIds) {
                objOutput.writeInt(i);
            }
            GeomWriter.write(objOutput, geom.node, geom.props, options.displayEdgeError, options.displayFaceError);
        }
        objOutput.flush();
    }

    private static void writeColor(DataOutput out, Color c) throws IOException {
        out.writeByte(c.getRed());
        out.writeByte(c.getGreen());
        out.writeByte(c.getBlue());
        out.writeByte(c.getAlpha());
    }

    private static void writeString(DataOutput out, String s) throws IOException {
        IOUtil.writeUTF8(out, s);
    }

    private static class MatlRefWriter
    extends ObjectWriter {
        private final Map<IMaterial, Integer> d_matIds;

        public MatlRefWriter(DataOutput out, Map<IMaterial, Integer> matIds) {
            super(out);
            this.d_matIds = matIds;
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            if (obj == null) {
                this.writeInt(-1);
            } else {
                assert (obj instanceof IMaterial);
                IMaterial mat = (IMaterial)obj;
                Integer id = this.d_matIds.get(mat);
                assert (id != null);
                this.writeInt(id);
            }
        }
    }

    private static class MatlWriter
    extends ObjectWriter {
        private final File d_outDir;

        public MatlWriter(DataOutput out, File outDir) {
            super(out);
            this.d_outDir = outDir;
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            this.writeBoolean(obj != null);
            if (obj == null) {
                return;
            }
            if (obj instanceof IMatAttrs) {
                GeomWriter.write((ObjectOutput)this, (IMatAttrs)obj);
            } else if (obj instanceof Texture) {
                GeomWriter.write((ObjectOutput)this, (Texture)obj);
            } else if (obj instanceof IImage) {
                IImage image = (IImage)obj;
                String name = new File(image.getFilename()).getName();
                String imageLoc = TeciGeomWriter.writeImage(this.d_outDir, name, image);
                TeciGeomWriter.writeString(this.getOutput(), imageLoc);
            } else assert (false);
        }
    }

    private static abstract class ObjectWriter
    extends DataOutputProxy
    implements ObjectOutput {
        public ObjectWriter(DataOutput out) {
            super(out);
        }

        @Override
        public void flush() throws IOException {
            if (this.getOutput() instanceof Flushable) {
                ((Flushable)((Object)this.getOutput())).flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.getOutput() instanceof Closeable) {
                ((Closeable)((Object)this.getOutput())).close();
            }
        }
    }

    public static class DefaultObj
    implements IObject {
        public final DisplayGeom geom;
        public final Type type;
        public final Collection<Integer> fdsRepIds;
        public final String name;

        public DefaultObj(Type type, String name, DisplayGeom geom, Collection<Integer> fdsRepIds) {
            this.geom = geom;
            this.type = type;
            this.fdsRepIds = fdsRepIds;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DisplayGeom getDisplay() {
            return this.geom;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Collection<Integer> getFDSRepIds() {
            return this.fdsRepIds;
        }
    }

    public static interface IObject {
        public Type getType();

        public String getName();

        public DisplayGeom getDisplay();

        public Collection<Integer> getFDSRepIds();
    }

    public static enum Type {
        FDS_OBST(true),
        FDS_VENT(true),
        FDS_MESH(true),
        GENERIC(false);

        public final boolean fds;

        private Type(boolean fds) {
            this.fds = fds;
        }
    }

    public static interface BGImage {
        public Matrix4d getLWXform();

        public float getOpacity();

        public String getName();

        public IImage getImage();
    }

    public static class Options {
        public final double displayEdgeError;
        public final double displayFaceError;

        public Options(double dISPLAY_EDGE_ERROR, double dISPLAY_FACE_ERROR) {
            this.displayEdgeError = dISPLAY_EDGE_ERROR;
            this.displayFaceError = dISPLAY_FACE_ERROR;
        }
    }

    public static enum Version {
        V0001,
        V0002,
        V0003,
        V0004;


        static Version curr() {
            return Version.values()[Version.values().length - 1];
        }

        public int value() {
            return this.ordinal() + 1;
        }
    }
}

