/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import thunderheadeng.cad.in.CadImporter;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.ImportConst;
import thunderheadeng.cad.in.UnitPanel;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class UnitsPnl
extends guiPanel
implements IEditor<IPropertySet> {
    public static final IPropertySet.Prop<Supplier<AABox>> BOUNDS = new IPropertySet.Prop<Supplier<AABox>>("BoundsPnl.BOUNDS", () -> new AABox());
    public static final IPropertySet.Prop<Boolean> DEFER_BOUNDS = new IPropertySet.Prop<Boolean>("BoundsPnl.DEFER_BOUNDS", true);
    public static final List<IPropertySet.Prop<?>> PROPS = Arrays.asList(BOUNDS, DEFER_BOUNDS, IGeomImportSession.SRC_LENGTH_UNIT);
    private final UnitPanel d_unitPnl;

    public UnitsPnl(IUnitSrc lengthUnitDisplay, boolean wizardStyle) {
        this.d_unitPnl = new UnitPanel(wizardStyle, lengthUnitDisplay, ImportConst.UNITS_VALUE.values());
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_unitPnl, new double[]{1.0, 1.0}, new int[]{0, 0});
        gb.finalizeRows();
    }

    public static void initProps(IPropertySet props, String fn, CadImporter importer) {
        boolean deferBounds = false;
        if (importer.isBoundsSlow()) {
            long sizeCutoff = 0x500000L;
            long size = new File(fn).length();
            deferBounds = size > sizeCutoff;
        }
        Supplier<AABox> boundsCalc = () -> {
            System.out.println("Calculating bounding box...");
            theTimer timer = new theTimer();
            AABox bb = importer.getModelBounds();
            System.out.printf("Done (%g s)%n", timer.curr());
            return bb;
        };
        boundsCalc = theUtil.cached(boundsCalc);
        props.setIfNotDefault(DEFER_BOUNDS, deferBounds);
        props.set(BOUNDS, boundsCalc);
        props.setIfNotDefault(IGeomImportSession.SRC_LENGTH_UNIT, ImportConst.UNITS_VALUE.get(importer.getLengthUnit()));
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(IPropertySet data) {
        this.d_unitPnl.load(data.get(DEFER_BOUNDS), data.get(BOUNDS));
        this.d_unitPnl.setUnit(data.get(IGeomImportSession.SRC_LENGTH_UNIT));
    }

    @Override
    public IPropertySet commit(IPropertySet data) {
        data.setIfNotDefault(IGeomImportSession.SRC_LENGTH_UNIT, this.d_unitPnl.getUnit());
        return data;
    }
}

