/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLLabel;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Global;
import thunderheadeng.util.theUtil;

public class UnitPanel
extends guiPanel {
    private static final Unit CUSTOM_UNIT = Unit.ONE.alternate(Intl.intl("Custom"));
    private final guiComboBox<Unit> d_unitsCB;
    private final guiLabel d_widthLbl;
    private final guiLabel d_heightLbl;
    private final guiLabel d_depthLbl;
    private final ValueField<UnitDouble> d_customUnitFld;
    private final HTMLLabel d_calcBoundsLbl;
    private boolean d_boundsCalculated;
    private AABox d_modelBounds;
    private final IUnitSrc d_displayLengthUnit;
    private Unit d_defUnit;
    private final guiPanel d_boundsPnl;

    public UnitPanel(boolean wizardStyle, IUnitSrc lengthUnit, Collection<? extends Unit> units) {
        super(new GridBagLayout());
        this.d_displayLengthUnit = lengthUnit;
        this.d_boundsCalculated = false;
        this.d_modelBounds = new AABox();
        ArrayList<? extends Unit> unitsList = new ArrayList<Unit>(units);
        unitsList.add((Unit)CUSTOM_UNIT);
        this.d_customUnitFld = ValueFields.udFld(1.0, DoubleVR.above(0.0, false), (Unit)SI.METER, lengthUnit);
        final guiLabel customLbl = new guiLabel(Intl.intl("1 model unit = "));
        this.d_widthLbl = new guiLabel();
        this.d_heightLbl = new guiLabel();
        this.d_depthLbl = new guiLabel();
        this.d_calcBoundsLbl = new HTMLLabel("<a href='calc'>" + Intl.intl("Calculate") + "</a>");
        this.d_calcBoundsLbl.setOpenLinksAsWebpages(false);
        this.d_calcBoundsLbl.setToolTipText(Intl.intl("[May be a long operation] This is useful for determining the length unit if <unknown>."));
        this.d_unitsCB = new guiComboBox<Unit>((Collection<? extends Unit>)unitsList);
        this.d_unitsCB.setRenderer(new DefaultListCellRenderer(){
            final Font plain = this.getFont();
            final Font bold = this.getFont().deriveFont(1);

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text;
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Unit unit = (Unit)value;
                Font font = this.plain;
                if (unit != null) {
                    text = unit.toString();
                    if (theUtil.equal(UnitPanel.this.d_defUnit, unit)) {
                        font = this.bold;
                    }
                } else {
                    text = Intl.intl("<unknown>");
                }
                this.setText(text);
                this.setFont(font);
                return this;
            }
        });
        this.d_unitsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean visible = e.getStateChange() == 1 && e.getItem() == CUSTOM_UNIT;
                customLbl.setVisible(visible);
                UnitPanel.this.d_customUnitFld.setVisible(visible);
                UnitPanel.this.updateBoundsLbl(UnitPanel.this.d_boundsCalculated, UnitPanel.this.d_modelBounds);
                if (visible) {
                    UnitPanel.this.repack();
                }
            }
        });
        this.d_customUnitFld.addValueChangeListener(e -> this.updateBoundsLbl(this.d_boundsCalculated, this.d_modelBounds));
        this.d_boundsPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(this.d_boundsPnl);
        gb.addRow(Intl.intl("[Model Bounds Preview]"));
        gb.indent();
        gb.addRow(this.d_calcBoundsLbl, 0);
        gb.addRow(this.d_widthLbl, 0);
        gb.addRow(this.d_depthLbl, 0);
        gb.addRow(this.d_heightLbl, 0);
        gb.unindent();
        gb.finalizeRows();
        gb = new GridBagHelper(this);
        String lengthLbl = wizardStyle ? Intl.intl("What is the file's length unit?") : Intl.intl("Length Unit:");
        gb.addRow(lengthLbl, 0);
        gb.addIdentRow(this.d_unitsCB, customLbl, this.d_customUnitFld, 1.0, 0);
        gb.addFilledRow(this.d_boundsPnl);
        gb.finalizeRows();
        this.setCustomVisible(false, customLbl, this.d_customUnitFld);
    }

    public void load(AABox modelBounds) {
        this.load(false, () -> modelBounds);
    }

    public void load(boolean deferBoundsCalc, final Supplier<AABox> boundsCalc) {
        if (deferBoundsCalc) {
            final HTMLLabel calcBoundsLbl = this.d_calcBoundsLbl;
            calcBoundsLbl.setVisible(true);
            calcBoundsLbl.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    UnitPanel.this.beginWaitCursor();
                    UnitPanel.this.d_modelBounds = (AABox)boundsCalc.get();
                    UnitPanel.this.d_boundsCalculated = true;
                    UnitPanel.this.endWaitCursor();
                    UnitPanel.this.updateBoundsLbl(UnitPanel.this.d_boundsCalculated, UnitPanel.this.d_modelBounds);
                    calcBoundsLbl.setVisible(false);
                    UnitPanel.this.d_widthLbl.setVisible(true);
                    UnitPanel.this.d_depthLbl.setVisible(true);
                    UnitPanel.this.d_heightLbl.setVisible(true);
                    UnitPanel.this.repack();
                }
            });
            this.d_widthLbl.setVisible(false);
            this.d_depthLbl.setVisible(false);
            this.d_heightLbl.setVisible(false);
        } else {
            this.d_calcBoundsLbl.setVisible(false);
            this.d_modelBounds = boundsCalc.get();
            this.d_boundsCalculated = true;
        }
        this.updateBoundsLbl(this.d_boundsCalculated, this.d_modelBounds);
    }

    private void repack() {
        Window parent = SwingUtilities.getWindowAncestor(this);
        if (parent != null) {
            parent.pack();
        }
    }

    private void setCustomVisible(boolean visible, Component ... comps) {
        for (Component comp : comps) {
            comp.setVisible(visible);
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_unitsCB.getSelectedItem() == null) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(SwingUtilities.getWindowAncestor(this), Intl.intl("Select a unit from the list."));
            }
            return false;
        }
        return true;
    }

    public void setUnit(Unit unit) {
        this.d_defUnit = unit;
        this.d_unitsCB.setSelectedItem(unit);
        this.updateBoundsLbl(this.d_boundsCalculated, this.d_modelBounds);
    }

    public Unit getUnit() {
        return this.getSourceLengthUnit();
    }

    private static String toString(double v, Unit srcUnit, Unit dstUnit) {
        return Global.format(UnitDouble.convert(v, srcUnit, dstUnit)) + " " + dstUnit.toString();
    }

    private void updateBoundsLbl(boolean boundsCalculated, AABox bounds) {
        String xstr;
        String ystr;
        String zstr;
        if (bounds == null) {
            return;
        }
        if (boundsCalculated && !bounds.isValid()) {
            this.d_boundsPnl.setVisible(false);
            return;
        }
        this.d_boundsPnl.setVisible(true);
        Unit srcUnit = this.getSourceLengthUnit();
        Unit dstUnit = this.d_displayLengthUnit.getUnit();
        if (srcUnit == null) {
            ystr = zstr = "? " + dstUnit.toString();
            xstr = zstr;
        } else {
            Point3d min = bounds.getMin();
            Point3d max = bounds.getMax();
            xstr = UnitPanel.toString(max.x - min.x, srcUnit, dstUnit);
            ystr = UnitPanel.toString(max.y - min.y, srcUnit, dstUnit);
            zstr = UnitPanel.toString(max.z - min.z, srcUnit, dstUnit);
        }
        this.d_widthLbl.setText(String.format(Intl.intl("Model Width:  %s"), xstr));
        this.d_depthLbl.setText(String.format(Intl.intl("Model Depth:  %s"), ystr));
        this.d_heightLbl.setText(String.format(Intl.intl("Model Height: %s"), zstr));
        this.repack();
    }

    private Unit getSourceLengthUnit() {
        Unit selUnit = this.d_unitsCB.getSelectedItem();
        if (selUnit != CUSTOM_UNIT) {
            return selUnit;
        }
        if (!this.d_customUnitFld.validateData(false, false)) {
            return null;
        }
        UnitDouble mult = (UnitDouble)this.d_customUnitFld.getValue();
        return mult.getUnit().multiply(mult.getValueNoUnit()).alias(Intl.intl("Custom"));
    }
}

