/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import org.jscience.physics.units.NonSI;
import thunderheadeng.Intl;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IPropertySet;

public class OptionsPnl
extends guiPanel
implements IEditor<IPropertySet> {
    public static final List<IPropertySet.Prop<?>> PROPS = Arrays.asList(IGeomImportSession.AUTO_CORRECT_NORMALS, IGeomImportSession.IMPORT_NORMALS, IGeomImportSession.IMPORT_CREASES, IGeomImportSession.CREASE_ANGLE);
    private final guiCheckBox d_importCreases = new guiCheckBox(Intl.intl("Import creases"));
    private final guiCheckBox d_importNormals = new guiCheckBox(Intl.intl("Import normals"));
    private final ValueField<UnitDouble> d_creaseAngle;
    private final guiCheckBox d_autoCorrectNormals = new guiCheckBox(Intl.intl("Auto-correct inverted polygons"));

    public OptionsPnl() {
        this.d_autoCorrectNormals.setToolTipText("<html>" + Intl.intl("Automatically corrects the winding of polygon vertices. Toggle this<br>checkbox if some objects are too dark."));
        LinkStatus.link((AbstractButton)this.d_importNormals, this.d_autoCorrectNormals);
        this.d_creaseAngle = ValueFields.udFld(DoubleVR.above(0.0, true), NonSI.DEGREE_ANGLE);
        guiLabel creaseAngleLbl = new guiLabel(Intl.intl("Crease Angle:"));
        creaseAngleLbl.setToolTipText(Intl.intl("If no normals are present, this defines the angle between triangles at which a crease appears."));
        GridBagHelper gb = new GridBagHelper(this);
        gb.addTitle(Intl.intl("Lighting"));
        gb.indent();
        gb.addRow(this.d_autoCorrectNormals, 0);
        gb.addRow(creaseAngleLbl, this.d_creaseAngle, 0);
        gb.finalizeRows();
    }

    @Override
    public void init(IPropertySet dataObj) {
        this.d_autoCorrectNormals.setSelected(dataObj.get(IGeomImportSession.AUTO_CORRECT_NORMALS));
        this.d_importCreases.setSelected(dataObj.get(IGeomImportSession.IMPORT_CREASES));
        this.d_importNormals.setSelected(dataObj.get(IGeomImportSession.IMPORT_NORMALS));
        this.d_creaseAngle.setValue(dataObj.get(IGeomImportSession.CREASE_ANGLE));
    }

    @Override
    public IPropertySet commit(IPropertySet dataObj) {
        dataObj.set(IGeomImportSession.IMPORT_CREASES, this.d_importCreases.isSelected());
        dataObj.set(IGeomImportSession.IMPORT_NORMALS, this.d_importNormals.isSelected());
        dataObj.set(IGeomImportSession.AUTO_CORRECT_NORMALS, this.d_autoCorrectNormals.isSelected());
        dataObj.set(IGeomImportSession.CREASE_ANGLE, this.d_creaseAngle.getValue());
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

