/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import javax.vecmath.Vector3d;
import thunderheadeng.cad.bim.BIMCoveringType;
import thunderheadeng.cad.bim.BIMTransportType;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.util.theUtil;

public interface IImportSession {
    default public int findBIMType(String name) {
        if (theUtil.startsWithIgnoreCase(name, "Ifc")) {
            String buffer = name.substring(3);
            try {
                return BIMType.valueOf(buffer.toString()).ordinal();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return BIMType.UNKNOWN.ordinal();
    }

    default public int findBIMCoveringType(String name) {
        try {
            return BIMCoveringType.valueOf(name).ordinal();
        }
        catch (Throwable t) {
            return BIMCoveringType.UNKNOWN.ordinal();
        }
    }

    default public int findBIMTransportType(String name) {
        try {
            return BIMTransportType.valueOf(name).ordinal();
        }
        catch (Throwable t) {
            return BIMTransportType.UNKNOWN.ordinal();
        }
    }

    public void beginMaterial(int var1, String var2, boolean var3);

    public void setMatlChnlColor(int var1, int var2, int var3, int var4);

    public void setMatlChnlMap(int var1, double var2, int var4, int var5, String var6, String var7);

    public void setMatlChnlParams(int var1, double ... var2);

    public void endMaterial();

    public void pushModelTransform(double[] var1);

    public void popModelTransform();

    public long beginNode(String var1, NodeProps var2);

    public void endNode();

    public long beginGeom();

    public void endGeom();

    public void endSession();

    public void setCurrentColor(int var1, int var2, int var3, int var4);

    public void setCurrentMatl(int var1);

    public void insertReference(long var1);

    public void polygonOut(double[] var1, double[] var2, double[] var3);

    public void polylineOut(double[] var1);

    public void shellProc(int var1, double[] var2, int[] var3, double[] var4, String[] var5, int[] var6, int var7, double[] var8, int[] var9, int var10, boolean[] var11, int[] var12, int[] var13);

    public void meshProc(int var1, int var2, int var3, double[] var4, boolean[] var5);

    public boolean circleProc(double[] var1, double var2, double[] var4, double[] var5);

    public void metafileProc(double[] var1, double[] var2, double[] var3);

    public boolean circularArcProc(double[] var1, double var2, double[] var4, double[] var5, double var6, int var8, double[] var9);

    public boolean circularArcProc(double[] var1, double[] var2, double[] var3, int var4, double[] var5);

    public boolean ellipticalArcProc(double[] var1, double[] var2, double var3, double[] var5, double var6, double[] var8, double var9, double var11, double[] var13, int var14, double[] var15);

    public boolean plineProc(double var1, double[] var3, double[] var4, double[] var5, int[] var6, double var7, double[] var9, boolean var10, double[] var11, int var12, int var13);

    public boolean textProc(double[] var1, double[] var2, double[] var3, String var4, boolean var5, int var6, double[] var7);

    public static class NodeProps
    implements Cloneable {
        public String layer = "";
        public String nodeType = "";
        public boolean solid = false;
        public int bimType = BIMType.UNKNOWN.ordinal();
        public double doorWidth = Double.NaN;
        public double doorHeight = Double.NaN;
        public long doorOpening = -1L;
        public double doorDirX = 0.0;
        public double doorDirY = 0.0;
        public double doorDirZ = 0.0;
        public int coveringType = BIMCoveringType.UNKNOWN.ordinal();
        public int transportType = BIMTransportType.UNKNOWN.ordinal();

        public NodeProps clone() {
            try {
                return (NodeProps)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public BIMType getBIMType() {
            return (BIMType)NodeProps.getType((Enum[])BIMType.values(), (int)this.bimType, (Enum)BIMType.UNKNOWN);
        }

        public BIMCoveringType getBIMCoveringType() {
            return (BIMCoveringType)NodeProps.getType((Enum[])BIMCoveringType.values(), (int)this.coveringType, (Enum)BIMCoveringType.UNKNOWN);
        }

        public BIMTransportType getBIMTransportType() {
            return (BIMTransportType)NodeProps.getType((Enum[])BIMTransportType.values(), (int)this.transportType, (Enum)BIMTransportType.UNKNOWN);
        }

        private static <T extends Enum> T getType(T[] values, int ix, T defVal) {
            assert (ix >= 0 && ix < values.length);
            return ix >= 0 && ix < values.length ? values[ix] : defVal;
        }

        public Vector3d getDoorDir() {
            return new Vector3d(this.doorDirX, this.doorDirY, this.doorDirZ);
        }
    }

    public static enum FaceOrient {
        CCW,
        CW;

    }

    public static enum MeshElementMapping {
        NONE,
        ALL_SAME,
        PER_FACE,
        PER_INDEX;

    }

    public static enum MatlChannel {
        AMBIENT,
        DIFFUSE,
        NORMAL,
        BUMP,
        SPECULAR,
        REFLECTION,
        REFRACTION,
        TRANSPARENCY,
        ILLUMINATION;

    }
}

