/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.Color;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.Unit;
import thunderheadeng.cad.in.GeomImportHelper;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.IImportSession;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.IOUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.ColorPool;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.StringPool;
import thunderheadeng.util.theUtil;

public class GeomImportSession
implements IGeomImportSession {
    public static final IPropertySet.Prop<Boolean> COMBINE_NODES = new IPropertySet.Prop<Boolean>("GeomImportSession.COMBINE_NODES", false);
    private final IPropertySet d_importProps;
    private final boolean d_combineNodes;
    private final ICallback d_callback;
    private final Converter d_lengthUnitConverter;
    private final double d_lengthScale;
    private final IPointOptimizer d_pointPool;
    private final Map<Integer, Pair<Material, IMaterial>> d_materials;
    private final Map<IMatAttrs, IMaterial> d_uniqueMats;
    private final Deque<Material> d_matlStack;
    private final Deque<NodeBuilder> d_nodes;
    private final List<Object> d_idObjs;

    public GeomImportSession(ICallback callback, IPropertySet props) {
        double scale;
        this.d_importProps = props;
        this.d_combineNodes = props.get(COMBINE_NODES);
        this.d_callback = callback;
        this.d_pointPool = (IPointOptimizer)((Supplier)props.get(POINT_OPTIMIZER)).get();
        this.d_lengthUnitConverter = ((Unit)props.get(SRC_LENGTH_UNIT)).getConverterTo((Unit)props.get(DST_LENGTH_UNIT));
        this.d_materials = new LinkedHashMap<Integer, Pair<Material, IMaterial>>();
        this.d_uniqueMats = new HashMap<IMatAttrs, IMaterial>();
        this.d_matlStack = new ArrayDeque<Material>();
        this.d_idObjs = new ArrayList<Object>();
        this.d_nodes = new ArrayDeque<NodeBuilder>();
        this.d_lengthScale = scale = this.d_lengthUnitConverter.convert(1.0);
        ITransform rootXform = TransformUtil.scale(scale, scale, scale);
        this.beginNode("root", new IImportSession.NodeProps(), rootXform);
    }

    public ICallback getCallback() {
        return this.d_callback;
    }

    public IPointOptimizer getPointPool() {
        return this.d_pointPool;
    }

    public Converter getUnitConverter() {
        return this.d_lengthUnitConverter;
    }

    @Override
    public Collection<IMaterial> getMaterials() {
        return theUtil.map(this.d_materials.values(), p -> (IMaterial)p.v2);
    }

    public IMaterial getMaterial(int id) {
        Pair<Material, IMaterial> result = this.d_materials.get(id);
        return result != null ? (IMaterial)result.v2 : null;
    }

    protected Material currMaterial() {
        return this.d_matlStack.getLast();
    }

    @Override
    public void beginMaterial(int id, String name, boolean twoSided) {
        Material matl = new Material(id, name, twoSided);
        this.d_matlStack.addLast(matl);
    }

    private static boolean isSimLabMat(Material mat) {
        String prefix = "Material~";
        if (!mat.name.startsWith(prefix)) {
            return false;
        }
        try {
            Integer.parseInt(mat.name.substring(prefix.length()));
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    @Override
    public void endMaterial() {
        Material matl = this.d_matlStack.removeLast();
        IMaterial nmat = matl.finish(this.d_callback, this.d_importProps);
        if (nmat != null) {
            IMaterial existing;
            if (((Boolean)this.d_importProps.get(REPLACE_IDENTICAL_MATERIALS)).booleanValue() && (existing = this.d_uniqueMats.putIfAbsent(nmat.getAttributes(), nmat)) != null) {
                nmat = existing;
            }
            this.d_materials.put(matl.id, new Pair<Material, IMaterial>(matl, nmat));
        }
    }

    @Override
    public void setMatlChnlColor(int chnl, int r, int g, int b) {
        this.currMaterial().setMatlChnlColor(IImportSession.MatlChannel.values()[chnl], r, g, b);
    }

    @Override
    public void setMatlChnlMap(int chnl, double blendFactor, int uTiling, int vTiling, String filename, String uvSet) {
        this.currMaterial().setMatlChnlMap(IImportSession.MatlChannel.values()[chnl], blendFactor, uTiling, vTiling, filename, uvSet);
    }

    @Override
    public void setMatlChnlParams(int chnl, double ... params) {
        this.currMaterial().setMatlChnlParams(IImportSession.MatlChannel.values()[chnl], params);
    }

    @Override
    public void pushModelTransform(double[] matData) {
        Matrix4d mat = new Matrix4d(matData);
        ITransform xform = GeomConstants.IDENTITY4d.equals(mat) ? TransformUtil.IDENTITY : new MatrixXform(mat);
        this.currBuilder().pushModelTransform(xform);
    }

    @Override
    public void popModelTransform() {
        this.currBuilder().popModelTransform();
    }

    @Override
    public void setCurrentColor(int r, int g, int b, int a) {
        this.currGeom().setCurrentColor(ColorPool.get(new Color(r, g, b, a)));
    }

    @Override
    public void setCurrentMatl(int id) {
        this.currGeom().setCurrentMatl(id);
    }

    @Override
    public void polygonOut(double[] flatverts, double[] texuv, double[] normal) {
        this.currGeom().polygonOut(flatverts, texuv, normal);
    }

    @Override
    public void polylineOut(double[] flatverts) {
        this.currGeom().polylineOut(flatverts);
    }

    @Override
    public void shellProc(int faceOrient, double[] flatverts, int[] faceList, double[] uvs, String[] uvSetNames, int[] uvSets, int normalMapping, double[] flatNormals, int[] normalFaceList, int creaseMapping, boolean[] creases, int[] creaseFaceList, int[] materials) {
        this.currGeom().shellProc(IImportSession.FaceOrient.values()[faceOrient], flatverts, faceList, uvs, uvSetNames, uvSets, IImportSession.MeshElementMapping.values()[normalMapping], flatNormals, normalFaceList, IImportSession.MeshElementMapping.values()[creaseMapping], creases, creaseFaceList, materials);
    }

    @Override
    public void meshProc(int faceOrient, int rows, int cols, double[] flatverts, boolean[] creases) {
        this.currGeom().meshProc(IImportSession.FaceOrient.values()[faceOrient], rows, cols, flatverts, creases);
    }

    @Override
    public boolean circleProc(double[] center, double radius, double[] normal, double[] extrusion) {
        return this.currGeom().circleProc(center, radius, normal, extrusion);
    }

    @Override
    public void metafileProc(double[] origin, double[] u, double[] v) {
        this.currGeom().metafileProc(origin, u, v);
    }

    @Override
    public boolean circularArcProc(double[] center, double radius, double[] normal, double[] startVector, double sweepAngle, int arcType, double[] extrusion) {
        return this.currGeom().circularArcProc(center, radius, normal, startVector, sweepAngle, arcType, extrusion);
    }

    @Override
    public boolean circularArcProc(double[] firstPoint, double[] secondPoint, double[] thirdpoint, int arcType, double[] extrusion) {
        return this.currGeom().circularArcProc(firstPoint, secondPoint, thirdpoint, arcType, extrusion);
    }

    @Override
    public boolean ellipticalArcProc(double[] center, double[] majorAxis, double majorRadius, double[] minorAxis, double minorRadius, double[] normal, double startAngle, double endAngle, double[] endPointOverrides, int arcType, double[] extrusion) {
        return this.currGeom().ellipticalArcProc(center, majorAxis, majorRadius, minorAxis, minorRadius, normal, startAngle, endAngle, endPointOverrides, arcType, extrusion);
    }

    @Override
    public boolean plineProc(double elevation, double[] verts2d, double[] bulges, double[] widths, int[] segTypes, double thickness, double[] normal, boolean isClosed, double[] planeXform, int segStart, int numSegs) {
        return this.currGeom().plineProc(elevation, verts2d, bulges, widths, segTypes, thickness, normal, isClosed, planeXform, segStart, numSegs);
    }

    @Override
    public boolean textProc(double[] position, double[] direction, double[] upVector, String msg, boolean raw, int style, double[] extrusion) {
        return this.currGeom().textProc(position, direction, upVector, msg, raw, style, extrusion);
    }

    protected int newId(Placeholder type) {
        int id = this.d_idObjs.size();
        this.d_idObjs.add((Object)type);
        return id;
    }

    protected void commitId(int id, Object obj) {
        this.d_idObjs.set(id, obj);
    }

    @Override
    public Collection<IGeomImportSession.Node> finalizeGeom() {
        assert (!this.d_nodes.isEmpty());
        NodeBuilder root = this.d_nodes.pop();
        IGeomImportSession.Node rnode = root.toNode();
        if (rnode.dg == DisplayGeom.EMPTY) {
            if (rnode.transform.isIdentity()) {
                return rnode.children;
            }
            ArrayList<IGeomImportSession.Node> result = new ArrayList<IGeomImportSession.Node>(rnode.children.size());
            for (IGeomImportSession.Node child : rnode.children) {
                IGeomImportSession.Node newNode = new IGeomImportSession.Node(child.id, child.name, rnode.transform.concatenate(child.transform), child.props, child.dg, child.children);
                result.add(newNode);
            }
            return result;
        }
        return Collections.singleton(rnode);
    }

    @Override
    public long beginNode(String name, IImportSession.NodeProps props) {
        assert (!this.d_nodes.isEmpty());
        return this.beginNode(name, props, this.d_nodes.peek().currTransform());
    }

    private long beginNode(String name, IImportSession.NodeProps props, ITransform xform) {
        NodeBuilder builder = new NodeBuilder(this.newId(Placeholder.NODE), StringPool.get(name), props, xform);
        this.d_nodes.push(builder);
        return builder.nodeId;
    }

    @Override
    public void endNode() {
        NodeBuilder builder = this.d_nodes.pop();
        IGeomImportSession.Node node = builder.toNode();
        if (node.dg != DisplayGeom.EMPTY || !node.children.isEmpty()) {
            this.d_nodes.peek().addChild(node);
        }
        this.commitId(builder.nodeId, node);
    }

    protected NodeBuilder currBuilder() {
        return this.d_nodes.peek();
    }

    @Override
    public void insertReference(long id) {
        assert (id < (long)this.d_idObjs.size() && id >= 0L);
        Object ref = this.d_idObjs.get((int)id);
        assert (ref instanceof IGeomImportSession.Node || ref instanceof DisplayGeom);
        if (ref instanceof IGeomImportSession.Node) {
            IGeomImportSession.Node node = (IGeomImportSession.Node)ref;
            this.currBuilder().addNodeRef(node);
        } else if (ref instanceof DisplayGeom) {
            this.currBuilder().addGeomRef(id, (DisplayGeom)ref);
        }
    }

    @Override
    public long beginGeom() {
        return this.currBuilder().beginGeom();
    }

    @Override
    public void endGeom() {
        this.currBuilder().endGeom();
    }

    protected GeomImportHelper currGeom() {
        return this.currBuilder().currGeom();
    }

    @Override
    public void endSession() {
    }

    public static abstract class ACallback
    implements ICallback {
        private final List<File> d_libDirs;

        public ACallback(File ... libDirs) {
            this.d_libDirs = new ArrayList<File>(Arrays.asList(libDirs));
            if (libDirs.length > 0) {
                System.out.println("Searching for resources in:");
                for (File libDir : libDirs) {
                    System.out.println("\t" + libDir.getAbsolutePath());
                }
            }
        }

        public void addLibDir(File dir) {
            this.d_libDirs.add(dir);
        }

        @Override
        public File resolvePath(String path) {
            for (File dir : this.d_libDirs) {
                File result = IOUtil.resolvePath(path, dir, null);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }

    public static interface ICallback {
        public IMaterial createMaterial(Material var1, IMatAttrs var2);

        public File resolvePath(String var1);
    }

    public static class Material {
        public final int id;
        public final String name;
        public final boolean twoSided;
        public Color ambColor;
        public Texture ambTex;
        public Color diffColor;
        public Texture diffTex;
        public Texture normTex;
        public double normStrength;
        public Texture bumpTex;
        public double bumpIndirectBumpScale;
        public Color specColor;
        public Texture specTex;
        public double specGlossFactor;
        public Color reflColor;
        public Texture reflTex;
        public double reflReflectanceScale;
        public double reflReflectivity;
        public Texture refrTex;
        public double refrRefractionIndex;
        public Color transpColor;
        public Texture opacityTex;
        public double transpFactor;
        public double translucenceFactor;
        public double transmittanceScale;
        public Color emissionColor;
        public Texture emissionTex;
        public double luminance;

        public Material(int id, String name, boolean twoSided) {
            this.id = id;
            this.name = name;
            this.twoSided = twoSided;
            this.transpColor = Color.WHITE;
            this.transpFactor = 0.0;
        }

        public void setMatlChnlColor(IImportSession.MatlChannel chnl, int r, int g, int b) {
            Color c = new Color(r, g, b);
            switch (chnl) {
                case AMBIENT: {
                    this.ambColor = c;
                    break;
                }
                case DIFFUSE: {
                    this.diffColor = c;
                    break;
                }
                case SPECULAR: {
                    this.specColor = c;
                    break;
                }
                case ILLUMINATION: {
                    this.emissionColor = c;
                    break;
                }
                case TRANSPARENCY: {
                    this.transpColor = c;
                    break;
                }
                case REFLECTION: {
                    this.reflColor = c;
                }
            }
        }

        public void setMatlChnlMap(IImportSession.MatlChannel chnl, double blendFactor, int uTiling, int vTiling, String filename, String uvSet) {
            Texture tex = Material.toTex(blendFactor, uTiling, vTiling, filename, uvSet);
            switch (chnl) {
                case AMBIENT: {
                    this.ambTex = tex;
                    break;
                }
                case DIFFUSE: {
                    this.diffTex = tex;
                    break;
                }
                case BUMP: {
                    this.bumpTex = tex;
                    break;
                }
                case NORMAL: {
                    this.normTex = tex;
                    break;
                }
                case REFLECTION: {
                    this.reflTex = tex;
                    break;
                }
                case REFRACTION: {
                    this.refrTex = tex;
                    break;
                }
                case SPECULAR: {
                    this.specTex = tex;
                    break;
                }
                case TRANSPARENCY: {
                    this.opacityTex = tex;
                    break;
                }
                case ILLUMINATION: {
                    this.emissionTex = tex;
                }
            }
        }

        private static Texture toTex(double blendFactor, int uTiling, int vTiling, String filename, String uvSet) {
            return new Texture(filename, Material.toTiling(uTiling), Material.toTiling(vTiling), blendFactor, uvSet);
        }

        private static Tiling toTiling(int tiling) {
            switch (tiling) {
                case 1: {
                    return Tiling.TILE;
                }
                case 2: {
                    return Tiling.CROP;
                }
                case 3: {
                    return Tiling.CLAMP;
                }
                case 4: {
                    return Tiling.MIRROR;
                }
            }
            return Tiling.TILE;
        }

        public void setMatlChnlParams(IImportSession.MatlChannel chnl, double ... params) {
            switch (chnl) {
                case BUMP: {
                    this.bumpIndirectBumpScale = params[0];
                    break;
                }
                case NORMAL: {
                    this.normStrength = params[0];
                    break;
                }
                case TRANSPARENCY: {
                    this.transpFactor = params[0];
                    this.translucenceFactor = params[1];
                    this.transmittanceScale = params[2];
                    break;
                }
                case REFLECTION: {
                    this.reflReflectanceScale = params[0];
                    this.reflReflectivity = params[1];
                    break;
                }
                case REFRACTION: {
                    this.refrRefractionIndex = params[0];
                    break;
                }
                case SPECULAR: {
                    this.specGlossFactor = params[0];
                    break;
                }
                case ILLUMINATION: {
                    this.luminance = params[0];
                }
            }
        }

        public IMaterial finish(ICallback callback, IPropertySet props) {
            IMatAttrs attrs = this.toNativeMatl(callback, props);
            if (attrs == null) {
                return null;
            }
            return callback.createMaterial(this, attrs);
        }

        private IMatAttrs toNativeMatl(ICallback callback, IPropertySet iprops) {
            Color ocolor;
            Color dcolor = null;
            if (this.diffColor != null) {
                dcolor = this.diffColor;
            } else if (this.ambColor != null) {
                dcolor = this.ambColor;
            }
            thunderheadeng.scene3d.geom.Texture dtex = this.toNativeTex(callback, this.diffTex);
            if (dcolor == null) {
                dcolor = (Color)IMatAttrs.DIFFUSE_COLOR.defVal;
            }
            if (!iprops.get(IGeomImportSession.IGNORE_TRANSPARENCY_COLOR).booleanValue()) {
                float[] tcomps = new float[3];
                float tfactor = (float)this.transpFactor;
                this.transpColor.getColorComponents(tcomps);
                float tr = tcomps[0] * tfactor;
                float tg = tcomps[1] * tfactor;
                float tb = tcomps[2] * tfactor;
                float transparency = tr * 0.3f + tg * 0.59f + tb * 0.11f;
                float alpha = 1.0f - transparency;
                ocolor = new Color(1.0f - tr, 1.0f - tg, 1.0f - tb);
            } else {
                float alpha = 1.0f - (float)this.transpFactor;
                ocolor = new Color(alpha, alpha, alpha);
            }
            thunderheadeng.scene3d.geom.Texture stex = this.toNativeTex(callback, this.specTex);
            thunderheadeng.scene3d.geom.Texture atex = this.toNativeTex(callback, this.ambTex);
            thunderheadeng.scene3d.geom.Texture btex = this.toNativeTex(callback, this.bumpTex);
            thunderheadeng.scene3d.geom.Texture ntex = this.toNativeTex(callback, this.normTex);
            thunderheadeng.scene3d.geom.Texture otex = this.toNativeTex(callback, this.opacityTex);
            thunderheadeng.scene3d.geom.Texture etex = this.toNativeTex(callback, this.emissionTex);
            thunderheadeng.scene3d.geom.Texture rtex = this.toNativeTex(callback, this.reflTex);
            int options = 0;
            if (!this.twoSided) {
                options |= 2;
            }
            ArrayList<Object> attrs = new ArrayList<Object>();
            Material.addParam(attrs, MatAttrs.AMBIENT_COLOR, this.ambColor);
            Material.addParam(attrs, MatAttrs.AMBIENT_TEXTURE, atex);
            Material.addParam(attrs, MatAttrs.BUMP, btex);
            Material.addParam(attrs, MatAttrs.BUMP_SCALE, this.bumpIndirectBumpScale);
            Material.addParam(attrs, MatAttrs.DIFFUSE_COLOR, dcolor);
            Material.addParam(attrs, MatAttrs.DIFFUSE_TEXTURE, dtex);
            Material.addParam(attrs, MatAttrs.EMISSIVE_COLOR, this.emissionColor);
            Material.addParam(attrs, MatAttrs.EMISSIVE_TEXTURE, etex);
            Material.addParam(attrs, MatAttrs.NORMAL, ntex);
            Material.addParam(attrs, MatAttrs.OPACITY_COLOR, ocolor);
            Material.addParam(attrs, MatAttrs.OPACITY_TEXTURE, otex);
            Material.addParam(attrs, MatAttrs.REFLECTION_COLOR, this.reflColor);
            Material.addParam(attrs, MatAttrs.REFLECTION_TEXTURE, rtex);
            Material.addParam(attrs, MatAttrs.SPECULAR_COLOR, this.specColor);
            Material.addParam(attrs, MatAttrs.SPECULAR_TEXTURE, stex);
            Material.addParam(attrs, MatAttrs.SHININESS, this.specGlossFactor);
            Material.addParam(attrs, MatAttrs.OPTIONS, options);
            return new MatAttrs(attrs);
        }

        private static <T> void addParam(List<Object> props, IPropertySet.Prop<T> prop, T val) {
            if (val == null) {
                return;
            }
            props.add(prop);
            props.add(val);
        }

        private thunderheadeng.scene3d.geom.Texture toNativeTex(ICallback callback, Texture tex) {
            return tex == null ? null : tex.toNativeTex(callback);
        }

        public static class Texture {
            public final String filename;
            public final Tiling uTiling;
            public final Tiling vTiling;
            public final double blendFactor;
            public final String uvSet;

            public Texture(String filename, Tiling uTiling, Tiling vTiling, double blendFactor, String uvSet) {
                this.filename = filename;
                this.uTiling = uTiling;
                this.vTiling = vTiling;
                this.blendFactor = blendFactor;
                this.uvSet = uvSet;
            }

            public thunderheadeng.scene3d.geom.Texture toNativeTex(ICallback callback) {
                File file = callback.resolvePath(this.filename);
                if (file == null) {
                    System.err.println("Could not resolve image path for " + this.filename);
                    return null;
                }
                IImage img = ImageManager.getImage(file.getAbsolutePath());
                if (img == null) {
                    System.err.println("Could not get image for " + file.getAbsolutePath());
                    return null;
                }
                switch (this.uTiling) {
                    case CLAMP: {
                        return thunderheadeng.scene3d.geom.Texture.clampedToEdge(img, this.uvSet);
                    }
                    case CROP: {
                        return thunderheadeng.scene3d.geom.Texture.clampedToBorder(img, Color.BLACK, this.uvSet);
                    }
                }
                return thunderheadeng.scene3d.geom.Texture.repeated(img, this.uvSet);
            }
        }

        public static enum Tiling {
            TILE,
            CROP,
            CLAMP,
            MIRROR;

        }
    }

    private class NodeBuilder {
        public final int nodeId;
        public final String name;
        public final IImportSession.NodeProps props;
        private final ITransform d_transform;
        private final List<DisplayGeom> d_finishedGeoms;
        private final List<IGeomImportSession.Node> d_children;
        private final Deque<ITransform> d_xformStack;
        private int d_geomId;
        private GeomImportHelper d_geomBuilder;

        public NodeBuilder(int id, String name, IImportSession.NodeProps props, ITransform xform) {
            this.nodeId = id;
            this.name = name;
            this.props = props;
            this.d_transform = xform;
            this.d_finishedGeoms = new ArrayList<DisplayGeom>();
            this.d_children = new ArrayList<IGeomImportSession.Node>();
            this.d_xformStack = new ArrayDeque<ITransform>();
            this.d_xformStack.push(TransformUtil.IDENTITY);
            this.resetGeom();
        }

        private void resetGeom() {
            assert (this.d_geomBuilder == null);
            Supplier<ITransform> transformSrc = this::currTransform;
            IntFunction<Pair<Material, IMaterial>> matMap = i -> {
                Pair pair = (Pair)GeomImportSession.this.d_materials.get(i);
                if (pair == null) {
                    return new Pair<Object, Object>(null, null);
                }
                return pair;
            };
            this.d_geomBuilder = new GeomImportHelper(transformSrc, GeomImportSession.this.getPointPool(), this.props.solid, matMap, GeomImportSession.this.d_importProps);
        }

        private DisplayGeom commitGeom() {
            if (this.d_geomBuilder != null) {
                DisplayGeomBuilder.Rep rep = this.d_geomBuilder.finish();
                DisplayGeom dg = rep.toDisplay();
                if (dg != DisplayGeom.EMPTY) {
                    this.d_finishedGeoms.add(dg);
                }
                this.d_geomBuilder = null;
                return dg;
            }
            return DisplayGeom.EMPTY;
        }

        public int beginGeom() {
            this.commitGeom();
            this.d_geomId = GeomImportSession.this.newId(Placeholder.GEOM);
            this.resetGeom();
            return this.d_geomId;
        }

        public void endGeom() {
            assert (this.d_geomBuilder != null);
            DisplayGeom dg = this.commitGeom();
            GeomImportSession.this.commitId(this.d_geomId, dg);
        }

        public GeomImportHelper currGeom() {
            if (this.d_geomBuilder == null) {
                this.resetGeom();
            }
            return this.d_geomBuilder;
        }

        public IGeomImportSession.Node toNode() {
            this.commitGeom();
            DisplayGeom dg = this.finalizeNodeGeom(this.d_finishedGeoms);
            if (GeomImportSession.this.d_combineNodes && dg == DisplayGeom.EMPTY && this.d_children.size() == 1 && this.name.equals(this.d_children.get((int)0).name)) {
                IGeomImportSession.Node child = this.d_children.get(0);
                long id = this.nodeId == -1 ? child.id : (long)this.nodeId;
                return new IGeomImportSession.Node(id, this.name, this.d_transform.concatenate(child.transform), child.props, child.dg, child.children);
            }
            DoubleUnaryOperator convertLength = slen -> {
                if (Double.isNaN(slen)) {
                    return slen;
                }
                return GeomImportSession.this.d_lengthScale * slen;
            };
            IImportSession.NodeProps nprops = this.props;
            if (!Double.isNaN(this.props.doorWidth) || !Double.isNaN(this.props.doorHeight)) {
                nprops = this.props.clone();
                nprops.doorWidth = convertLength.applyAsDouble(nprops.doorWidth);
                nprops.doorHeight = convertLength.applyAsDouble(nprops.doorHeight);
            }
            return new IGeomImportSession.Node(this.nodeId, this.name, this.d_transform, nprops, dg, this.d_children);
        }

        public void addChild(IGeomImportSession.Node child) {
            this.d_children.add(child);
        }

        public void addNodeRef(IGeomImportSession.Node node) {
            ITransform xform = this.currTransform();
            if (!xform.isIdentity()) {
                node = GeomImportSession.this.d_combineNodes ? new IGeomImportSession.Node(node.id, node.name, xform.concatenate(node.transform), node.props, node.dg, node.children) : new IGeomImportSession.Node(node.id, node.name, xform, node.props, DisplayGeom.EMPTY, Collections.singleton(node));
            }
            this.addChild(node);
        }

        public void addGeomRef(long id, DisplayGeom dg) {
            this.commitGeom();
            assert (dg.node.getLocalTransform().isIdentity() && dg.node.getChildren().isEmpty());
            ITransform xform = this.currTransform();
            if (!xform.isIdentity()) {
                IGeomImportSession.Node child = new IGeomImportSession.Node(id, this.name, xform, this.props, dg, Collections.emptyList());
                this.addChild(child);
            } else {
                this.d_finishedGeoms.add(dg);
            }
        }

        public void pushModelTransform(ITransform xform) {
            xform = this.currTransform().concatenate(xform);
            this.d_xformStack.push(xform);
        }

        public void popModelTransform() {
            this.d_xformStack.pop();
        }

        public ITransform currTransform() {
            return this.d_xformStack.peek();
        }

        private DisplayGeom finalizeNodeGeom(Collection<DisplayGeom> dgeoms) {
            ArrayList<DisplayGeomBuilder.Rep> reps = new ArrayList<DisplayGeomBuilder.Rep>(dgeoms.size());
            for (DisplayGeom dg : dgeoms) {
                assert (dg.node.getLocalTransform().isIdentity() && dg.node.getChildren().isEmpty());
                reps.add(new DisplayGeomBuilder.Rep(dg.node.getLocalGeom(), dg.node.getLocalElements(), dg.props));
            }
            return DisplayGeomBuilder.merge(reps).toDisplay();
        }
    }

    private static enum Placeholder {
        NODE,
        GEOM;

    }
}

