/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.cad.in.CadImporterUtil;
import thunderheadeng.cad.in.GeomImportSession;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.IImportSession;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.SolidGeom;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementPoly;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GeomImportHelper {
    private static final Point3d[] EMPTY_ARRAY = new Point3d[0];
    private final IPointOptimizer d_pointPool;
    private final Supplier<ITransform> d_transformSrc;
    private final boolean d_solid;
    private final IntFunction<Pair<GeomImportSession.Material, IMaterial>> d_matMap;
    private final boolean d_autoCorrectInvertedNormals;
    private final boolean d_importNormals;
    private final boolean d_importCreases;
    private final double d_creaseAngle;
    private final IPropertySet d_importProps;
    public boolean ignoreText = false;
    private GeomImportSession.Material d_currentImportMat;
    private IPrimProps.Face d_currentFaceProps;
    private IPrimProps.Edge d_currentEdgeProps;
    private IPrimProps.Vertex d_currentVertexProps;
    private IPrimProps.GenericProps d_currentGenericProps;
    private final DisplayGeomBuilder d_faceBuilder;
    private final DisplayGeomBuilder d_nonFaceBuilder;
    private Point3d[] d_lastPolyline;
    private static final Point2d s_emptyUV = new Point2d(0.0, 0.0);

    public GeomImportHelper(Supplier<ITransform> transformSrc, IPointOptimizer pointPool, boolean solid, IntFunction<Pair<GeomImportSession.Material, IMaterial>> matMap, IPropertySet importProps) {
        this.d_pointPool = pointPool;
        this.d_transformSrc = transformSrc;
        this.d_solid = solid;
        this.d_matMap = matMap;
        this.d_importProps = importProps;
        this.d_autoCorrectInvertedNormals = importProps.get(IGeomImportSession.AUTO_CORRECT_NORMALS);
        this.d_importNormals = importProps.get(IGeomImportSession.IMPORT_NORMALS);
        this.d_importCreases = importProps.get(IGeomImportSession.IMPORT_CREASES);
        this.d_creaseAngle = importProps.get(IGeomImportSession.CREASE_ANGLE).get(SI.RADIAN);
        this.d_faceBuilder = new DisplayGeomBuilder();
        this.d_nonFaceBuilder = new DisplayGeomBuilder();
        this.d_lastPolyline = null;
        this.d_currentImportMat = null;
        this.d_currentFaceProps = new IPrimProps.Face(Color.WHITE, null, 0);
        this.d_currentEdgeProps = new IPrimProps.Edge(Color.WHITE, 1.0, IPrimProps.DEF_STIPPLE, 0);
        this.d_currentVertexProps = new IPrimProps.Vertex(Color.WHITE, 1.0);
        this.d_currentGenericProps = new IPrimProps.GenericProps(Color.WHITE, null, 1.0, 255, 1.0, 0);
    }

    public void setCurrentColor(Color color) {
        this.d_currentFaceProps = GeomImportHelper.setColor(this.d_currentFaceProps, color);
        this.d_currentEdgeProps = GeomImportHelper.setColor(this.d_currentEdgeProps, color);
        this.d_currentVertexProps = GeomImportHelper.setColor(this.d_currentVertexProps, color);
        this.d_currentGenericProps = GeomImportHelper.setColor(this.d_currentGenericProps, color);
    }

    public void setCurrentMatl(int matId) {
        Pair<GeomImportSession.Material, IMaterial> mat = this.d_matMap.apply(matId);
        this.d_currentImportMat = (GeomImportSession.Material)mat.v1;
        this.d_currentFaceProps = GeomImportHelper.setMaterial(this.d_currentFaceProps, (IMaterial)mat.v2);
        this.d_currentGenericProps = GeomImportHelper.setMaterial(this.d_currentGenericProps, (IMaterial)mat.v2);
    }

    private static <T extends IPrimProps> T setColor(T props, Color color) {
        if (!theUtil.equal(props.getColor(), color)) {
            return (T)props.setColor(color);
        }
        return props;
    }

    private static <T extends IPrimProps> T setMaterial(T props, IMaterial matl) {
        if (!theUtil.equal(props.getMaterial(), matl)) {
            return (T)props.setMaterial(matl);
        }
        return props;
    }

    private <T extends Tuple3d> T[] unflatten3d(TransformInfo ti, double[] flatverts, Class<T> type) {
        Matrix4d mat = ti.getMatrix();
        Tuple3d[] verts = (Tuple3d[])Array.newInstance(type, flatverts.length / 3);
        for (int i = 0; i < flatverts.length; i += 3) {
            Tuple3d p;
            int j = i / 3;
            try {
                p = (Tuple3d)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                assert (false);
                throw new RuntimeException(e);
            }
            p.x = flatverts[i];
            p.y = flatverts[i + 1];
            p.z = flatverts[i + 2];
            if (p instanceof Vector3d) {
                Vector3d v = (Vector3d)p;
                mat.transform(v);
                Util3D.safeNormalize(v, 0.0);
            } else if (p instanceof Point3d) {
                mat.transform((Point3d)p);
            }
            verts[j] = p = this.d_pointPool.getExisting(p);
        }
        return verts;
    }

    private Point2d[] unflatten2d(double[] flatverts) {
        return this.unflatten2d(flatverts, 0, flatverts.length);
    }

    private Point2d[] unflatten2d(double[] flatverts, int offset, int length) {
        Point2d[] verts = new Point2d[length / 2];
        for (int i = 0; i < length; i += 2) {
            int j = i / 2;
            int off = offset + i;
            Point2d p = new Point2d(flatverts[off], flatverts[off + 1]);
            verts[j] = p = this.d_pointPool.getExisting(p);
        }
        return verts;
    }

    private static boolean isEmpty(IGeom geom) {
        return GeomUtil.isEmpty(geom);
    }

    protected void addGeom(IGeom geom) {
        this.addGeom(geom, p -> Elements.NONE);
    }

    protected void addGeom(IGeom geom, Function<IPrimProps, IPropertySet> elements) {
        if (!GeomImportHelper.isEmpty(geom)) {
            int numPrims = geom.getNumPrims(7);
            int numFaces = geom.getNumPrims(1);
            if (numFaces > 0) {
                assert (numFaces == numPrims);
                this.d_faceBuilder.add(geom, new UniformProps(this.d_currentFaceProps), elements.apply(this.d_currentFaceProps));
            } else {
                assert (numFaces == 0);
                IPrimProps.AProps props = numPrims == geom.getNumPrims(2) ? this.d_currentEdgeProps : (numPrims == geom.getNumPrims(4) ? this.d_currentVertexProps : this.d_currentGenericProps);
                this.d_nonFaceBuilder.add(geom, new UniformProps(props), Elements.NONE);
            }
        }
    }

    private TransformInfo getTransformInfo() {
        return this.d_transformSrc.get().getInfo();
    }

    public void polygonOut(double[] flatverts, double[] texuv, double[] normal) {
        Point2d[] uvverts;
        assert (flatverts.length % 3 == 0);
        assert (normal.length == 0 || normal.length == 3);
        TransformInfo ti = this.getTransformInfo();
        Point3d[] verts = (Point3d[])this.unflatten3d(ti, flatverts, Point3d.class);
        Point2d[] point2dArray = uvverts = texuv != null ? this.unflatten2d(texuv) : new Point2d[]{};
        if (ti.hasNegativeScale()) {
            theUtil.reverse(verts);
            theUtil.reverse(uvverts);
        }
        IPolygon poly = PolyUtil.newPoly(verts);
        Function<IPrimProps, IPropertySet> elemFunc = p -> {
            IPropertySet elems = Elements.newElements();
            elems.setIfNotDefault(Elements.ORIENT, Elements.CCW);
            IMaterial mat = p.getMaterial();
            if (mat != null && uvverts.length > 0) {
                ElementPoly<Point2d> uv = new ElementPoly<Point2d>(uvverts);
                Set<String> uvsets = mat.getAttributes().getUVSets();
                ListMap<String, ElementPoly<Point2d>> uvs = new ListMap<String, ElementPoly<Point2d>>();
                for (String uvset : uvsets) {
                    uvs.put(uvset, uv);
                }
                elems.setIfNotDefault(Elements.UV, uvs);
            }
            return Elements.finalizeElements(elems);
        };
        this.addGeom(poly, elemFunc);
    }

    public void polylineOut(double[] flatverts) {
        assert (6 <= flatverts.length);
        assert (flatverts.length % 3 == 0);
        Point3d[] verts = (Point3d[])this.unflatten3d(this.getTransformInfo(), flatverts, Point3d.class);
        if (this.d_lastPolyline != null && this.d_lastPolyline[this.d_lastPolyline.length - 1].equals((Tuple3d)verts[verts.length - 1])) {
            assert (2 <= this.d_lastPolyline.length);
            Point3d[] temp = new Point3d[this.d_lastPolyline.length + verts.length];
            System.arraycopy(this.d_lastPolyline, 0, temp, 0, this.d_lastPolyline.length);
            System.arraycopy(verts, 0, temp, this.d_lastPolyline.length, verts.length);
            this.d_lastPolyline = temp;
        } else if (this.d_lastPolyline != null) {
            this.finishPolyline(this.d_lastPolyline);
            this.d_lastPolyline = verts;
        } else {
            this.d_lastPolyline = verts;
        }
    }

    private void finishPolyline(Point3d[] verts) {
        ACurve lineGeom = verts.length == 2 ? new LineSeg(verts[0], verts[1]) : new PolyLine(verts);
        this.addGeom(lineGeom);
    }

    private static IElementIx getElementIxes(IImportSession.MeshElementMapping mapping, int[] indices) {
        switch (mapping) {
            case ALL_SAME: {
                return (pix, flix, pvix) -> 0;
            }
            case PER_FACE: {
                if (indices.length > 0) {
                    return (polyix, flix, pvix) -> indices[polyix];
                }
                return (polyix, flix, pvix) -> polyix;
            }
            case PER_INDEX: {
                if (indices.length > 0) {
                    return (polyix, flix, pvix) -> indices[flix];
                }
                return (polyix, flix, pvix) -> pvix;
            }
        }
        return null;
    }

    private static List<Point2d> newUVSet(int count) {
        ArrayList<Point2d> uvs = new ArrayList<Point2d>(count);
        for (int m = 0; m < count; ++m) {
            uvs.add(s_emptyUV);
        }
        return uvs;
    }

    public void shellProc(IImportSession.FaceOrient faceOrient, double[] flatverts, int[] faceList, double[] flatUVs, String[] uvSetNames, int[] flatUVSets, IImportSession.MeshElementMapping normalMapping, double[] flatNormals, int[] normalFaceList, IImportSession.MeshElementMapping creaseMapping, boolean[] creases, int[] creaseFaceList, int[] materials) {
        boolean ccw;
        Point2d[] uvVerts;
        assert (flatverts.length % 3 == 0);
        assert (flatUVs.length % 2 == 0);
        assert (faceList != null);
        assert (flatUVSets != null);
        assert (flatUVSets.length == 0 || flatUVSets.length == uvSetNames.length * faceList.length);
        if (!this.d_importNormals) {
            normalMapping = IImportSession.MeshElementMapping.NONE;
        }
        if (!this.d_importCreases) {
            creaseMapping = IImportSession.MeshElementMapping.NONE;
        }
        TransformInfo ti = this.getTransformInfo();
        Point3d[] verts = (Point3d[])this.unflatten3d(ti, flatverts, Point3d.class);
        ListMap<String, int[]> uvSets = new ListMap<String, int[]>();
        for (int m2 = 0; m2 < uvSetNames.length; ++m2) {
            String uvSetName = uvSetNames[m2];
            int[] uvSet = Arrays.copyOfRange(flatUVSets, m2 * faceList.length, (m2 + 1) * faceList.length);
            uvSets.putIfAbsent(uvSetName, uvSet);
        }
        Point2d[] point2dArray = uvVerts = flatUVs.length > 0 ? this.unflatten2d(flatUVs) : null;
        if (uvVerts == null) {
            flatUVSets = null;
        }
        Vector3d[] normalVerts = (Vector3d[])this.unflatten3d(ti, flatNormals, Vector3d.class);
        IElementIx normalIxes = GeomImportHelper.getElementIxes(normalMapping, normalFaceList);
        IElementIx creaseIxes = GeomImportHelper.getElementIxes(creaseMapping, creaseFaceList);
        ArrayList<Point3d> facePts = new ArrayList<Point3d>();
        ArrayList<Integer> loopOffsets = new ArrayList<Integer>();
        LinkedHashMap tempUVSets = new LinkedHashMap();
        for (String uvSetName : uvSets.keySet()) {
            tempUVSets.put(uvSetName, new ArrayList());
        }
        LinkedHashMap<String, List<Point2d>> faceUVSets = new LinkedHashMap<String, List<Point2d>>();
        IdentityHashMap<IMaterial, Set> matUVSets = new IdentityHashMap<IMaterial, Set>();
        Function<IMaterial, Set> getUVSet = m -> m.getAttributes().getUVSets();
        ArrayList<Vector3d> faceNormal = new ArrayList<Vector3d>();
        ArrayList<Boolean> faceCrease = new ArrayList<Boolean>();
        MeshBuilder triBuilder = new MeshBuilder(2);
        MeshBuilder quadBuilder = new MeshBuilder(3);
        ArrayList<DisplayGeomBuilder.Rep> gpolyDisplays = new ArrayList<DisplayGeomBuilder.Rep>();
        FacePropSrc propSrc = new FacePropSrc(materials);
        boolean bl = ccw = faceOrient == IImportSession.FaceOrient.CCW;
        if (ti.hasNegativeScale()) {
            ccw = !ccw;
        }
        int inormCount = 0;
        int validCount = 0;
        int iFace = 0;
        int i = 0;
        int polyix = 0;
        while (i < faceList.length) {
            int n = faceList[i++];
            assert (facePts.isEmpty() || n < 0);
            int nverts = Math.abs(n);
            loopOffsets.add(facePts.size());
            int j = 0;
            while (j < nverts) {
                int flix = i + j;
                facePts.add(verts[faceList[flix]]);
                if (uvVerts != null) {
                    for (Map.Entry entry : uvSets.entrySet()) {
                        int[] uvSet = (int[])entry.getValue();
                        ((List)tempUVSets.get(entry.getKey())).add(uvVerts[uvSet[flix]]);
                    }
                }
                if (normalIxes != null) {
                    faceNormal.add(normalVerts[normalIxes.apply(iFace, flix, polyix)]);
                }
                if (creaseIxes != null) {
                    faceCrease.add(creases[creaseIxes.apply(iFace, flix, polyix)]);
                }
                ++j;
                ++polyix;
            }
            if (faceList.length > (i += nverts) && 0 >= faceList[i]) continue;
            Point3d[] points = theUtil.toArray(facePts, Point3d.class);
            int[] offs = theUtil.toIntArray(loopOffsets);
            IPolygon poly = PolyUtil.newPoly(points, offs);
            Pair<IPrimProps.Face, GeomImportSession.Material> nextProps = propSrc.next();
            Vector3d pnormal = poly.getNormal(ccw);
            if (pnormal.lengthSquared() > 0.0) {
                ++validCount;
                faceUVSets.clear();
                faceUVSets.putAll(tempUVSets);
                if (((IPrimProps.Face)nextProps.v1).material != null && !tempUVSets.isEmpty()) {
                    boolean uvReplaced = false;
                    Map.Entry defaultUV = tempUVSets.entrySet().iterator().next();
                    Set matuv = matUVSets.computeIfAbsent(((IPrimProps.Face)nextProps.v1).material, getUVSet);
                    for (String uvset : matuv) {
                        uvReplaced |= faceUVSets.putIfAbsent(uvset, (List<Point2d>)defaultUV.getValue()) == null;
                    }
                    if (uvReplaced && !matuv.contains(defaultUV.getKey())) {
                        faceUVSets.remove(defaultUV.getKey());
                    }
                    if (matuv.isEmpty() && this.d_importProps.get(IGeomImportSession.RENAME_ABANDONED_UV_TO) != null) {
                        String defuvname = this.d_importProps.get(IGeomImportSession.RENAME_ABANDONED_UV_TO);
                        faceUVSets.remove(defaultUV.getKey());
                        faceUVSets.put(defuvname, (List<Point2d>)defaultUV.getValue());
                    }
                }
                if (this.d_autoCorrectInvertedNormals && !faceNormal.isEmpty() && faceNormal.stream().allMatch(v -> v.dot(pnormal) < 0.0)) {
                    ++inormCount;
                }
                if (poly instanceof Triangle || poly instanceof Quad) {
                    MeshBuilder faceBuilder = poly instanceof Triangle ? triBuilder : quadBuilder;
                    faceBuilder.addPrim((IPrimProps)nextProps.v1, facePts, faceUVSets, faceNormal, faceCrease);
                } else {
                    IPropertySet elems = Elements.newElements();
                    elems.setIfNotDefault(Elements.NORMAL, this.finalizePolyElems(Elements.NORMAL, faceNormal));
                    elems.setIfNotDefault(Elements.CREASE, this.finalizePolyElems(Elements.CREASE, faceCrease));
                    elems.setIfNotDefault(Elements.ORIENT, Elements.CCW);
                    ListMap uvs = new ListMap();
                    for (Map.Entry entry : faceUVSets.entrySet()) {
                        uvs.put(entry.getKey(), this.finalizePolyElems(Point2d.class, Elements.NO_UV, (List)entry.getValue()));
                    }
                    elems.setIfNotDefault(Elements.UV, uvs);
                    elems = Elements.finalizeElements(elems);
                    gpolyDisplays.add(new DisplayGeomBuilder.Rep(poly, elems, new UniformProps((IPrimProps)nextProps.v1)));
                }
            }
            facePts.clear();
            loopOffsets.clear();
            for (List uvSet : tempUVSets.values()) {
                uvSet.clear();
            }
            faceNormal.clear();
            faceCrease.clear();
            ++iFace;
        }
        if (inormCount == validCount) {
            ccw = !ccw;
        }
        DisplayGeomBuilder builder = new DisplayGeomBuilder();
        for (DisplayGeomBuilder.Rep dg : gpolyDisplays) {
            if (!ccw) {
                IPropertySet elems = Elements.makeMutable(dg.elements);
                elems.setIfNotDefault(Elements.ORIENT, Elements.CW);
                elems = Elements.finalizeElements(elems);
                dg = new DisplayGeomBuilder.Rep(dg.geom, elems, dg.props);
            }
            builder.add(dg);
        }
        if (!triBuilder.isEmpty()) {
            DisplayGeomBuilder.Rep triGeom = triBuilder.finalizeGeom(ccw, this.d_creaseAngle, this.d_autoCorrectInvertedNormals);
            builder.add(triGeom);
        }
        if (!quadBuilder.isEmpty()) {
            DisplayGeomBuilder.Rep quadGeom = quadBuilder.finalizeGeom(ccw, this.d_creaseAngle, this.d_autoCorrectInvertedNormals);
            builder.add(quadGeom);
        }
        DisplayGeomBuilder.Rep dg = builder.finish();
        this.d_faceBuilder.add(dg);
    }

    private <ElemT> IElemSource<ElemT> finalizePolyElems(Elements.ElemProp<ElemT> prop, List<ElemT> elements) {
        return this.finalizePolyElems(prop.type, (IElemSource)prop.defVal, elements);
    }

    private <ElemT> IElemSource<ElemT> finalizePolyElems(Class<ElemT> type, IElemSource<ElemT> defVal, List<ElemT> elements) {
        if (elements.isEmpty()) {
            return defVal;
        }
        if (elements.size() == 1) {
            return new ElementUniform<ElemT>(elements.get(0));
        }
        if (GeomImportHelper.isUniform(elements)) {
            return new ElementUniform<ElemT>(elements.get(0));
        }
        return new ElementPoly<ElemT>(theUtil.toArray(elements, type));
    }

    private static <T> boolean isUniform(List<T> items) {
        if (items.isEmpty()) {
            return true;
        }
        T first = items.get(0);
        int count = items.size();
        for (int m = 1; m < count; ++m) {
            if (Objects.equals(first, items.get(m))) continue;
            return false;
        }
        return true;
    }

    public void meshProc(IImportSession.FaceOrient faceOrient, int rows, int cols, double[] flatverts, boolean[] creases) {
        int[] indices = new int[(rows - 1) * (cols - 1) * 5];
        int ix = 0;
        for (int i = 0; i < rows - 1; ++i) {
            for (int j = 0; j < cols - 1; ++j) {
                int n = i * cols + j;
                indices[ix++] = 4;
                indices[ix++] = n;
                indices[ix++] = n + cols;
                indices[ix++] = n + cols + 1;
                indices[ix++] = n + 1;
            }
        }
        IImportSession.MeshElementMapping creaseMapping = IImportSession.MeshElementMapping.NONE;
        boolean[] creaseElements = new boolean[]{};
        int[] creaseIxes = new int[]{};
        if (creases.length > 0) {
            creaseElements = new boolean[]{false, true};
            creaseMapping = IImportSession.MeshElementMapping.PER_INDEX;
            creaseIxes = new int[indices.length];
            ix = 0;
            for (int i = 0; i < rows - 1; ++i) {
                for (int j = 0; j < cols - 1; ++j) {
                    int m = i * (cols - 1) + j;
                    int n = (cols - 1) * rows + j * (rows - 1) + i;
                    creaseIxes[ix++] = 4;
                    creaseIxes[ix++] = creases[n] ? 1 : 0;
                    creaseIxes[ix++] = creases[m + (cols - 1)] ? 1 : 0;
                    creaseIxes[ix++] = creases[n + (rows - 1)] ? 1 : 0;
                    creaseIxes[ix++] = creases[m] ? 1 : 0;
                }
            }
        }
        this.shellProc(faceOrient, flatverts, indices, new double[0], new String[0], new int[0], IImportSession.MeshElementMapping.NONE, new double[0], new int[0], creaseMapping, creaseElements, creaseIxes, new int[0]);
    }

    public boolean circleProc(double[] center, double radius, double[] normal, double[] extrusion) {
        if (!GeomImportHelper.isNullExtrusion(extrusion)) {
            return false;
        }
        Matrix4d lwXform = this.getLWXform(center, null, new Plane3d(normal[0], normal[1], normal[2], 0.0));
        Ellipse2D.Double circle = ShapeUtil.newCircle(radius);
        ShapeGeom geom = new ShapeGeom((Shape)circle, lwXform);
        this.addGeom(geom);
        return true;
    }

    public boolean plineProc(double elevation, double[] verts2d, double[] bulges, double[] widths, int[] segTypes, double thickness, double[] normal, boolean isClosed, double[] planeXform, int segStart, int numSegs) {
        if (thickness != 0.0 || verts2d.length == 0 || segStart != 0 || numSegs != 0) {
            return false;
        }
        for (double width : widths) {
            if (width == 0.0) continue;
            return false;
        }
        int numVerts = verts2d.length / 2;
        Point2d[] verts = new Point2d[numVerts];
        for (int m = 0; m < verts.length; ++m) {
            int offset = m * 2;
            double x = verts2d[offset];
            double y = verts2d[offset + 1];
            verts[m] = new Point2d(x, y);
        }
        assert (bulges.length == numVerts && (widths.length == 0 || widths.length / 2 == numVerts) && segTypes.length == numVerts);
        ShapeUtil.PolyLineBuilder builder = new ShapeUtil.PolyLineBuilder();
        block6: for (int m = 0; m < numVerts; ++m) {
            Point2d p1 = verts[m];
            if (m == 0) {
                builder.moveTo(p1);
            }
            Point2d p2 = verts[(m + 1) % numVerts];
            if (m == numVerts - 1 && (!isClosed || p1.equals((Tuple2d)p2))) break;
            int type = segTypes[m];
            switch (type) {
                case 0: {
                    builder.lineTo(p2);
                    continue block6;
                }
                case 1: {
                    double bulge = bulges[m];
                    builder.bulgeTo(p2, bulge);
                    continue block6;
                }
            }
        }
        Path2D.Double path = builder.getPath();
        Plane3d plane = new Plane3d(normal[0], normal[1], normal[2], -elevation);
        Matrix4d lwXform = this.d_transformSrc.get().toMatrix(true);
        if (planeXform != null) {
            lwXform.mul(new Matrix4d(planeXform));
        }
        lwXform.mul(CadImporterUtil.getLocalToWorldXform(plane));
        this.addGeom(new ShapeGeom((Shape)path, lwXform));
        return true;
    }

    private static boolean isNullExtrusion(double[] extrusion) {
        for (double ext : extrusion) {
            if (ext == 0.0) continue;
            return false;
        }
        return true;
    }

    public void metafileProc(double[] origin, double[] u, double[] v) {
        System.out.printf("Origin: %s%n", Arrays.toString(origin));
        System.out.printf("U: %s%n", Arrays.toString(u));
        System.out.printf("V: %s%n", Arrays.toString(v));
    }

    private Matrix4d getLWXform(double[] offset, double[] extraXform, Plane3d plane) {
        return this.getLWXform(offset, extraXform, CadImporterUtil.getLocalToWorldXform(plane));
    }

    private Matrix4d getLWXform(double[] offset, double[] extraXform, Matrix4d planeXform) {
        Matrix4d xform = this.d_transformSrc.get().toMatrix(true);
        if (offset != null) {
            xform.mul(Util.translateMat(offset[0], offset[1], offset[2]));
        }
        if (extraXform != null) {
            xform.mul(new Matrix4d(extraXform));
        }
        xform.mul(planeXform);
        return xform;
    }

    public boolean circularArcProc(double[] center, double radius, double[] normal, double[] startVector, double sweepAngle, int arcType, double[] extrusion) {
        if (arcType != 0 || !GeomImportHelper.isNullExtrusion(extrusion)) {
            return false;
        }
        Plane3d plane = new Plane3d(normal[0], normal[1], normal[2], 0.0);
        Matrix4d lpXform = CadImporterUtil.getLocalToWorldXform(plane);
        Matrix4d lwXform = this.getLWXform(center, null, lpXform);
        Vector3d xAxis = Util3D.xform(lpXform, GeomConstants.VEC3D_XPOS);
        double a1Rad = Util3D.angle0To2PI(xAxis, new Vector3d(startVector), plane.getNormal());
        double a2Rad = a1Rad + sweepAngle;
        Arc2D.Double arc = ShapeUtil.newCircularArc(0.0, 0.0, radius, a1Rad, a2Rad, true);
        ShapeGeom geom = new ShapeGeom((Shape)arc, lwXform);
        this.addGeom(geom);
        return true;
    }

    public boolean circularArcProc(double[] firstPoint, double[] secondPoint, double[] thirdpoint, int arcType, double[] extrusion) {
        System.out.println("circularArcProc() - simplifying");
        return false;
    }

    public boolean ellipticalArcProc(double[] center, double[] majorAxis, double majorRadius, double[] minorAxis, double minorRadius, double[] normal, double startAngle, double endAngle, double[] endPointOverrides, int arcType, double[] extrusion) {
        if (arcType != 0 || !GeomImportHelper.isNullExtrusion(extrusion) || endPointOverrides.length > 0) {
            return false;
        }
        Matrix4d pwXform = new Matrix4d(majorAxis[0], minorAxis[0], normal[0], 0.0, majorAxis[1], minorAxis[1], normal[1], 0.0, majorAxis[2], minorAxis[2], normal[2], 0.0, 0.0, 0.0, 0.0, 1.0);
        Matrix4d lwXform = this.getLWXform(center, null, pwXform);
        Arc2D.Double arc = ShapeUtil.newArc(0.0, 0.0, majorRadius * 2.0, minorRadius * 2.0, startAngle, endAngle, true);
        ShapeGeom geom = new ShapeGeom((Shape)arc, lwXform);
        this.addGeom(geom);
        return true;
    }

    public boolean textProc(double[] position, double[] direction, double[] upVector, String msg, boolean raw, int style, double[] extrusion) {
        if (this.ignoreText) {
            System.out.println("textProc() - ignoring: " + msg);
        }
        return this.ignoreText;
    }

    public DisplayGeomBuilder.Rep finish() {
        if (this.d_lastPolyline != null) {
            this.finishPolyline(this.d_lastPolyline);
        }
        DisplayGeomBuilder.Rep faceDG = this.d_faceBuilder.finish();
        if (this.d_solid && faceDG != DisplayGeomBuilder.EMPTY_REP) {
            faceDG = new DisplayGeomBuilder.Rep(new SolidGeom(faceDG.geom), faceDG.elements, faceDG.props);
        }
        DisplayGeomBuilder.Rep nonFaceDG = this.d_nonFaceBuilder.finish();
        DisplayGeomBuilder.Rep dg = DisplayGeomBuilder.merge(Arrays.asList(faceDG, nonFaceDG));
        IGeom finalGeom = dg.geom.optimize(this.d_pointPool);
        if (finalGeom.getNumPrims(7) == 0) {
            return DisplayGeomBuilder.EMPTY_REP;
        }
        if (finalGeom == dg.geom) {
            return dg;
        }
        return new DisplayGeomBuilder.Rep(finalGeom, dg.elements, dg.props);
    }

    private static int countPrims(Collection<? extends IGeom> geoms) {
        return new GeomGroup(geoms).getNumPrims(7);
    }

    private static class MeshBuilder {
        private final byte d_primType;
        private final PropsBuilder d_props = new PropsBuilder();
        private final VertBuilder<Point3d> d_verts = new VertBuilder();
        private final Map<String, VertBuilder<Point2d>> d_uvs = new ListMap<String, VertBuilder<Point2d>>();
        private final VertBuilder<Vector3d> d_normals = new VertBuilder();
        private final VertBuilder<Boolean> d_creases = new VertBuilder();
        private static final Point2d s_uv0 = new Point2d();

        public MeshBuilder(byte primType) {
            this.d_primType = primType;
        }

        public void addPrim(IPrimProps props, List<Point3d> points, Map<String, List<Point2d>> elemUVMap, List<Vector3d> normal, List<Boolean> crease) {
            int prePrimCount = this.d_verts.prims.size();
            assert (!points.isEmpty());
            this.d_verts.add(points);
            this.d_normals.add(normal, prePrimCount, GeomConstants.VEC3D_ZPOS);
            this.d_creases.add(crease, prePrimCount, Boolean.TRUE);
            for (Map.Entry<String, List<Point2d>> entry : elemUVMap.entrySet()) {
                VertBuilder builder = this.d_uvs.computeIfAbsent(entry.getKey(), prop -> new VertBuilder());
                builder.add(entry.getValue(), prePrimCount, s_uv0);
            }
            this.d_props.add(props);
        }

        public void addPrim(IPrimProps props, Point3d ... points) {
            for (Point3d p : points) {
                this.d_verts.add(p);
            }
            this.d_props.add(props);
        }

        public boolean isEmpty() {
            return this.d_verts.isEmpty();
        }

        public DisplayGeomBuilder.Rep finalizeGeom(boolean ccw, double creaseAngle, boolean fixOrients) {
            IElemSource<Elements.Orient> faceOrients;
            int desiredPCount = this.d_verts.prims.size();
            this.d_normals.finish(desiredPCount, GeomConstants.VEC3D_ZPOS);
            this.d_creases.finish(desiredPCount, Boolean.TRUE);
            for (Map.Entry<String, VertBuilder<Point2d>> entry : this.d_uvs.entrySet()) {
                entry.getValue().finish(desiredPCount, s_uv0);
            }
            Point3d[] points = theUtil.toArray(this.d_verts.verts.keySet(), Point3d.class);
            int[] prims = theUtil.toIntArray(this.d_verts.prims);
            Mesh mesh = new Mesh(points, prims, this.d_primType);
            Mesh.Fixer corrections = mesh.getFixes();
            mesh = corrections.fix(mesh);
            ListMap<String, IElemSource<Point2d>> uvSources = new ListMap<String, IElemSource<Point2d>>();
            for (Map.Entry<String, VertBuilder<Point2d>> entry : this.d_uvs.entrySet()) {
                Mesh correctedMesh = mesh;
                VertBuilder<Point2d> vb = entry.getValue();
                IElemSource<Point2d> uv = this.finishElem(correctedMesh, new Elements.ElemProp<Point2d>(0, Point2d.class, Elements.NO_UV), vb.verts.keySet(), vb.prims, el -> corrections.fixVertElements(el));
                uvSources.put(entry.getKey(), uv);
            }
            IElemSource<Vector3d> normals = this.finishElem(mesh, Elements.NORMAL, this.d_normals.verts.keySet(), this.d_normals.prims, el -> corrections.fixVertElements(el));
            Function creaseCorrector = el -> el;
            if (corrections.needsMeshCorrection() && !this.d_creases.isEmpty()) {
                int nocreaseIx = this.d_creases.verts.computeIfAbsent(Boolean.FALSE, b -> this.d_creases.verts.size());
                creaseCorrector = el -> corrections.fixEdgeElements(el, i -> nocreaseIx);
            }
            IElemSource<Boolean> creases = this.finishElem(mesh, Elements.CREASE, this.d_creases.verts.keySet(), this.d_creases.prims, creaseCorrector);
            PropsBuilder props = this.d_props;
            if (corrections.needsPropFix()) {
                PropsBuilder newBuilder = new PropsBuilder();
                corrections.fixProps(this.d_props.iterator(), newBuilder::add);
                props = newBuilder;
            }
            IPropsSrc propsSrc = props.finalizeProps();
            IElemSource<Elements.Orient> iElemSource = faceOrients = ccw ? Elements.CCW : Elements.CW;
            if (normals == Elements.NO_NORMAL && creaseAngle > 0.0) {
                if (fixOrients) {
                    faceOrients = Elements.fixFaceOrients(mesh, faceOrients, propsSrc);
                }
                normals = Elements.generateNormals(mesh, faceOrients, creaseAngle);
            }
            if (this.d_creases.isEmpty()) {
                IElemSource<Vector3d> creaseNormals = normals;
                if (creaseNormals == Elements.NO_NORMAL) {
                    creaseNormals = Elements.generateNormals(mesh, faceOrients, creaseAngle);
                }
                creases = Elements.generateCreasesFromNormals(mesh, (IPropsSrc)props, creaseNormals, faceOrients);
            }
            IPropertySet elements = Elements.newElements();
            elements.setIfNotDefault(Elements.UV, uvSources);
            elements.setIfNotDefault(Elements.NORMAL, normals);
            elements.setIfNotDefault(Elements.CREASE, creases);
            elements.setIfNotDefault(Elements.ORIENT, faceOrients);
            elements = Elements.finalizeElements(elements);
            int numPrims = mesh.getNumPrims(7);
            IGeom geom = mesh;
            if (numPrims == 0) {
                return DisplayGeomBuilder.EMPTY_REP;
            }
            if (numPrims == 1) {
                geom = mesh.getPrimitive(0);
            }
            return new DisplayGeomBuilder.Rep(geom, elements, propsSrc);
        }

        private <ElemT> IElemSource<ElemT> finishElem(Mesh geomMesh, Elements.ElemProp<ElemT> prop, Collection<ElemT> elements, List<Integer> ixes, Function<ElementMesh<ElemT>, ElementMesh<ElemT>> fixer) {
            if (this.d_verts.prims.size() == ixes.size()) {
                byte primtype;
                int[] elemPrims;
                if (elements.size() == 1) {
                    return new ElementUniform<ElemT>(elements.iterator().next());
                }
                ElemT[] elems = theUtil.toArray(elements, prop.type);
                if (this.d_verts.prims.equals(ixes)) {
                    elemPrims = geomMesh.indices;
                    primtype = geomMesh.primtype;
                } else {
                    elemPrims = theUtil.toIntArray(ixes);
                    primtype = this.d_primType;
                }
                ElementMesh elmesh = new ElementMesh(ElementMesh.Mapping.PER_PRIM_VERTEX, elems, elemPrims, Mesh.getNumVertsPerElement(primtype));
                if (elemPrims != geomMesh.indices) {
                    elmesh = fixer.apply(elmesh);
                }
                if (elmesh.indices.length == elmesh.elements.length) {
                    elmesh = new ElementMesh(elmesh.mapping, elmesh.elements, elmesh.vertsPerPrim);
                }
                return elmesh.optimize(prop.type);
            }
            if (!elements.isEmpty()) {
                System.err.println("GeomImportHelper.MeshBuilder missing element coordinates for some faces.");
            }
            return (IElemSource)prop.defVal;
        }

        private static class VertBuilder<T> {
            public final Map<T, Integer> verts = new LinkedHashMap<T, Integer>();
            public final List<Integer> prims = new ArrayList<Integer>();

            private VertBuilder() {
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof VertBuilder && this.verts.equals(((VertBuilder)obj).verts) && this.prims.equals(((VertBuilder)obj).prims);
            }

            public void add(T p) {
                this.prims.add(this.indexOf(p));
            }

            public void add(List<T> points) {
                for (T p : points) {
                    this.add(p);
                }
            }

            public void add(List<T> points, int prePrimCount, T defVal) {
                if (points.isEmpty()) {
                    return;
                }
                this.matchSize(prePrimCount, defVal);
                this.add(points);
            }

            private void matchSize(int count, T defVal) {
                if (this.prims.size() < count) {
                    int i = this.indexOf(defVal);
                    for (int m = this.prims.size(); m < count; ++m) {
                        this.prims.add(i);
                    }
                }
            }

            public void finish(int desiredPrimCount, T defVal) {
                if (this.prims.isEmpty()) {
                    return;
                }
                this.matchSize(desiredPrimCount, defVal);
            }

            public boolean isEmpty() {
                return this.prims.isEmpty();
            }

            private Integer indexOf(T v) {
                Integer result = this.verts.get(v);
                if (result == null) {
                    result = this.verts.size();
                    this.verts.put(v, result);
                }
                return result;
            }
        }
    }

    private static interface IElementIx {
        public int apply(int var1, int var2, int var3);
    }

    private class FacePropSrc {
        private final int[] materials;
        private int d_ix;
        private GeomImportSession.Material d_imat;
        private IPrimProps.Face d_currProps;

        public FacePropSrc(int[] materials) {
            this.materials = materials;
            this.d_ix = 0;
            this.d_imat = GeomImportHelper.this.d_currentImportMat;
            this.d_currProps = GeomImportHelper.this.d_currentFaceProps;
        }

        public Pair<IPrimProps.Face, GeomImportSession.Material> next() {
            Pair newMat;
            switch (this.materials.length) {
                case 0: {
                    return new Pair<IPrimProps.Face, GeomImportSession.Material>(this.d_currProps, this.d_imat);
                }
                case 1: {
                    newMat = (Pair)GeomImportHelper.this.d_matMap.apply(this.materials[0]);
                    break;
                }
                default: {
                    int ix = this.d_ix++;
                    newMat = (Pair)GeomImportHelper.this.d_matMap.apply(this.materials[ix]);
                }
            }
            this.d_imat = (GeomImportSession.Material)newMat.v1;
            this.d_currProps = (IPrimProps.Face)GeomImportHelper.setMaterial(this.d_currProps, (IMaterial)newMat.v2);
            return new Pair<IPrimProps.Face, GeomImportSession.Material>(this.d_currProps, this.d_imat);
        }
    }
}

