/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;

public class CadImporterUtil {
    public static Matrix4d getWorldToLocalXform(Plane3d localPlane) {
        Vector3d lx = new Vector3d();
        Vector3d lz = new Vector3d();
        Vector3d ly = new Vector3d();
        CadImporterUtil.getLocalAxes(localPlane, lx, ly, lz);
        double xmove = lz.x * localPlane.w;
        double ymove = lz.y * localPlane.w;
        double zmove = lz.z * localPlane.w;
        return new Matrix4d(lx.x, lx.y, lx.z, lx.x * xmove + lx.y * ymove + lx.z * zmove, ly.x, ly.y, ly.z, ly.x * xmove + ly.y * ymove + ly.z * zmove, lz.x, lz.y, lz.z, lz.x * xmove + lz.y * ymove + lz.z * zmove, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4d getLocalToWorldXform(Plane3d localPlane) {
        Vector3d lx = new Vector3d();
        Vector3d lz = new Vector3d();
        Vector3d ly = new Vector3d();
        CadImporterUtil.getLocalAxes(localPlane, lx, ly, lz);
        double xmove = -lz.x * localPlane.w;
        double ymove = -lz.y * localPlane.w;
        double zmove = -lz.z * localPlane.w;
        return new Matrix4d(lx.x, ly.x, lz.x, xmove, lx.y, ly.y, lz.y, ymove, lx.z, ly.z, lz.z, zmove, 0.0, 0.0, 0.0, 1.0);
    }

    private static void getLocalAxes(Plane3d plane, Vector3d lx, Vector3d ly, Vector3d lz) {
        plane.getNormal(lz);
        if (Math.abs(lz.x) < 0.015625 && Math.abs(lz.y) < 0.015625) {
            lx.cross(GeomConstants.VEC3D_YPOS, lz);
        } else {
            lx.cross(GeomConstants.VEC3D_ZPOS, lz);
        }
        lx.normalize();
        ly.cross(lz, lx);
        ly.normalize();
    }
}

