/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jscience.physics.units.NonSI;
import thunderheadeng.Intl;
import thunderheadeng.cad.in.ExporterPnl;
import thunderheadeng.cad.in.GeomImportSession;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.IImportSession;
import thunderheadeng.cad.in.UnitsPnl;
import thunderheadeng.cad.in.fbx.FbxPropEditor;
import thunderheadeng.cad.in.ifc.IfcPropEditor;
import thunderheadeng.cad.in.teigha.TeighaGeomImportSession;
import thunderheadeng.cad.in.teigha.TeighaPropEditor;
import thunderheadeng.cad.in.teigha.TeighaTriangulationPnl;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.IEditor;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.util.BiIntFunction;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.JniTaskProgress;
import thunderheadeng.util.TaskProgress;

public class CadImporter {
    public static final int TYPE_TEIGHA = 0;
    public static final int TYPE_FBX = 1;
    public static final int TYPE_IFC = 2;
    private static volatile WeakReference<Thread> s_currThread = new WeakReference<Object>(null);
    private static final ExecutorService s_executor;
    private long d_peerObj;
    private int d_openedType = -1;
    private String d_openedFn = "";
    private static boolean s_librariesLoaded;

    private native void create();

    private native void destroy();

    private native int jniOpen(String var1, ByteBuffer var2) throws IOException;

    private native int jniGetLengthUnit();

    private native double[] jniGetModelBounds();

    private native void jniImportCad(IImportSession var1, ByteBuffer var2) throws IOException, CancellationException;

    private native int jniSetTriangulationParams(double var1, int var3);

    private native int jniSetIfcParameters(int var1);

    private native int jniDetectExporter();

    public static String[] getSupportedFileFormats() {
        return new String[]{"ifc", Intl.intl("Industry Foundation Classes (BIM)"), "ifcxml", Intl.intl("Industry Foundation Classes (BIM)"), "dxf", Intl.intl("Drawing Exchange Format File"), "dwg", Intl.intl("Drawing (AutoDesk)"), "fbx", Intl.intl("Autodesk FBX"), "dae", Intl.intl("Collada DAE"), "obj", Intl.intl("Alias OBJ")};
    }

    public CadImporter() {
        this.run(() -> this.create());
    }

    public void finalize() throws Throwable {
        this.freeData();
        super.finalize();
    }

    public void freeData() {
        this.run(() -> this.destroy());
    }

    private void run(Runnable task) {
        if (Thread.currentThread() == s_currThread.get()) {
            task.run();
            return;
        }
        try {
            s_executor.submit(task).get();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private <T> T call(T defVal, Callable<T> task) {
        try {
            if (Thread.currentThread() == s_currThread.get()) {
                return task.call();
            }
            return s_executor.submit(task).get();
        }
        catch (Throwable t) {
            return defVal;
        }
    }

    private void runIO(Callable<?> task) throws IOException, CancellationException {
        try {
            if (Thread.currentThread() == s_currThread.get()) {
                task.call();
            } else {
                s_executor.submit(task).get();
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new IOException(CadImporter.format(e.getCause()), e.getCause());
        }
        catch (IOException e) {
            throw e;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private static String format(Throwable t) {
        return t.getClass().getSimpleName() + ": " + t.getLocalizedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openCad(TaskProgress progress, String fnIn) throws IOException, CancellationException {
        String name = new File(fnIn).getName();
        progress.setMessageGenerator((curr, max) -> {
            switch (curr) {
                case -1: {
                    return String.format(Intl.intl("Opening %s"), name);
                }
            }
            return String.format(Intl.intl("Opening %s: %d %%"), name, (int)((float)curr / (float)max * 100.0f));
        });
        JniTaskProgress nprogress = new JniTaskProgress(progress);
        try {
            this.runIO(() -> {
                this.loadLibraries();
                this.d_openedType = this.jniOpen(fnIn, nprogress.getBuffer());
                this.d_openedFn = fnIn;
                return null;
            });
        }
        finally {
            nprogress.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLibraries() {
        Class<CadImporter> clazz = CadImporter.class;
        synchronized (CadImporter.class) {
            if (s_librariesLoaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            System.loadLibrary("ifcengine");
            s_librariesLoaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public IGeomImportSession createCompatibleGeomTarget(GeomImportSession.ICallback callback, IPropertySet props) {
        switch (this.d_openedType) {
            case 0: {
                return new TeighaGeomImportSession(callback, props);
            }
            case 1: 
            case 2: {
                return new GeomImportSession(callback, props);
            }
        }
        return null;
    }

    public int getLengthUnit() {
        return this.call(0, () -> this.jniGetLengthUnit());
    }

    public AABox getModelBounds() {
        return this.call(new AABox(), () -> {
            double[] coords = this.jniGetModelBounds();
            return new AABox(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
        });
    }

    public boolean isBoundsSlow() {
        switch (this.d_openedType) {
            case 0: {
                return !FilenameManager.getExtension(this.d_openedFn).equalsIgnoreCase("dxf");
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return true;
    }

    public int setTriangulationParams(double normTol, int betweenKnots) {
        return this.call(0, () -> this.jniSetTriangulationParams(normTol, betweenKnots));
    }

    public int setIfcParameters(IfcPropEditor.IfcGrouping grouping) {
        return this.call(0, () -> this.jniSetIfcParameters(grouping.ordinal()));
    }

    public Exporter detectExporter() {
        return this.call(Exporter.UNKNOWN, () -> {
            int iexporter = this.jniDetectExporter();
            return Exporter.values()[iexporter];
        });
    }

    public void initProperties(IPropertySet props, boolean includeGeom) {
        if (!includeGeom) {
            return;
        }
        UnitsPnl.initProps(props, this.d_openedFn, this);
        if (this.d_openedType == 1) {
            Exporter exporter = this.detectExporter();
            props.set(ExporterPnl.DETECTED_EXPORTER, exporter);
            ExporterPnl.initExporter(props, exporter);
        }
    }

    public List<Editor> createPropertyEditors(boolean wizardStyle, boolean includeGeom, IPropertySet props, IUnitSrc lengthUnitSrc) {
        if (!includeGeom) {
            return Collections.emptyList();
        }
        ArrayList<Editor> editors = new ArrayList<Editor>();
        if (this.d_openedType == 1) {
            editors.add(new Editor(Intl.intl("FBX Exporter"), new ExporterPnl(props), ExporterPnl.PROPS));
        }
        editors.add(new Editor(Intl.intl("Units"), new UnitsPnl(lengthUnitSrc, wizardStyle), UnitsPnl.PROPS));
        switch (this.d_openedType) {
            case 0: {
                editors.add(new Editor(Intl.intl("Import Settings"), new TeighaPropEditor(), TeighaPropEditor.PROPS));
                break;
            }
            case 1: {
                editors.add(new Editor(Intl.intl("Import Settings"), new FbxPropEditor(), FbxPropEditor.PROPS));
                break;
            }
            case 2: {
                editors.add(new Editor(Intl.intl("Import Settings"), new IfcPropEditor(), IfcPropEditor.PROPS));
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        return editors;
    }

    public void setProperties(IPropertySet props) {
        switch (this.d_openedType) {
            case 0: {
                this.setTriangulationParams(props.get(TeighaTriangulationPnl.NORMAL_TOLERANCE).get(NonSI.DEGREE_ANGLE), props.get(TeighaTriangulationPnl.BETWEEN_KNOTS));
                break;
            }
            case 2: {
                this.setIfcParameters(props.get(IfcPropEditor.IFC_GROUPING));
            }
        }
    }

    private BiIntFunction<String> getProgressMsg() {
        switch (this.d_openedType) {
            case 2: {
                return (curr, max) -> {
                    if (curr < 0 || curr > max) {
                        return Intl.intl("Importing objects");
                    }
                    return String.format(Intl.intl("Importing objects: %d%%"), (int)((double)curr / (double)max * 100.0));
                };
            }
        }
        return (curr, max) -> {
            switch (curr) {
                case -1: {
                    return Intl.intl("Importing objects");
                }
            }
            return String.format(Intl.intl("Importing object: %1$d / %2$d"), curr, max);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCad(TaskProgress progress, IImportSession ... callbackObjs) throws IOException, CancellationException {
        progress.setMessageGenerator(this.getProgressMsg());
        JniTaskProgress nprogress = new JniTaskProgress(progress);
        try {
            this.runIO(() -> {
                ImportSessionSplitter splitter = new ImportSessionSplitter(callbackObjs);
                try {
                    this.jniImportCad(splitter, nprogress.getBuffer());
                }
                finally {
                    splitter.endSession();
                }
                return null;
            });
        }
        finally {
            nprogress.finished();
        }
    }

    static {
        ThreadFactory tfactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                System.out.println("Creating new CAD import thread: " + t);
                s_currThread = new WeakReference<Thread>(t);
                return t;
            }
        };
        s_executor = Executors.newSingleThreadExecutor(tfactory);
        s_librariesLoaded = false;
    }

    private static class ImportSessionSplitter
    implements IImportSession {
        private IImportSession[] d_recipients;

        public ImportSessionSplitter(IImportSession[] recipients) {
            this.d_recipients = recipients;
            for (int i = 0; i < recipients.length / 2; ++i) {
                int j = recipients.length - 1 - i;
                IImportSession temp = recipients[i];
                recipients[i] = recipients[j];
                recipients[j] = temp;
            }
        }

        @Override
        public void beginMaterial(int id, String name, boolean twoSided) {
            for (IImportSession is : this.d_recipients) {
                is.beginMaterial(id, name, twoSided);
            }
        }

        @Override
        public void endMaterial() {
            for (IImportSession is : this.d_recipients) {
                is.endMaterial();
            }
        }

        @Override
        public void setMatlChnlColor(int chnl, int r, int g, int b) {
            for (IImportSession is : this.d_recipients) {
                is.setMatlChnlColor(chnl, r, g, b);
            }
        }

        @Override
        public void setMatlChnlMap(int chnl, double blendFactor, int uTiling, int vTiling, String filename, String uvSet) {
            for (IImportSession is : this.d_recipients) {
                is.setMatlChnlMap(chnl, blendFactor, uTiling, vTiling, filename, uvSet);
            }
        }

        @Override
        public void setMatlChnlParams(int chnl, double ... params) {
            for (IImportSession is : this.d_recipients) {
                is.setMatlChnlParams(chnl, params);
            }
        }

        @Override
        public void pushModelTransform(double[] xform) {
            for (IImportSession is : this.d_recipients) {
                is.pushModelTransform(xform);
            }
        }

        @Override
        public void popModelTransform() {
            for (IImportSession is : this.d_recipients) {
                is.popModelTransform();
            }
        }

        @Override
        public long beginGeom() {
            long result = 0L;
            for (IImportSession is : this.d_recipients) {
                result = is.beginGeom();
            }
            return result;
        }

        @Override
        public void endGeom() {
            for (IImportSession is : this.d_recipients) {
                is.endGeom();
            }
        }

        @Override
        public long beginNode(String name, IImportSession.NodeProps props) {
            long result = 0L;
            for (IImportSession is : this.d_recipients) {
                result = is.beginNode(name, props);
            }
            return result;
        }

        @Override
        public void endNode() {
            for (IImportSession is : this.d_recipients) {
                is.endNode();
            }
        }

        @Override
        public void endSession() {
            for (IImportSession is : this.d_recipients) {
                is.endSession();
            }
        }

        @Override
        public void insertReference(long id) {
            for (IImportSession is : this.d_recipients) {
                is.insertReference(id);
            }
        }

        @Override
        public void setCurrentColor(int r, int g, int b, int a) {
            for (IImportSession is : this.d_recipients) {
                is.setCurrentColor(r, g, b, a);
            }
        }

        @Override
        public void setCurrentMatl(int id) {
            for (IImportSession is : this.d_recipients) {
                is.setCurrentMatl(id);
            }
        }

        @Override
        public void polygonOut(double[] flatverts, double[] texuv, double[] normal) {
            for (IImportSession is : this.d_recipients) {
                is.polygonOut(flatverts, texuv, normal);
            }
        }

        @Override
        public void polylineOut(double[] flatverts) {
            for (IImportSession is : this.d_recipients) {
                is.polylineOut(flatverts);
            }
        }

        @Override
        public void shellProc(int faceOrient, double[] flatverts, int[] faceList, double[] uvs, String[] uvSetNames, int[] uvSets, int normalMapping, double[] flatNormals, int[] normalFaceList, int creaseMapping, boolean[] creases, int[] creaseFaceList, int[] materials) {
            for (IImportSession is : this.d_recipients) {
                is.shellProc(faceOrient, flatverts, faceList, uvs, uvSetNames, uvSets, normalMapping, flatNormals, normalFaceList, creaseMapping, creases, creaseFaceList, materials);
            }
        }

        @Override
        public void meshProc(int faceOrient, int rows, int cols, double[] flatverts, boolean[] creases) {
            for (IImportSession is : this.d_recipients) {
                is.meshProc(faceOrient, rows, cols, flatverts, creases);
            }
        }

        @Override
        public boolean circleProc(double[] center, double radius, double[] normal, double[] extrusion) {
            boolean result = false;
            for (IImportSession is : this.d_recipients) {
                result = is.circleProc(center, radius, normal, extrusion);
            }
            return result;
        }

        @Override
        public boolean plineProc(double elevation, double[] verts2d, double[] bulges, double[] widths, int[] segTypes, double thickness, double[] normal, boolean isClosed, double[] planeXform, int segStart, int numSegs) {
            boolean result = false;
            for (IImportSession is : this.d_recipients) {
                result = is.plineProc(elevation, verts2d, bulges, widths, segTypes, thickness, normal, isClosed, planeXform, segStart, numSegs);
            }
            return result;
        }

        @Override
        public void metafileProc(double[] origin, double[] u, double[] v) {
            for (IImportSession is : this.d_recipients) {
                is.metafileProc(origin, u, v);
            }
        }

        @Override
        public boolean circularArcProc(double[] center, double radius, double[] normal, double[] startVector, double sweepAngle, int arcType, double[] extrusion) {
            boolean result = false;
            for (IImportSession is : this.d_recipients) {
                result = is.circularArcProc(center, radius, normal, startVector, sweepAngle, arcType, extrusion);
            }
            return result;
        }

        @Override
        public boolean circularArcProc(double[] firstPoint, double[] secondPoint, double[] thirdPoint, int arcType, double[] extrusion) {
            boolean result = false;
            for (IImportSession is : this.d_recipients) {
                result = is.circularArcProc(firstPoint, secondPoint, thirdPoint, arcType, extrusion);
            }
            return result;
        }

        @Override
        public boolean ellipticalArcProc(double[] center, double[] majorAxis, double majorRadius, double[] minorAxis, double minorRadius, double[] normal, double startAngle, double endAngle, double[] endPointOverrides, int arcType, double[] extrusion) {
            boolean result = false;
            for (IImportSession is : this.d_recipients) {
                result = is.ellipticalArcProc(center, majorAxis, majorRadius, minorAxis, minorRadius, normal, startAngle, endAngle, endPointOverrides, arcType, extrusion);
            }
            return result;
        }

        @Override
        public boolean textProc(double[] position, double[] direction, double[] upVector, String msg, boolean raw, int style, double[] extrusion) {
            boolean result = false;
            for (IImportSession is : this.d_recipients) {
                result = is.textProc(position, direction, upVector, msg, raw, style, extrusion);
            }
            return result;
        }
    }

    public static class Editor {
        public final String desc;
        public final IEditor<IPropertySet> editor;
        public final List<? extends IPropertySet.Prop<?>> props;

        public Editor(String desc, IEditor<IPropertySet> editor, List<? extends IPropertySet.Prop<?>> props) {
            this.desc = desc;
            this.editor = editor;
            this.props = props;
        }
    }

    public static enum Exporter {
        SIMLAB,
        UNKNOWN;

    }
}

