/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.bim;

public enum BIMType {
    UNKNOWN,
    Product,
    Annotation(Product),
    Element,
    BuildingElement(Element),
    Beam(BuildingElement),
    BuildingElementProxy(BuildingElement),
    Chimney(BuildingElement),
    Column(BuildingElement),
    Covering(BuildingElement),
    CurtainWall(BuildingElement),
    Door(BuildingElement),
    Footing(BuildingElement),
    Member(BuildingElement),
    Pile(BuildingElement),
    Plate(BuildingElement),
    Railing(BuildingElement),
    Ramp(BuildingElement),
    RampFlight(BuildingElement),
    Roof(BuildingElement),
    ShadingDevice(BuildingElement),
    Slab(BuildingElement),
    Stair(BuildingElement),
    StairFlight(BuildingElement),
    Wall(BuildingElement),
    Window(BuildingElement),
    CivilElement(Element),
    DistributionElement(Element),
    ElementAssembly(Element),
    ElementComponent(Element),
    FeatureElement(Element),
    FeatureElementSubtraction(FeatureElement),
    OpeningElement(FeatureElementSubtraction),
    VoidingFeature(FeatureElementSubtraction),
    FurnishingElement(Element),
    Furniture(FurnishingElement),
    SystemFurnitureElement(FurnishingElement),
    GeographicElement(Element),
    TransportElement(Element),
    VirtualElement(Element),
    Grid(Product),
    Port(Product),
    Proxy(Product),
    SpatialElement(Product),
    ExternSpatialStructureElement(SpatialElement),
    SpatialStructureElement(SpatialElement),
    Building(SpatialStructureElement),
    BuildingStorey(SpatialStructureElement),
    Site(SpatialStructureElement),
    Space(SpatialStructureElement),
    SpatialZone(SpatialElement),
    StructuralActivity(Product),
    StructuralItem(Product);

    public final BIMType parent;

    private BIMType() {
        this(null);
    }

    private BIMType(BIMType parent) {
        this.parent = parent;
    }

    public boolean isDescendentOf(BIMType type) {
        BIMType t = this;
        while (t != null) {
            if (t == type) {
                return true;
            }
            t = t.parent;
        }
        return false;
    }

    public boolean isAncestorOf(BIMType type) {
        return type.isDescendentOf(this);
    }
}

