/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.animate;

import thunderheadeng.animate.AnimSession;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.util.time.IClock;
import thunderheadeng.util.time.WallClock;

public class TimeAnimator
implements IAnimator {
    private final IAnimSession d_session;
    private final IClock d_clock;
    private final boolean d_loop;
    private double d_lastTime = Double.NaN;

    public TimeAnimator(IAnimSession session, boolean loop) {
        this.d_session = session;
        this.d_loop = loop;
        this.d_clock = new WallClock();
        this.updateClock(session);
    }

    private void updateClock(IAnimSession session) {
        double[] trange = (double[])session.get(AnimSession.TIME_RANGE);
        this.d_clock.setRange(trange[0], trange[1]);
        switch ((IAnimSession.State)((Object)session.get(AnimSession.STATE))) {
            case PAUSED: {
                this.d_clock.pause();
                break;
            }
            case PLAYING: {
                this.d_clock.resume();
            }
        }
        this.d_clock.setScale((Double)session.get(AnimSession.TIME_SCALE));
        double sessiont = (Double)session.get(AnimSession.TIME);
        if (sessiont != this.d_lastTime) {
            this.d_clock.setTime(sessiont);
        }
    }

    @Override
    public boolean update(IAnimSession session) {
        this.updateClock(session);
        double newTime = this.getTime();
        session.set(AnimSession.TIME, newTime);
        this.d_lastTime = newTime;
        return !this.isClockRunning(session);
    }

    private double getTime() {
        IClock clock = this.d_clock;
        boolean reverse = clock.getScale() < 0.0;
        double newTime = clock.getTime();
        double[] timeRange = this.d_session.get(IAnimSession.TIME_RANGE);
        if (!reverse && newTime >= timeRange[1]) {
            if (this.d_loop) {
                double trange = timeRange[1] - timeRange[0];
                double t = (newTime - timeRange[0]) / trange;
                t -= Math.floor(t);
                newTime = timeRange[0] + t * trange;
            } else {
                newTime = timeRange[1];
            }
            clock.setTime(newTime);
        } else if (reverse && newTime < timeRange[0]) {
            if (this.d_loop) {
                double trange = timeRange[1] - timeRange[0];
                double t = (timeRange[1] - newTime) / trange;
                t -= Math.floor(t);
                newTime = timeRange[1] - t * trange;
            } else {
                newTime = timeRange[0];
            }
            clock.setTime(newTime);
        }
        return newTime;
    }

    private boolean isClockRunning(IAnimSession session) {
        IClock clock = this.d_clock;
        if (clock.isPaused()) {
            return false;
        }
        if (this.d_loop) {
            return true;
        }
        double t = session.get(IAnimSession.TIME);
        double[] timeRange = this.d_session.get(IAnimSession.TIME_RANGE);
        boolean reverse = clock.getScale() < 0.0;
        return !reverse && t < timeRange[1] || reverse && t > timeRange[0];
    }
}

