/*
 * Decompiled with CFR 0.152.
 */
package com.reprisesoftware.rlm;

import com.reprisesoftware.rlm.RlmActHandle;
import com.reprisesoftware.rlm.RlmAvailableProduct;
import com.reprisesoftware.rlm.RlmConstants;
import com.reprisesoftware.rlm.RlmException;
import java.util.Vector;

public class RlmHandle
implements RlmConstants {
    private long handle;
    private boolean previouslyActivated;
    private static final String defaultLibName = "rlm1212";

    private static native void rlmPutenv(String var0);

    private native long rlmInit(String var1, String var2, String var3);

    private native long rlmInitDisconn(String var1, String var2, String var3, int var4);

    private native int rlmClose(long var1);

    private native int rlmStat(long var1);

    private native int rlmHostID(long var1, int var3, byte[] var4);

    private native void rlmAllHostIDs(long var1, int var3, byte[] var4);

    private native int rlmRlog(long var1, String var3);

    private native int rlmDlog(long var1, String var3);

    private native int rlmDetachedDemo(long var1, int var3, String var4);

    private native int rlmDetachedDemoX(long var1, String var3, String var4);

    private native void rlmDiagnostics(long var1, String var3);

    private native long rlmProducts(long var1, String var3, String var4);

    private native void rlmProductFirst(long var1);

    private native int rlmProductNext(long var1);

    private native String rlmProductName(long var1);

    private native String rlmProductVersion(long var1);

    private native String rlmProductActKey(long var1);

    private native int rlmProductCount(long var1);

    private native String rlmProductContract(long var1);

    private native String rlmProductCustomer(long var1);

    private native int rlmProductCurrentInUse(long var1);

    private native int rlmProductCurrentResUse(long var1);

    private native int rlmProductExpDays(long var1);

    private native String rlmProductExpiration(long var1);

    private native int rlmProductHostBased(long var1);

    private native String rlmProductHostId(long var1);

    private native int rlmProductHold(long var1);

    private native int rlmProductIsRoaming(long var1);

    private native String rlmProductIssuer(long var1);

    private native int rlmMaxRoam(long var1);

    private native int rlmMaxRoamCount(long var1);

    private native int rlmMaxShare(long var1);

    private native int rlmMinRemove(long var1);

    private native int rlmMinCheckout(long var1);

    private native int rlmMinTimeout(long var1);

    private native int rlmNRes(long var1);

    private native int rlmNRoamAllowed(long var1);

    private native String rlmOptions(long var1);

    private native int rlmCurrentRoam(long var1);

    private native int rlmShare(long var1);

    private native int rlmSoftLimit(long var1);

    private native int rlmTimeout(long var1);

    private native int rlmTimezone(long var1);

    private native int rlmIsTokenBased(long var1);

    private native int rlmType(long var1);

    private native int rlmUserBased(long var1);

    private native int rlmClientCache(long var1);

    private native void rlmSetUser(long var1, String var3);

    private native void rlmSetHost(long var1, String var3);

    private native void rlmSetIsvData(long var1, String var3);

    private native void rlmSkipIsvDown(long var1);

    private native void rlmForgetIsvDown(long var1);

    private native void rlmKeepConn(long var1);

    private native void rlmErrstringNum(int var1, byte[] var2);

    private native void rlmEnableLogging(long var1, int var3);

    private native void rlmSetPassword(long var1, String var3);

    private native void rlmSetRequiredOption(long var1, String var3);

    private native int rlmActRequest(long var1, String var3, String var4, String var5, String var6, String var7, int var8, String var9, byte[] var10);

    private native int rlmActivate(long var1, String var3, String var4, int var5, byte[] var6, long var7);

    private native int rlmActRevoke(long var1, String var3, String var4);

    private native int rlmActRevokeReference(long var1, String var3, String var4);

    private native int rlmActRevokeDisconn(long var1, String var3, String var4, byte[] var5);

    private native int rlmActKeyvalid(long var1, String var3, String var4, String var5);

    private native int rlmActKeyvalidLicense(long var1, String var3, String var4, String var5, byte[] var6);

    private native int rlmGetRehost(long var1, String var3, byte[] var4);

    public void loadLib(String libName) {
        System.loadLibrary(libName);
    }

    private void createHandle(String licLoc, String appPath, String license, String libName, String[] env, int promise) throws RlmException {
        this.loadLib(libName);
        if (env != null) {
            for (int i = 0; i < env.length; ++i) {
                RlmHandle.rlmPutenv(env[i]);
            }
        }
        if (licLoc == null) {
            licLoc = "";
        }
        if (appPath == null) {
            appPath = "";
        }
        if (license == null) {
            license = "";
        }
        this.handle = promise > 0 ? this.rlmInitDisconn(licLoc, appPath, license, promise) : this.rlmInit(licLoc, appPath, license);
        int stat = this.rlmStat(this.handle);
        if (stat != 0 && stat != -102) {
            throw new RlmException(stat, this);
        }
    }

    public RlmHandle(String licLoc, String appPath, String license) throws RlmException {
        this.createHandle(licLoc, appPath, license, defaultLibName, null, 0);
    }

    public RlmHandle(String licLoc, String appPath, String license, int promise) throws RlmException {
        this.createHandle(licLoc, appPath, license, defaultLibName, null, promise);
    }

    public RlmHandle(String licLoc, String appPath, String license, String[] env) throws RlmException {
        this.createHandle(licLoc, appPath, license, defaultLibName, env, 0);
    }

    public RlmHandle(String licLoc, String appPath, String license, String libName) throws RlmException {
        String lib = null;
        lib = libName != null && libName.length() > 0 ? libName : defaultLibName;
        this.createHandle(licLoc, appPath, license, lib, null, 0);
    }

    public RlmHandle(String licLoc, String appPath, String license, String libName, String[] env) throws RlmException {
        String lib = null;
        lib = libName != null && libName.length() > 0 ? libName : defaultLibName;
        this.createHandle(licLoc, appPath, license, lib, env, 0);
    }

    protected long getHandle() {
        return this.handle;
    }

    public void close() {
        if (this.handle != 0L) {
            this.rlmClose(this.handle);
        }
        this.handle = 0L;
    }

    public String getHostID(int type) {
        byte[] buf = new byte[76];
        String hid = null;
        int stat = this.rlmHostID(this.handle, type, buf);
        if (stat == 0) {
            hid = new String(buf);
        }
        return hid;
    }

    public String[] getAllHostIDs(int type) {
        byte[] buf = new byte[1900];
        this.rlmAllHostIDs(this.handle, type, buf);
        String all = new String(buf).trim();
        String[] split = all.split(" ");
        return split;
    }

    public void writeReportLog(String logString) throws RlmException {
        int stat = this.rlmRlog(this.handle, logString);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    public void writeDebugLog(String logString) throws RlmException {
        int stat = this.rlmDlog(this.handle, logString);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    public void createDetachedDemo(int days, String license) throws RlmException {
        int stat = this.rlmDetachedDemo(this.handle, days, license);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    public void removeDetachedDemo(String product, String version) throws RlmException {
        int stat = this.rlmDetachedDemoX(this.handle, product, version);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    private void addProduct(long prodHandle, Vector v, int index) {
        RlmAvailableProduct prod = new RlmAvailableProduct();
        prod.setName(this.rlmProductName(prodHandle));
        prod.setVersion(this.rlmProductVersion(prodHandle));
        prod.setActKey(this.rlmProductActKey(prodHandle));
        prod.setCount(this.rlmProductCount(prodHandle));
        prod.setCurrentInUse(this.rlmProductCurrentInUse(prodHandle));
        prod.setCurrentResUse(this.rlmProductCurrentResUse(prodHandle));
        prod.setContract(this.rlmProductContract(prodHandle));
        prod.setCustomer(this.rlmProductCustomer(prodHandle));
        prod.setExpDays(this.rlmProductExpDays(prodHandle));
        prod.setExpiration(this.rlmProductExpiration(prodHandle));
        prod.setHostBased(this.rlmProductHostBased(prodHandle));
        prod.setHostId(this.rlmProductHostId(prodHandle));
        prod.setHold(this.rlmProductHold(prodHandle));
        prod.setIsRoaming(this.rlmProductIsRoaming(prodHandle));
        prod.setIssuer(this.rlmProductIssuer(prodHandle));
        prod.setMaxRoam(this.rlmMaxRoam(prodHandle));
        prod.setMaxRoamCount(this.rlmMaxRoamCount(prodHandle));
        prod.setMaxShare(this.rlmMaxShare(prodHandle));
        prod.setMinRemove(this.rlmMinRemove(prodHandle));
        prod.setMinCheckout(this.rlmMinCheckout(prodHandle));
        prod.setMinTimeout(this.rlmMinTimeout(prodHandle));
        prod.setNRes(this.rlmNRes(prodHandle));
        prod.setNRoamAllowed(this.rlmNRoamAllowed(prodHandle));
        prod.setOptions(this.rlmOptions(prodHandle));
        prod.setCurrentRoam(this.rlmCurrentRoam(prodHandle));
        prod.setShare(this.rlmShare(prodHandle));
        prod.setSoftLimit(this.rlmSoftLimit(prodHandle));
        prod.setTimeout(this.rlmTimeout(prodHandle));
        prod.setTimezone(this.rlmTimezone(prodHandle));
        prod.setIsTokenBased(this.rlmIsTokenBased(prodHandle));
        prod.setType(this.rlmType(prodHandle));
        prod.setUserBased(this.rlmUserBased(prodHandle));
        prod.setClientCache(this.rlmClientCache(prodHandle));
        prod.setProdHandle(prodHandle);
        prod.setIndex(index);
        v.add(prod);
    }

    public Vector getAvailableProducts(String product, String version) {
        Vector v = null;
        long prodHandle = this.rlmProducts(this.handle, product, version);
        if (prodHandle != 0L) {
            v = new Vector();
            this.rlmProductFirst(prodHandle);
            int i = 0;
            this.addProduct(prodHandle, v, i++);
            while (this.rlmProductNext(prodHandle) == 0) {
                this.addProduct(prodHandle, v, i++);
            }
        }
        return v;
    }

    protected void positionProdHandle(long prodHandle, int index) {
        this.rlmProductFirst(prodHandle);
        for (int i = 0; i < index; ++i) {
            this.rlmProductNext(prodHandle);
        }
    }

    public void setUser(String user) {
        this.rlmSetUser(this.handle, user);
    }

    public void setHost(String host) {
        this.rlmSetHost(this.handle, host);
    }

    public void setIsvData(String isvData) {
        this.rlmSetIsvData(this.handle, isvData);
    }

    public void enableLogging(int enable) {
        this.rlmEnableLogging(this.handle, enable);
    }

    public void setPassword(String password) {
        this.rlmSetPassword(this.handle, password);
    }

    public void setOption(String option) {
        this.rlmSetRequiredOption(this.handle, option);
    }

    public void skipIsvDown() {
        this.rlmSkipIsvDown(this.handle);
    }

    public void forgetIsvDown() {
        this.rlmForgetIsvDown(this.handle);
    }

    public void keepConn() {
        this.rlmKeepConn(this.handle);
    }

    public String actRequest(String url, String isv, String key, String hostidList, String hostName, int count, String extra) throws RlmException {
        int stat;
        byte[] buf = new byte[102400];
        if (isv == null) {
            isv = "";
        }
        if (hostidList == null) {
            hostidList = "";
        }
        if (hostName == null) {
            hostName = "";
        }
        if (extra == null) {
            extra = "";
        }
        if ((stat = this.rlmActRequest(this.handle, url, isv, key, hostidList, hostName, count, extra, buf)) < 0) {
            throw new RlmException(stat, this);
        }
        this.previouslyActivated = stat == 1;
        return new String(buf).trim();
    }

    public String activateLicense(String url, String key, int count, RlmActHandle actHandle) throws RlmException {
        byte[] buf = new byte[102400];
        long ah = actHandle == null ? 0L : actHandle.getHandle();
        int stat = this.rlmActivate(this.handle, url, key, count, buf, ah);
        if (stat < 0) {
            throw new RlmException(stat, this);
        }
        this.previouslyActivated = stat == 1;
        return new String(buf).trim();
    }

    public void revokeLicense(String url, String product) throws RlmException {
        int stat = this.rlmActRevoke(this.handle, url, product);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    public void revokeLicenseReference(String url, String product) throws RlmException {
        int stat = this.rlmActRevokeReference(this.handle, url, product);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    public String disconnectedRevoke(String product) throws RlmException {
        byte[] retval = new byte[1025];
        int stat = this.rlmActRevokeDisconn(this.handle, "", product, retval);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
        return new String(retval).trim();
    }

    public void processDisconnectedRevoke(String url, String verifyCode) throws RlmException {
        int stat = this.rlmActRevokeDisconn(this.handle, url, verifyCode, null);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    public boolean actKeyValid(String url, String actKey, String hostID) throws RlmException {
        int stat = this.rlmActKeyvalid(this.handle, url, actKey, hostID);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
        return true;
    }

    public String actKeyValidLicense(String url, String actKey, String hostID) throws RlmException {
        byte[] buf = new byte[102400];
        int stat = this.rlmActKeyvalidLicense(this.handle, url, actKey, hostID, buf);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
        return new String(buf).trim();
    }

    public boolean previouslyActivated() {
        return this.previouslyActivated;
    }

    public String getRehost(String product) {
        String ret = null;
        byte[] hostid = new byte[77];
        int stat = this.rlmGetRehost(this.handle, product, hostid);
        if (stat == 0) {
            ret = new String(hostid).trim();
        }
        return ret;
    }

    public void doClientSideDiagnostics(String diagFile) {
        this.rlmDiagnostics(this.handle, diagFile);
    }

    protected void finalize() {
        this.close();
    }

    public String getMessageByCode(int code) {
        String ret = null;
        byte[] errString = new byte[513];
        this.rlmErrstringNum(code, errString);
        ret = new String(errString).trim();
        return ret;
    }
}

