/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import javolution.lang.Reusable;
import javolution.xml.ConstructorHandler;
import javolution.xml.XmlException;
import javolution.xml.sax.RealtimeParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ObjectReader
implements Reusable {
    private final RealtimeParser _parser = new RealtimeParser();
    private final ConstructorHandler _handler = new ConstructorHandler();

    public ObjectReader() {
        this._parser.setContentHandler(this._handler);
    }

    public void reset() {
        this._handler.reset();
        this._parser.reset();
        this._parser.setContentHandler(this._handler);
    }

    public Object read(Reader reader) throws XmlException {
        try {
            this._parser.parse(reader);
            return this._handler.getRoot();
        }
        catch (SAXParseException sAXParseException) {
            String string = sAXParseException.getMessage() + " (" + "line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ")";
            throw new XmlException(string);
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }

    public Object read(InputStream inputStream) throws XmlException {
        try {
            this._parser.parse(inputStream);
            return this._handler.getRoot();
        }
        catch (SAXParseException sAXParseException) {
            String string = sAXParseException.getMessage() + " (" + "line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ")";
            throw new XmlException(string);
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }

    public Object read(ByteBuffer byteBuffer) throws XmlException {
        try {
            this._parser.parse(byteBuffer);
            return this._handler.getRoot();
        }
        catch (SAXParseException sAXParseException) {
            String string = sAXParseException.getMessage() + " (" + "line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ")";
            throw new XmlException(string);
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }
}

