/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javolution.realtime.ObjectPool;
import javolution.realtime.Realtime;
import javolution.realtime.RealtimeObject;
import javolution.util.FastCollection;

public class FastList
extends FastCollection
implements List,
Serializable {
    private transient ObjectPool _nodes;
    private FastList _parent;
    private Node _start;
    private Node _end;
    private int _size;
    private final FastListIterator _fastIterator = new FastListIterator();
    private static final RealtimeObject.Factory LIST_FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new FastList();
        }

        public void cleanup(Object object) {
            FastList fastList = (FastList)object;
            Node node = fastList._start;
            Node node2 = fastList._end;
            Node node3 = node;
            while (node3 != node2) {
                node3 = node3._next;
                node3._element = null;
            }
            node._next = node2;
            node2._previous = node;
            fastList._size = 0;
        }
    };
    private static final RealtimeObject.Factory SUBLIST_FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new FastList(null, null);
        }
    };
    private static final RealtimeObject.Factory NODE_FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new Node();
        }
    };
    private static final RealtimeObject.Factory ITERATOR_FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new FastListIterator();
        }
    };
    private static final long serialVersionUID = 3978424741055181621L;

    public FastList() {
        this._start = new Node();
        this._end = new Node();
        this._start._next = this._end;
        this._end._previous = this._start;
    }

    private FastList(Node node, Node node2) {
        this._start = node;
        this._end = node2;
    }

    public static FastList newInstance() {
        FastList fastList = (FastList)LIST_FACTORY.object();
        ObjectPool objectPool = NODE_FACTORY.currentPool();
        fastList._nodes = objectPool == NODE_FACTORY.heap() ? null : objectPool;
        return fastList;
    }

    public final Iterator fastIterator() {
        this._fastIterator._list = this;
        this._fastIterator._nextNode = this._start._next;
        this._fastIterator._currentNode = null;
        this._fastIterator._nextIndex = 0;
        this._fastIterator._length = this._size;
        return this._fastIterator;
    }

    public int size() {
        return this._size;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public boolean add(Object object) {
        this.addBefore(this._end, object);
        return true;
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.removeLast();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        FastListIterator fastListIterator = (FastListIterator)this.iterator();
        Iterator iterator = ((List)object).iterator();
        while (fastListIterator.hasNext() && iterator.hasNext()) {
            Object object2 = fastListIterator.next();
            Object e = iterator.next();
            if (object2 != null ? object2.equals(e) : e == null) continue;
            return false;
        }
        return !fastListIterator.hasNext() && !iterator.hasNext();
    }

    public int hashCode() {
        int n = 1;
        Node node = this._start._next;
        while (node != this._end) {
            Object object = node._element;
            n = 31 * n + (object == null ? 0 : object.hashCode());
            node = node._next;
        }
        return n;
    }

    public Object get(int n) {
        if (n >= 0 && n < this._size) {
            return this.nodeAt(n)._element;
        }
        throw new IndexOutOfBoundsException("index: " + n + " for list of size: " + this._size);
    }

    public Object set(int n, Object object) {
        if (n >= 0 && n < this._size) {
            Node node = this.nodeAt(n);
            Object object2 = node._element;
            node._element = object;
            return object2;
        }
        throw new IndexOutOfBoundsException("index: " + n + " for list of size: " + this._size);
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n + " for list of size: " + this._size);
        }
        this.addBefore(this.nodeAt(n), object);
    }

    public boolean addAll(int n, Collection collection) {
        List list = this.subList(0, n);
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
            bl = true;
        }
        return bl;
    }

    public Object remove(int n) {
        if (n >= 0 && n < this._size) {
            Node node = this.nodeAt(n);
            Object object = node._element;
            this.removeNode(node);
            return object;
        }
        throw new IndexOutOfBoundsException("index: " + n + " for list of size: " + this._size);
    }

    public int indexOf(Object object) {
        Node node = this._start._next;
        if (object != null) {
            for (int i = 0; i < this._size; ++i) {
                if (object.equals(node._element)) {
                    return i;
                }
                node = node._next;
            }
        } else {
            for (int i = 0; i < this._size; ++i) {
                if (node._element == null) {
                    return i;
                }
                node = node._next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        Node node = this._end._previous;
        if (object != null) {
            for (int i = this._size - 1; i >= 0; --i) {
                if (object.equals(node._element)) {
                    return i;
                }
                node = node._previous;
            }
        } else {
            for (int i = this._size - 1; i >= 0; --i) {
                if (node._element == null) {
                    return i;
                }
                node = node._previous;
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        FastListIterator fastListIterator = (FastListIterator)ITERATOR_FACTORY.object();
        fastListIterator._list = this;
        fastListIterator._nextNode = this._start._next;
        fastListIterator._currentNode = null;
        fastListIterator._nextIndex = 0;
        fastListIterator._length = this._size;
        return fastListIterator;
    }

    public ListIterator listIterator(int n) {
        if (n >= 0 && n < this._size) {
            FastListIterator fastListIterator = (FastListIterator)this.listIterator();
            fastListIterator._nextNode = this.nodeAt(n);
            fastListIterator._nextIndex = n;
            return fastListIterator;
        }
        throw new IndexOutOfBoundsException("index: " + n + " for list of size: " + this._size);
    }

    public List subList(int n, int n2) {
        if (n >= 0 && n2 <= this._size && n <= n2) {
            FastList fastList = (FastList)SUBLIST_FACTORY.object();
            fastList._parent = this;
            fastList._start = this.nodeAt(n)._previous;
            fastList._end = this.nodeAt(n2);
            fastList._size = n2 - n;
            return fastList;
        }
        throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
    }

    public Object getFirst() {
        if (this._size != 0) {
            return this._start._next._element;
        }
        throw new NoSuchElementException();
    }

    public Object getLast() {
        if (this._size != 0) {
            return this._end._previous._element;
        }
        throw new NoSuchElementException();
    }

    public void addFirst(Object object) {
        this.addBefore(this._start._next, object);
    }

    public void addLast(Object object) {
        this.addBefore(this._end, object);
    }

    public Object removeFirst() {
        if (this._size != 0) {
            Object object = this._start._next._element;
            this.removeNode(this._start._next);
            return object;
        }
        throw new NoSuchElementException();
    }

    public Object removeLast() {
        if (this._size != 0) {
            Object object = this._end._previous._element;
            this.removeNode(this._end._previous);
            return object;
        }
        throw new NoSuchElementException();
    }

    private void addBefore(Node node, Object object) {
        ++this._size;
        if (this._parent == null) {
            Node node2 = this.newNode();
            Node node3 = node._previous;
            node2._element = object;
            node2._next = node;
            node2._previous = node3;
            node3._next = node2;
            node._previous = node2;
        } else {
            this._parent.addBefore(node, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node newNode() {
        if (this._nodes != null) {
            if (this._nodes.isLocal()) {
                return (Node)this._nodes.next();
            }
            ObjectPool objectPool = this._nodes;
            synchronized (objectPool) {
                return (Node)this._nodes.next();
            }
        }
        return new Node();
    }

    private void removeNode(Node node) {
        --this._size;
        if (this._parent == null) {
            node._previous._next = node._next;
            node._next._previous = node._previous;
            node._element = null;
            this.recycleNode(node);
        } else {
            this._parent.removeNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleNode(Node node) {
        if (this._nodes != null) {
            if (this._nodes.isLocal()) {
                this._nodes.recycle(node);
            } else {
                ObjectPool objectPool = this._nodes;
                synchronized (objectPool) {
                    this._nodes.recycle(node);
                }
            }
        }
    }

    private Node nodeAt(int n) {
        if (n <= this._size >> 1) {
            Node node = this._start;
            int n2 = n;
            while (n2-- >= 0) {
                node = node._next;
            }
            return node;
        }
        Node node = this._end;
        int n3 = this._size - n;
        while (n3-- > 0) {
            node = node._previous;
        }
        return node;
    }

    public void move(Realtime.ContextSpace contextSpace) {
        super.move(contextSpace);
        if (this._parent == null) {
            Node node = this._start;
            while (node != this._end) {
                node.move(contextSpace);
                node = node._next;
            }
            this._end.move(contextSpace);
            if (contextSpace == Realtime.ContextSpace.OUTER) {
                this._nodes = this._nodes.getOuter();
            } else if (contextSpace == Realtime.ContextSpace.HEAP) {
                this._nodes = null;
            }
        } else {
            this._parent.move(contextSpace);
        }
    }

    private static final class FastListIterator
    extends RealtimeObject
    implements ListIterator {
        private FastList _list;
        private Node _nextNode;
        private Node _currentNode;
        private int _length;
        private int _nextIndex;

        private FastListIterator() {
        }

        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        public Object next() {
            if (this._nextIndex++ != this._length) {
                this._currentNode = this._nextNode;
                this._nextNode = this._nextNode._next;
                return this._currentNode._element;
            }
            --this._nextIndex;
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this._nextIndex;
        }

        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        public Object previous() {
            if (this._nextIndex-- != 0) {
                this._nextNode = this._currentNode = this._nextNode._previous;
                return this._currentNode._element;
            }
            ++this._nextIndex;
            throw new NoSuchElementException();
        }

        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void add(Object object) {
            this._list.addBefore(this._nextNode, object);
            ++this._length;
            this._currentNode = null;
            ++this._nextIndex;
        }

        public void set(Object object) {
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._element = object;
        }

        public void remove() {
            if (this._currentNode != null) {
                if (this._nextNode == this._currentNode) {
                    this._nextNode = this._nextNode._next;
                } else {
                    --this._nextIndex;
                }
                this._list.removeNode(this._currentNode);
                this._currentNode = null;
                --this._length;
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private static final class Node
    extends RealtimeObject
    implements Serializable {
        private Object _element;
        private Node _next;
        private Node _previous;
        private static final long serialVersionUID = -9081362293021515482L;

        private Node() {
        }

        public void move(Realtime.ContextSpace contextSpace) {
            super.move(contextSpace);
            if (this._element instanceof Realtime) {
                ((Realtime)this._element).move(contextSpace);
            }
        }
    }
}

