/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.Collection;
import java.util.Iterator;
import javolution.lang.Text;
import javolution.lang.TextBuilder;
import javolution.realtime.RealtimeObject;

public abstract class FastCollection
extends RealtimeObject
implements Collection {
    protected FastCollection() {
    }

    public abstract Iterator fastIterator();

    public abstract Iterator iterator();

    public abstract int size();

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        if (object != null) {
            Iterator iterator = this.iterator();
            int n = this.size();
            while (--n >= 0) {
                if (!object.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
            return false;
        }
        return this.removeNull();
    }

    private boolean removeNull() {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (iterator.next() != null) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        if (object != null) {
            Iterator iterator = this.iterator();
            int n = this.size();
            while (--n >= 0) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
            return false;
        }
        return this.containsNull();
    }

    private boolean containsNull() {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (iterator.next() != null) continue;
            return true;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            throw new UnsupportedOperationException("Destination array too small");
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        Iterator iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }

    public Text toText() {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append('[');
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            textBuilder.append(iterator.next());
            if (n == 0) continue;
            textBuilder.append(", ");
        }
        textBuilder.append(']');
        return textBuilder.toText();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Collection && ((Collection)object).size() == this.size() && this.containsAll((Collection)object);
    }

    public int hashCode() {
        Iterator iterator = this.iterator();
        int n = 0;
        int n2 = this.size();
        while (--n2 >= 0) {
            Object e = iterator.next();
            n += e == null ? 0 : e.hashCode();
        }
        return n;
    }
}

