/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.Configuration;
import javolution.realtime.Context;
import javolution.realtime.DefaultPool;
import javolution.realtime.ObjectPool;
import javolution.realtime.PoolContext;

public abstract class ObjectFactory {
    public static final int MAX = Configuration.factories();
    static ObjectFactory[] INSTANCES = new ObjectFactory[MAX];
    static volatile int Count;
    private final int _index;
    private final Heap _heap = new Heap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectFactory() {
        ObjectFactory[] objectFactoryArray = INSTANCES;
        synchronized (INSTANCES) {
            if (Count >= MAX) {
                throw new UnsupportedOperationException("Maximum number of factories (system property \"javolution.factories\", value " + MAX + ") has been reached");
            }
            ObjectFactory.INSTANCES[ObjectFactory.Count] = this;
            this._index = Count++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public abstract Object create();

    public Object object() {
        PoolContext poolContext = Context.currentContext().poolContext();
        return poolContext != null ? poolContext.getLocalPool(this._index).next() : this.create();
    }

    public void cleanup(Object object) {
        throw new UnsupportedOperationException();
    }

    public final ObjectPool currentPool() {
        PoolContext poolContext = Context.currentContext().poolContext();
        return poolContext != null ? poolContext.getLocalPool(this._index) : this._heap;
    }

    public final ObjectPool heap() {
        return this._heap;
    }

    protected ObjectPool newPool() {
        return new DefaultPool(this);
    }

    private final class Heap
    extends ObjectPool {
        private Heap() {
        }

        public Object next() {
            return ObjectFactory.this.create();
        }

        public void recycle(Object object) {
        }

        public void export(Object object) {
        }

        public void remove(Object object) {
        }

        protected void recycleAll() {
        }

        protected void clearAll() {
        }
    }
}

