/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Map;
import javolution.realtime.ConcurrentThread;
import javolution.realtime.HeapContext;
import javolution.realtime.PoolContext;
import javolution.util.FastMap;

public abstract class Context {
    private static FastMap Roots = new FastMap();
    private static Context LastEntered = new HeapContext();
    private Thread _owner = Thread.currentThread();
    private PoolContext _poolContext;
    private Context _outer;
    private Context _inner;
    private boolean _isCurrent;
    private static final Object LOCK;

    protected Context() {
        if (this instanceof PoolContext) {
            this._poolContext = (PoolContext)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object;
        Context context = Context.currentContext();
        if (context._outer == null) {
            object = new FastMap(Roots.size());
            Object object2 = LOCK;
            synchronized (object2) {
                Context.copyAliveOnly(Roots, (FastMap)object);
                ((FastMap)object).remove(context._owner);
                Roots = object;
            }
        } else if (context._outer._inner == context) {
            context._outer._inner = null;
        }
        object = context;
        while (object != null) {
            ((Context)object).dispose();
            ((Context)object)._owner = null;
            object = ((Context)object)._inner;
        }
    }

    private static void copyAliveOnly(FastMap fastMap, FastMap fastMap2) {
        Iterator iterator = fastMap.fastEntriesIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Thread thread = (Thread)entry.getKey();
            if (!thread.isAlive()) continue;
            fastMap2.put(thread, entry.getValue());
        }
    }

    protected static Context currentContext() {
        Thread thread = Thread.currentThread();
        Context context = LastEntered;
        return context._owner == thread ? context : Context.currentContext(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Context currentContext(Thread thread) {
        Context context = (Context)Roots.get(thread);
        if (context != null) {
            if (context._isCurrent) {
                return context;
            }
            do {
                context = context._inner;
            } while (!context._isCurrent);
            return context;
        }
        context = thread instanceof ConcurrentThread ? new PoolContext() : new HeapContext();
        FastMap fastMap = new FastMap(Roots.size());
        Object object = LOCK;
        synchronized (object) {
            Context.copyAliveOnly(Roots, fastMap);
            fastMap.put(context._owner, context);
            Roots = fastMap;
        }
        context._isCurrent = true;
        LastEntered = context;
        return context;
    }

    protected final Thread getOwner() {
        return this._owner;
    }

    protected final Context getOuter() {
        return this._outer;
    }

    protected final Context getInner() {
        return this._inner;
    }

    protected static Context push(Class clazz) {
        Context context = Context.currentContext();
        Context context2 = context._inner;
        if (clazz.isInstance(context2)) {
            context._isCurrent = false;
            context2._isCurrent = true;
            LastEntered = context2;
            return context2;
        }
        while (context2 != null) {
            Context context3;
            context2 = context2._inner;
            if (!clazz.isInstance(context2)) continue;
            context2._outer._inner = context3 = context2._inner;
            if (context3 != null) {
                context3._outer = context2._outer;
            }
            Context.push(context2);
            return context2;
        }
        return null;
    }

    protected static void push(Context context) {
        Context context2;
        context._outer = context2 = Context.currentContext();
        context._inner = context._outer._inner;
        context._outer._inner = context;
        if (context._inner != null) {
            context._inner._outer = context;
        }
        context2._isCurrent = false;
        context._isCurrent = true;
        LastEntered = context;
        if (!(context instanceof PoolContext) && !(context instanceof HeapContext)) {
            context._poolContext = context._outer._poolContext;
        }
    }

    protected static Context pop() {
        Context context = Context.currentContext();
        context._isCurrent = false;
        if (context._outer != null && context._outer._owner == Thread.currentThread()) {
            context._outer._isCurrent = true;
            LastEntered = context._outer;
            return context;
        }
        throw new EmptyStackException();
    }

    protected abstract void dispose();

    final PoolContext poolContext() {
        return this._poolContext;
    }

    final void setOuter(Context context) {
        this._outer = context;
    }

    static {
        Context.LastEntered._isCurrent = true;
        Roots.put(Context.LastEntered._owner, LastEntered);
        LOCK = new Object();
    }
}

