/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.JavolutionError;
import javolution.realtime.ConcurrentException;
import javolution.realtime.ConcurrentThread;
import javolution.realtime.Context;
import javolution.realtime.LocalContext;
import javolution.realtime.PoolContext;

public final class ConcurrentContext
extends Context {
    private static final int QUEUE_SIZE = 256;
    private static final int ARGS_SIZE = 6;
    private Logic[] _logics = new Logic[256];
    private Object[][] _args = new Object[256][];
    private Object[][][] _argsPool = new Object[256][6][];
    private int _logicsCount;
    private static final LocalContext.Variable ENABLED = new LocalContext.Variable(new Boolean(true));
    private int _concurrency;
    private int _threadsDone;
    private Throwable _error;
    private static final Class CONCURRENT_CONTEXT_CLASS = new ConcurrentContext().getClass();

    ConcurrentContext() {
    }

    public static void setEnabled(boolean bl) {
        ENABLED.setValue(new Boolean(bl));
    }

    public static boolean isEnabled() {
        return (Boolean)ENABLED.getValue();
    }

    public static void enter() {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.push(CONCURRENT_CONTEXT_CLASS);
        if (concurrentContext == null) {
            concurrentContext = new ConcurrentContext();
            Context.push(concurrentContext);
        }
    }

    public static void execute(Logic logic) {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.currentContext();
        if (concurrentContext._logicsCount >= 256) {
            concurrentContext.flush();
        }
        concurrentContext._args[concurrentContext._logicsCount] = Logic.NO_ARG;
        concurrentContext._logics[concurrentContext._logicsCount++] = logic;
    }

    public static void execute(Logic logic, Object object) {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.currentContext();
        if (concurrentContext._logicsCount >= 256) {
            concurrentContext.flush();
        }
        Object[] objectArray = concurrentContext.getArgs(1);
        objectArray[0] = object;
        concurrentContext._logics[concurrentContext._logicsCount++] = logic;
    }

    public static void execute(Logic logic, Object object, Object object2) {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.currentContext();
        if (concurrentContext._logicsCount >= 256) {
            concurrentContext.flush();
        }
        Object[] objectArray = concurrentContext.getArgs(2);
        objectArray[0] = object;
        objectArray[1] = object2;
        concurrentContext._logics[concurrentContext._logicsCount++] = logic;
    }

    public static void execute(Logic logic, Object object, Object object2, Object object3) {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.currentContext();
        if (concurrentContext._logicsCount >= 256) {
            concurrentContext.flush();
        }
        Object[] objectArray = concurrentContext.getArgs(3);
        objectArray[0] = object;
        objectArray[1] = object2;
        objectArray[2] = object3;
        concurrentContext._logics[concurrentContext._logicsCount++] = logic;
    }

    public static void execute(Logic logic, Object object, Object object2, Object object3, Object object4) {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.currentContext();
        if (concurrentContext._logicsCount >= 256) {
            concurrentContext.flush();
        }
        Object[] objectArray = concurrentContext.getArgs(4);
        objectArray[0] = object;
        objectArray[1] = object2;
        objectArray[2] = object3;
        objectArray[3] = object4;
        concurrentContext._logics[concurrentContext._logicsCount++] = logic;
    }

    public static void execute(Logic logic, Object object, Object object2, Object object3, Object object4, Object object5) {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.currentContext();
        if (concurrentContext._logicsCount >= 256) {
            concurrentContext.flush();
        }
        Object[] objectArray = concurrentContext.getArgs(5);
        objectArray[0] = object;
        objectArray[1] = object2;
        objectArray[2] = object3;
        objectArray[3] = object4;
        objectArray[4] = object5;
        concurrentContext._logics[concurrentContext._logicsCount++] = logic;
    }

    public static void execute(Logic logic, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.currentContext();
        if (concurrentContext._logicsCount >= 256) {
            concurrentContext.flush();
        }
        Object[] objectArray = concurrentContext.getArgs(6);
        objectArray[0] = object;
        objectArray[1] = object2;
        objectArray[2] = object3;
        objectArray[3] = object4;
        objectArray[4] = object5;
        objectArray[5] = object6;
        concurrentContext._logics[concurrentContext._logicsCount++] = logic;
    }

    public static void exit() throws ConcurrentException {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.currentContext();
        concurrentContext.flush();
        Context.pop();
        if (concurrentContext._error != null) {
            ConcurrentException concurrentException = new ConcurrentException(concurrentContext._error);
            concurrentContext._error = null;
            throw concurrentException;
        }
    }

    synchronized void setError(Throwable throwable) {
        if (this._error == null) {
            this._error = throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeNext() {
        Object[] objectArray = this;
        synchronized (this) {
            if (this._logicsCount <= 0) {
                ++this._threadsDone;
                this.notify();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            int n = --this._logicsCount;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            try {
                objectArray = this._args[n];
                this._logics[n].run(objectArray);
                this._logics[n] = null;
                int n2 = objectArray.length;
                while (n2 > 0) {
                    objectArray[--n2] = null;
                }
            }
            catch (Throwable throwable) {
                this.setError(throwable);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        PoolContext.enter();
        try {
            int n = this._concurrency = ConcurrentContext.isEnabled() ? ConcurrentThread.execute(this) : 0;
            while (this.executeNext()) {
                ((PoolContext)Context.currentContext()).recyclePools();
            }
            ConcurrentContext concurrentContext = this;
            synchronized (concurrentContext) {
                while (this._threadsDone <= this._concurrency) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new JavolutionError(interruptedException);
        }
        finally {
            this._threadsDone = 0;
            PoolContext.exit();
        }
    }

    private Object[] getArgs(int n) {
        Object[] objectArray = this._argsPool[this._logicsCount][n - 1];
        if (objectArray == null) {
            objectArray = new Object[n];
            this._argsPool[this._logicsCount][n - 1] = objectArray;
        }
        this._args[this._logicsCount] = objectArray;
        return objectArray;
    }

    protected void dispose() {
        this._logics = null;
        this._args = null;
        this._argsPool = null;
    }

    public static abstract class Logic
    implements Runnable {
        private static final Object[] NO_ARG = new Object[0];

        public final void run() {
            this.run(NO_ARG);
        }

        public abstract void run(Object[] var1);
    }
}

