/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.realtime.ObjectFactory;
import javolution.realtime.ObjectPool;

public final class ArrayPool {
    public static final int MIN_LENGTH = 16;
    private static final ObjectsFactory[] OBJECTS_FACTORIES;
    private static final BytesFactory[] BYTES_FACTORIES;
    private static final CharsFactory[] CHARS_FACTORIES;
    private static final IntsFactory[] INTS_FACTORIES;
    private static final LongsFactory[] LONGS_FACTORIES;
    private static final FloatsFactory[] FLOATS_FACTORIES;
    private static final DoublesFactory[] DOUBLES_FACTORIES;
    private static final int[] INDEX_FOR;
    private static final Object[] NULL_1024;

    private ArrayPool() {
    }

    public static ObjectPool objectArray(int n) {
        return OBJECTS_FACTORIES[ArrayPool.indexFor(n)].currentPool();
    }

    public static ObjectPool byteArray(int n) {
        return BYTES_FACTORIES[ArrayPool.indexFor(n)].currentPool();
    }

    public static ObjectPool charArray(int n) {
        return CHARS_FACTORIES[ArrayPool.indexFor(n)].currentPool();
    }

    public static ObjectPool intArray(int n) {
        return INTS_FACTORIES[ArrayPool.indexFor(n)].currentPool();
    }

    public static ObjectPool longArray(int n) {
        return LONGS_FACTORIES[ArrayPool.indexFor(n)].currentPool();
    }

    public static ObjectPool floatArray(int n) {
        return FLOATS_FACTORIES[ArrayPool.indexFor(n)].currentPool();
    }

    public static ObjectPool doubleArray(int n) {
        return DOUBLES_FACTORIES[ArrayPool.indexFor(n)].currentPool();
    }

    public static int indexFor(int n) {
        return n < INDEX_FOR.length ? INDEX_FOR[n] : ArrayPool.indexFor2(n);
    }

    private static int indexFor2(int n) {
        int n2 = 0;
        while (n > 16 << n2) {
            ++n2;
        }
        return n2;
    }

    public static void clear(Object[] objectArray, int n, int n2) {
        if (n2 < 32) {
            int n3 = n + n2;
            while (n3 > n) {
                objectArray[--n3] = null;
            }
        } else {
            for (int i = n2 - 1024; i >= 0; i -= 1024) {
                System.arraycopy(NULL_1024, 0, objectArray, i + n, 1024);
            }
            System.arraycopy(NULL_1024, 0, objectArray, n, n2 & 0x3FF);
        }
    }

    static {
        int n;
        OBJECTS_FACTORIES = new ObjectsFactory[28];
        for (n = 0; n < OBJECTS_FACTORIES.length; ++n) {
            ArrayPool.OBJECTS_FACTORIES[n] = new ObjectsFactory(16 << n);
        }
        BYTES_FACTORIES = new BytesFactory[28];
        for (n = 0; n < BYTES_FACTORIES.length; ++n) {
            ArrayPool.BYTES_FACTORIES[n] = new BytesFactory(16 << n);
        }
        CHARS_FACTORIES = new CharsFactory[28];
        for (n = 0; n < CHARS_FACTORIES.length; ++n) {
            ArrayPool.CHARS_FACTORIES[n] = new CharsFactory(16 << n);
        }
        INTS_FACTORIES = new IntsFactory[28];
        for (n = 0; n < INTS_FACTORIES.length; ++n) {
            ArrayPool.INTS_FACTORIES[n] = new IntsFactory(16 << n);
        }
        LONGS_FACTORIES = new LongsFactory[28];
        for (n = 0; n < LONGS_FACTORIES.length; ++n) {
            ArrayPool.LONGS_FACTORIES[n] = new LongsFactory(16 << n);
        }
        FLOATS_FACTORIES = new FloatsFactory[28];
        for (n = 0; n < FLOATS_FACTORIES.length; ++n) {
            ArrayPool.FLOATS_FACTORIES[n] = new FloatsFactory(16 << n);
        }
        DOUBLES_FACTORIES = new DoublesFactory[28];
        for (n = 0; n < DOUBLES_FACTORIES.length; ++n) {
            ArrayPool.DOUBLES_FACTORIES[n] = new DoublesFactory(16 << n);
        }
        INDEX_FOR = new int[1025];
        n = INDEX_FOR.length;
        while (n > 0) {
            ArrayPool.INDEX_FOR[--n] = ArrayPool.indexFor2(n);
        }
        NULL_1024 = new Object[1024];
    }

    private static final class DoublesFactory
    extends ObjectFactory {
        private final int _length;

        private DoublesFactory(int n) {
            this._length = n;
        }

        public Object create() {
            return new double[this._length];
        }
    }

    private static final class FloatsFactory
    extends ObjectFactory {
        private final int _length;

        private FloatsFactory(int n) {
            this._length = n;
        }

        public Object create() {
            return new float[this._length];
        }
    }

    private static final class LongsFactory
    extends ObjectFactory {
        private final int _length;

        private LongsFactory(int n) {
            this._length = n;
        }

        public Object create() {
            return new long[this._length];
        }
    }

    private static final class IntsFactory
    extends ObjectFactory {
        private final int _length;

        private IntsFactory(int n) {
            this._length = n;
        }

        public Object create() {
            return new int[this._length];
        }
    }

    private static final class CharsFactory
    extends ObjectFactory {
        private final int _length;

        private CharsFactory(int n) {
            this._length = n;
        }

        public Object create() {
            return new char[this._length];
        }
    }

    private static final class BytesFactory
    extends ObjectFactory {
        private final int _length;

        private BytesFactory(int n) {
            this._length = n;
        }

        public Object create() {
            return new byte[this._length];
        }
    }

    private static final class ObjectsFactory
    extends ObjectFactory {
        private final int _length;

        private ObjectsFactory(int n) {
            this._length = n;
        }

        public Object create() {
            return new Object[this._length];
        }
    }
}

