/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.IOException;
import javolution.JavolutionError;
import javolution.lang.Appendable;
import javolution.lang.Text;
import javolution.lang.TextBuilder;
import javolution.realtime.RealtimeObject;

public abstract class TextFormat {
    protected TextFormat() {
    }

    public abstract Appendable format(Object var1, Appendable var2) throws IOException;

    public abstract Object parse(CharSequence var1, Cursor var2);

    public final Text format(Object object) {
        try {
            TextBuilder textBuilder = TextBuilder.newInstance();
            this.format(object, textBuilder);
            return textBuilder.toText();
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final Object parse(CharSequence charSequence) {
        CursorImpl cursorImpl = (CursorImpl)CursorImpl.FACTORY.object();
        cursorImpl.setIndex(0);
        try {
            Object object = this.parse(charSequence, cursorImpl);
            if (cursorImpl.getIndex() == charSequence.length()) {
                Object object2 = object;
                return object2;
            }
            throw new IllegalArgumentException("Parsing of " + charSequence + " incomplete (terminated at index: " + cursorImpl.getIndex() + ")");
        }
        finally {
            CursorImpl.recycle(cursorImpl);
        }
    }

    private static final class CursorImpl
    extends RealtimeObject
    implements Cursor {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new CursorImpl();
            }
        };
        private int _index;

        private CursorImpl() {
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int n) {
            this._index = n;
        }

        public void increment(int n) {
            this._index += n;
        }

        private static void recycle(CursorImpl cursorImpl) {
            cursorImpl.recycle();
        }
    }

    public static interface Cursor {
        public int getIndex();

        public void setIndex(int var1);

        public void increment(int var1);
    }
}

