/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.IOException;
import java.io.Serializable;
import javolution.JavolutionError;
import javolution.lang.Appendable;
import javolution.lang.Text;
import javolution.lang.TypeFormat;
import javolution.realtime.Realtime;
import javolution.realtime.RealtimeObject;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;

public final class TextBuilder
extends RealtimeObject
implements Appendable,
CharSequence,
Serializable {
    protected static final XmlFormat TEXT_BUILDER_XML = new XmlFormat(new TextBuilder().getClass()){

        public void format(Object object, XmlElement xmlElement) {
            xmlElement.setAttribute("text", (CharSequence)((TextBuilder)object));
        }

        public Object parse(XmlElement xmlElement) {
            TextBuilder textBuilder = TextBuilder.newInstance();
            textBuilder.append(xmlElement.getAttribute("text"));
            return textBuilder;
        }
    };
    private Text _head;
    private Text.Primitive _tail;
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new TextBuilder();
        }
    };
    private static final long serialVersionUID = 3258408430636380468L;

    private TextBuilder() {
    }

    public static TextBuilder newInstance() {
        TextBuilder textBuilder = (TextBuilder)FACTORY.object();
        textBuilder._head = Text.EMPTY;
        textBuilder._tail = Text.Primitive.newInstance();
        return textBuilder;
    }

    public int length() {
        return this._head.length() + this._tail.length();
    }

    public char charAt(int n) {
        return n < this._head._count ? this._head.charAt(n) : this._tail.charAt(n - this._head._count);
    }

    public CharSequence subSequence(int n, int n2) {
        return this.toText().subtext(n, n2);
    }

    public Appendable append(char c) {
        if (this._tail._count < 32) {
            this._tail._data[this._tail._count++] = c;
        } else {
            this.flushTail();
            this._tail._data[this._tail._count++] = c;
        }
        return this;
    }

    public TextBuilder append(Object object) {
        if (object instanceof Realtime) {
            return this.append(((Realtime)object).toText());
        }
        if (object != null) {
            return this.append(object.toString());
        }
        return this.append(Text.NULL);
    }

    public TextBuilder append(Text text) {
        if (this._tail._count + text._count <= 32) {
            int n = 0;
            while (n < text._count) {
                this._tail._data[this._tail._count++] = text.charAt(n++);
            }
        } else {
            this.flushTail();
            this._head = this._head.plus(text);
        }
        return this;
    }

    public TextBuilder append(String string) {
        if (this._tail._count + string.length() <= 32) {
            int n = 0;
            while (n < string.length()) {
                this._tail._data[this._tail._count++] = string.charAt(n++);
            }
        } else {
            this.flushTail();
            this._head = this._head.plus(Text.valueOf(string));
        }
        return this;
    }

    public Appendable append(CharSequence charSequence) {
        if (charSequence != null) {
            return this.append(charSequence, 0, charSequence.length());
        }
        return this.append(Text.NULL);
    }

    public Appendable append(CharSequence charSequence, int n, int n2) {
        if (charSequence != null) {
            int n3 = n2 - n;
            if (this._tail._count + n3 <= 32) {
                int n4 = n;
                while (n4 < n2) {
                    this._tail._data[this._tail._count++] = charSequence.charAt(n4++);
                }
            } else {
                this.flushTail();
                this._head = this._head.plus(Text.valueOf(charSequence, n, n2));
            }
            return this;
        }
        return this.append(Text.NULL);
    }

    public TextBuilder append(char[] cArray, int n, int n2) {
        if (this._tail._count + n2 <= 32) {
            int n3 = n;
            while (n3 < n + n2) {
                this._tail._data[this._tail._count++] = cArray[n3++];
            }
        } else {
            this.flushTail();
            this._head = this._head.plus(Text.valueOf(cArray, n, n2));
        }
        return this;
    }

    public TextBuilder append(boolean bl) {
        try {
            TypeFormat.format(bl, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public TextBuilder append(int n) {
        try {
            TypeFormat.format(n, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public TextBuilder append(int n, int n2) {
        try {
            TypeFormat.format(n, n2, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public TextBuilder append(long l) {
        try {
            TypeFormat.format(l, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public TextBuilder append(long l, int n) {
        try {
            TypeFormat.format(l, n, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public TextBuilder append(float f) {
        try {
            TypeFormat.format(f, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public TextBuilder append(double d) {
        try {
            TypeFormat.format(d, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public TextBuilder insert(int n, char c) {
        this.flushTail();
        Text text = this._head.subtext(0, n);
        Text text2 = this._head.subtext(n);
        this._head = text.plus(Text.valueOf(c)).plus(text2);
        return this;
    }

    public TextBuilder insert(int n, CharSequence charSequence) {
        this.flushTail();
        Text text = this._head.subtext(0, n);
        Text text2 = this._head.subtext(n);
        this._head = text.plus(Text.valueOf(charSequence)).plus(text2);
        return this;
    }

    public TextBuilder insert(int n, char[] cArray, int n2, int n3) {
        this.flushTail();
        Text text = this._head.subtext(0, n);
        Text text2 = this._head.subtext(n);
        this._head = text.plus(Text.valueOf(cArray, n2, n3)).plus(text2);
        return this;
    }

    public TextBuilder deleteCharAt(int n) {
        return this.delete(n, n + 1);
    }

    public TextBuilder delete(int n, int n2) {
        this.flushTail();
        Text text = this._head.subtext(0, n);
        Text text2 = this._head.subtext(n2);
        this._head = text.plus(text2);
        return this;
    }

    public void setCharAt(int n, char c) {
        this.flushTail();
        Text text = this._head.subtext(0, n);
        Text text2 = this._head.subtext(n + 1);
        this._head = text.plus(Text.valueOf(c)).plus(text2);
    }

    public TextBuilder replace(int n, int n2, CharSequence charSequence) {
        this.flushTail();
        Text text = this._head.subtext(0, n);
        Text text2 = this._head.subtext(n2);
        this._head = text.plus(Text.valueOf(charSequence)).plus(text2);
        return this;
    }

    public TextBuilder reverse() {
        this.flushTail();
        Text text = this._head;
        this._head = Text.EMPTY;
        int n = text._count;
        while (n > 0) {
            this.append(text.charAt(--n));
        }
        return this;
    }

    public void setLength(int n) {
        this.flushTail();
        if (n <= this._head._count) {
            this._head = this._head.subtext(0, n);
        } else {
            int n2 = this._head._count;
            while (n2 < n) {
                this.append('\u0000');
            }
        }
    }

    public Text toText() {
        this.flushTail();
        return this._head;
    }

    private void flushTail() {
        if (this._tail._count > 0) {
            this._head = this._head != Text.EMPTY ? Text.Composite.newInstance(this._head, this._tail) : this._tail;
            this._tail = Text.Primitive.newInstance();
        }
    }

    public void move(Realtime.ContextSpace contextSpace) {
        super.move(contextSpace);
        this._head.move(contextSpace);
        this._tail.move(contextSpace);
    }
}

