/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.gui.NamedObjFormat;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.RayPointProx;
import thunderheadeng.scene3d.tools.MouseHistory;

public class DrawHvacDuctTool
extends ADrawTool {
    private static final String VALTYPE_NODE1 = "NODE1";
    private static final String VALTYPE_NODE2 = "NODE2";
    private HvacDuct.DuctGeom d_geom;

    public DrawHvacDuctTool(IToolController mv, DrawProps toolProps) {
        super(mv, toolProps, DrawProps.GeomSpace.S1D);
        final Predicate<HvacNode> nodeFilter = HvacDuct.getNodeFilter();
        this.setSnapInfo(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(new Class[]{HvacNode.class}){

            @Override
            public boolean acceptPickObject(Object obj) {
                if (!(obj instanceof HvacNode)) {
                    return false;
                }
                HvacNode node = (HvacNode)obj;
                MouseHistory.Point lastPoint = DrawHvacDuctTool.this.getClickHistory().getLastCommittedPoint();
                HvacNode lastNode = DrawHvacDuctTool.getNode(lastPoint);
                return lastNode != node && nodeFilter.test(node);
            }
        });
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
        NamedObjFormat<HvacNode> format = new NamedObjFormat<HvacNode>(PyroSim.getApp().getMediator(), PyroSim.getApp().getMediator().getObstructions(), HvacNode.class);
        editor.addChoice(VALTYPE_NODE1, new ValueEditor.Choice(Intl.intl("Node A"), new guiFormattedFld<Object>(format, null)));
        editor.addChoice(VALTYPE_NODE2, new ValueEditor.Choice(Intl.intl("Node B"), new guiFormattedFld<Object>(format, null)));
    }

    @Override
    public void valueEditorChanged(ValueEditor editor, boolean commit) {
        HvacNode node = (HvacNode)editor.getValue();
        if (node != null) {
            CursorTool.SnapInfo currLoc;
            Point3d p = node.getLocation();
            Point3d sc = this.getView() != null ? this.getView().worldToScreen(p) : new Point3d();
            Point2d p2d = new Point2d(sc.x, sc.y);
            IsectInfo ii = new IsectInfo(GeomType.VERTEX, node, p, () -> new Point(p), IPrimProps.DEF, new RayPointProx(sc.z, 0.0));
            CursorTool.SnapInfo si = new CursorTool.SnapInfo(System.currentTimeMillis(), p2d, p, Arrays.asList(ii), p);
            this.getClickHistory().addPoint(si, commit);
            if (commit && (currLoc = this.getP1()) != null) {
                this.getClickHistory().addPoint(currLoc, false);
            }
        }
        this.updateEditorState(false);
    }

    @Override
    protected void updateEditorState(boolean fromMouseEvent) {
        ValueEditor editor = this.getValueEditor();
        String valType = this.getNodes(true).isEmpty() ? VALTYPE_NODE1 : VALTYPE_NODE2;
        editor.setValueType(valType);
        if (fromMouseEvent) {
            MouseHistory history = this.getClickHistory();
            HvacNode currNode = null;
            if (!history.getHistory().isEmpty()) {
                MouseHistory.Point p = this.getClickHistory().getHistory().getLast();
                currNode = DrawHvacDuctTool.getNode(p);
            }
            editor.setValue(currNode);
        }
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return HvacDuct.DuctGeom.class;
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    public void finish() {
        this.fireFinish(this.d_geom != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_geom = null;
        super.reset();
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        List<HvacNode> nodes = this.getNodes(false);
        if (nodes.size() >= 2) {
            this.d_geom = new HvacDuct.DuctGeom(nodes.get(0), nodes.get(1));
            this.fireUpdate(0, GeomNodeUtil.newNode(this.d_geom), null);
            if (p.committed) {
                this.finish();
            }
        } else if (nodes.size() == 1) {
            ArrayList<APrimitive> geoms = new ArrayList<APrimitive>(2);
            PropsBuilder props = new PropsBuilder();
            geoms.add(new Point(nodes.get(0).getLocation()));
            props.add(new IPrimProps.Vertex(Color.GREEN, 10.0));
            geoms.add(new LineSeg(nodes.get(0).getLocation(), p.p));
            props.add(new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0));
            this.fireUpdate(0, GeomNodeUtil.newNode(GeomUtil.group(geoms)), props.finalizeProps());
        } else if (nodes.isEmpty()) {
            this.fireUpdate(0, DisplayGeom.EMPTY.node, DisplayGeom.EMPTY.props);
        }
        this.repaintSurface();
    }

    protected List<HvacNode> getNodes(boolean committedOnly) {
        ArrayList<HvacNode> nodes = new ArrayList<HvacNode>();
        for (MouseHistory.Point prevp : this.getClickHistory().getHistory()) {
            HvacNode node;
            if (committedOnly && !prevp.committed || (node = DrawHvacDuctTool.getNode(prevp)) == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private static HvacNode getNode(MouseHistory.Point p) {
        if (p != null && p.snap != null) {
            for (IsectInfo ii : p.snap.snaps) {
                if (!(ii.obj instanceof HvacNode)) continue;
                return (HvacNode)ii.obj;
            }
        }
        return null;
    }
}

