/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.ModelView;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import pyrosim.mv.tools.constraint.IConstraintGen;
import pyrosim.mv.tools.constraint.WorkingPlaneConstraintGen;
import pyrosim.mv.tools.popupmenu.IPopupMenuBuilder;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.gui.IOffset;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public abstract class APyroTool
extends CursorTool
implements IPyroTool,
MouseHistory.IListener {
    private final MouseHistory d_history;
    private DrawProps d_toolProps;
    private ValueEditor d_valueEditor;
    private IPopupMenuBuilder d_menuBuilder;
    private IConstraintGen d_constraintGen;
    private final List<IToggleListener> d_toggleListeners = new ArrayList<IToggleListener>(3);
    private boolean t_modifierConsumed = false;

    public APyroTool(IToolController mv, DrawProps toolProps) {
        this(mv, toolProps, new ToolFunc());
    }

    public APyroTool(IToolController mv, DrawProps toolProps, IToolFunction func) {
        super(mv, func);
        this.d_toolProps = toolProps;
        this.d_constraintGen = WorkingPlaneConstraintGen.INSTANCE;
        this.d_history = new MouseHistory();
        this.d_history.addListener(this);
        this.setCancelOnRightClick(false);
    }

    public MouseHistory getMouseHistory() {
        return this.d_history;
    }

    @Override
    public void addToggleListener(IToggleListener listener) {
        if (!this.d_toggleListeners.contains(listener)) {
            this.d_toggleListeners.add(listener);
        }
    }

    @Override
    public void removeToggleListener(IToggleListener listener) {
        this.d_toggleListeners.remove(listener);
    }

    @Override
    public IToggleListener[] getToggleListeners() {
        return theUtil.toArray(this.d_toggleListeners, IToggleListener.class);
    }

    protected void fireToggleEvent() {
        for (IToggleListener listener : new ArrayList<IToggleListener>(this.d_toggleListeners)) {
            listener.toolToggled(this);
        }
    }

    @Override
    public void setMenuBuilder(IPopupMenuBuilder builder) {
        this.d_menuBuilder = builder;
    }

    @Override
    public IPopupMenuBuilder getMenuBuilder() {
        return this.d_menuBuilder;
    }

    @Override
    public void setConstraintGen(IConstraintGen builder) {
        this.d_constraintGen = builder;
    }

    @Override
    public IConstraintGen getConstraintGen() {
        return this.d_constraintGen;
    }

    @Override
    protected boolean isAltMenuAccessEnabled() {
        return false;
    }

    private void initValueEditor() {
        if (this.d_valueEditor != null) {
            return;
        }
        this.d_valueEditor = new ValueEditor(this.getAttachedComponent());
        if (this instanceof ValueEditor.IListener) {
            this.d_valueEditor.addListener((ValueEditor.IListener)((Object)this));
        }
        this.initValueEditor(this.d_valueEditor);
    }

    public ValueEditor getValueEditor() {
        this.initValueEditor();
        return this.d_valueEditor;
    }

    @Override
    public void activate() {
        super.activate();
        this.initValueEditor();
        this.d_valueEditor.attach();
    }

    @Override
    public void deactivate() {
        this.d_valueEditor.detach();
        super.deactivate();
    }

    protected MouseHistory getClickHistory() {
        return this.d_history;
    }

    public void setToolProps(DrawProps props) {
        this.d_toolProps = props;
    }

    @Override
    public DrawProps getProps() {
        return this.d_toolProps;
    }

    @Override
    public void reset() {
        this.d_history.reset();
        this.getValueEditor().clear();
        super.reset();
    }

    protected void showContextMenu(MouseEvent e) {
        JPopupMenu menu;
        if (!e.isPopupTrigger()) {
            return;
        }
        MenuBuilder builder = new MenuBuilder();
        this.addContextMenuActions(builder);
        builder.addSeparator();
        builder.add(new CancelAction());
        Action toolProps = ((ModelView)this.getModelView()).getToolPropsAction();
        if (toolProps.isEnabled()) {
            builder.addSeparator();
            builder.add(toolProps);
        }
        if ((menu = builder.buildPopupMenu()) != null) {
            MouseListener[] mouseListeners;
            MouseMotionListener[] motionListeners;
            for (MouseMotionListener listener : motionListeners = (MouseMotionListener[])this.getAttachedComponent().getListeners(MouseMotionListener.class)) {
                this.getAttachedComponent().removeMouseMotionListener(listener);
            }
            for (MouseListener listener : mouseListeners = (MouseListener[])this.getAttachedComponent().getListeners(MouseListener.class)) {
                this.getAttachedComponent().removeMouseListener(listener);
            }
            menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    for (MouseMotionListener mouseMotionListener : motionListeners) {
                        APyroTool.this.getAttachedComponent().addMouseMotionListener(mouseMotionListener);
                    }
                    for (EventListener eventListener : mouseListeners) {
                        APyroTool.this.getAttachedComponent().addMouseListener((MouseListener)eventListener);
                    }
                }
            });
            menu.show(this.getAttachedComponent(), e.getX(), e.getY());
        }
    }

    protected void addContextMenuActions(MenuBuilder builder) {
        if (this.d_menuBuilder != null) {
            this.d_menuBuilder.buildMenu(this, builder);
        }
    }

    protected Plane3d getWorkingPlane() {
        DrawProps props = this.getProps();
        double z = props.get(DrawProps.LOCATION).getValue(Geometry.LU);
        if (this.getView().getCamera() instanceof PerspectiveCamera) {
            if (this.getSnapToWorkingPlane() && this.getClickHistory().committedSize() > 0) {
                return new Plane3d(new Vector3d(0.0, 0.0, 1.0), this.getClickHistory().getHistory().getFirst().p);
            }
            return null;
        }
        Vector3d normal = this.getView().getCamera().getViewVector();
        normal.normalize();
        normal.negate();
        return new Plane3d(normal, new Point3d(z, z, z));
    }

    public ISnapConstraint getSetSnapConstraint() {
        return super.getSnapConstraint();
    }

    @Override
    public ISnapConstraint getSnapConstraint() {
        ISnapConstraint constraint = super.getSnapConstraint();
        if (constraint != null) {
            return constraint;
        }
        return this.d_constraintGen != null ? this.d_constraintGen.getConstraint(this) : null;
    }

    @Override
    public ISnapConstraint getDefaultConstraint() {
        double z = this.getProps().get(DrawProps.LOCATION).getValue(Geometry.LU);
        Plane3d plane = new Plane3d(0.0, 0.0, 1.0, -z);
        return new PlanarConstraint(plane);
    }

    public void valueEditorChanged(ValueEditor editor, boolean commit) {
        String key = editor.getCurrentValueType();
        if (key.equals("LOCATION")) {
            UnitDouble[] loc = (UnitDouble[])editor.getValue();
            if (loc != null) {
                Point3d p = new UnitPoint3D(loc).getPoint3dValue(Geometry.LU);
                this.getClickHistory().addPoint(this.nextEditorPoint(p), commit);
            }
        } else if (key.equals("OFFSET")) {
            MouseHistory history = this.getClickHistory();
            IOffset offset = ValueEditorUtil.getOffset(editor);
            if (offset instanceof IOffset.Distance) {
                IOffset.Distance dist = (IOffset.Distance)offset;
                if (history.committedSize() < history.size()) {
                    Point3d p2;
                    Point3d p1 = history.getLastCommitted();
                    Vector3d dir = Util3D.vector(p1, p2 = history.getHistory().getLast().p);
                    if (dir.lengthSquared() > 0.0) {
                        dir.normalize();
                    }
                    dir.scale(dist.dist.getValue(Geometry.LU));
                    p2 = Util3D.add(p1, (Tuple3d)dir);
                    this.getClickHistory().addPoint(this.nextEditorPoint(p2), commit);
                }
            } else if (offset instanceof IOffset.DirOffset) {
                IOffset.DirOffset doffset = (IOffset.DirOffset)offset;
                Point3d p = doffset.offset.getPoint3dValue(Geometry.LU);
                if (doffset.relative && history.committedSize() >= 1) {
                    Point3d prev = history.getLastCommitted();
                    Point3d next = Util3D.add(prev, (Tuple3d)p);
                    this.getClickHistory().addPoint(this.nextEditorPoint(next), commit);
                } else if (!doffset.relative) {
                    this.getClickHistory().addPoint(this.nextEditorPoint(p), commit);
                }
            }
        }
        this.updateEditorState(false);
    }

    protected void mouseEventProcessed(MouseEvent e) {
        this.updateEditorState(true);
        this.updateStatusMessage();
    }

    protected void updateEditorState(boolean fromMouseEvent) {
        ValueEditor editor = this.getValueEditor();
        MouseHistory history = this.getClickHistory();
        if (history.committedSize() == 0 && history.size() >= 1) {
            editor.setValueType("LOCATION");
            if (fromMouseEvent) {
                Point3d p = history.getHistory().getLast().p;
                ValueEditorUtil.setLocation(editor, p);
            }
        } else if (history.committedSize() > 0) {
            editor.setValueType("OFFSET");
            int currChoice = editor.getCurrentChoiceId();
            if (fromMouseEvent || currChoice != 0) {
                double dist = 0.0;
                if (history.committedSize() < history.size()) {
                    Point3d p1 = history.getLastCommitted();
                    Point3d p2 = history.getHistory().getLast().p;
                    dist = p1.distance(p2);
                }
                ValueEditorUtil.setOffset(editor, new IOffset.Distance(new UnitDouble(dist, Geometry.LU)), false);
            }
            if (fromMouseEvent || currChoice != 1) {
                Point3d relative = new Point3d(0.0, 0.0, 0.0);
                if (history.committedSize() < history.size()) {
                    Point3d p1 = history.getLastCommitted();
                    Point3d p2 = history.getHistory().getLast().p;
                    relative = Util3D.sub(p2, (Tuple3d)p1);
                }
                ValueEditorUtil.setOffset(editor, new IOffset.DirOffset(new UnitPoint3D(relative, Geometry.LU), true), false);
            }
            if (fromMouseEvent || currChoice != 2) {
                Point3d p = history.getHistory().getLast().p;
                ValueEditorUtil.setOffset(editor, new IOffset.DirOffset(new UnitPoint3D(p, Geometry.LU), false), false);
            }
        }
    }

    protected CursorTool.SnapInfo nextEditorPoint(Point3d p) {
        try {
            p = this.constrain(this.getSnapConstraint(), p);
        }
        catch (CursorTool.ConstraintException e) {
            return null;
        }
        Point2d p2d = this.toScreen(p);
        CursorTool.SnapInfo si = new CursorTool.SnapInfo(System.currentTimeMillis(), p2d, p, (Collection<IsectInfo>)Collections.EMPTY_LIST, p);
        return this.snapPoint(si);
    }

    protected CursorTool.SnapInfo nextMousePoint(CursorTool.SnapInfo p) {
        if (p.constrained.isEmpty()) {
            return null;
        }
        return this.snapPoint(p);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.pauseRepaint();
        super.keyPressed(e);
        if (e.getKeyCode() == 17) {
            this.t_modifierConsumed = false;
        }
        this.resumeRepaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        super.keyTyped(e);
        int mask = 0;
        int modKey = 17;
        switch (modKey) {
            case 17: {
                mask = 128;
                break;
            }
            case 18: {
                mask = 512;
                break;
            }
            case 16: {
                mask = 64;
                break;
            }
            case 157: {
                mask = 256;
            }
        }
        this.t_modifierConsumed |= mask != 0 && APyroTool.testBit(e.getModifiersEx(), mask);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.pauseRepaint();
        super.keyReleased(e);
        if (e.getKeyCode() == 17 && !this.t_modifierConsumed) {
            this.fireToggleEvent();
        }
        this.resumeRepaint();
    }

    protected CursorTool.SnapInfo snapPoint(CursorTool.SnapInfo si) {
        return si;
    }

    protected boolean getSnapToWorkingPlane() {
        return true;
    }

    protected void initValueEditor(ValueEditor editor) {
    }

    public PlanarConstraint getWorkingPlaneConstraint() {
        Plane3d plane = this.getWorkingPlane();
        return plane != null ? new PlanarConstraint(plane) : null;
    }

    protected static class ToolFunc<T extends APyroTool>
    extends AToolFunction<T> {
        protected ToolFunc() {
        }

        @Override
        public Cursor getCursor(T tool) {
            return null;
        }

        @Override
        public void mouseMoved(T tool, MouseEvent e) {
            ((APyroTool)tool).getMouseHistory().mouseMoved((CursorTool)tool, e, ((APyroTool)tool).nextMousePoint(((CursorTool)tool).getP1()));
            ((APyroTool)tool).mouseEventProcessed(e);
        }

        @Override
        public void mousePressed(T tool, MouseEvent e) {
            ((APyroTool)tool).getMouseHistory().mousePressed((CursorTool)tool, e, ((APyroTool)tool).nextMousePoint(((CursorTool)tool).getP1()));
            ((APyroTool)tool).mouseEventProcessed(e);
            ((APyroTool)tool).showContextMenu(e);
        }

        @Override
        public void mouseReleased(T tool, MouseEvent e) {
            ((APyroTool)tool).getMouseHistory().mouseReleased((CursorTool)tool, e, ((APyroTool)tool).nextMousePoint(((CursorTool)tool).getP1()));
            ((APyroTool)tool).mouseEventProcessed(e);
            ((APyroTool)tool).showContextMenu(e);
        }

        @Override
        public void mouseDragged(T tool, MouseEvent e) {
            ((APyroTool)tool).getMouseHistory().mouseDragged((CursorTool)tool, e, ((APyroTool)tool).nextMousePoint(((CursorTool)tool).getP1()));
            ((APyroTool)tool).mouseEventProcessed(e);
        }
    }

    protected class WorkingPlaneConstraint
    implements ISnapConstraint {
        protected WorkingPlaneConstraint() {
        }

        @Override
        public Point3d snapPoint(Point3d p) {
            return null;
        }

        @Override
        public Pair<Point3d, Point3d> snapRay(Point3d rayBegin, Vector3d rayDir) {
            return null;
        }

        @Override
        public ISnapConstraint transform(Matrix4d xform) {
            return null;
        }

        protected ISnapConstraint getBaseConstraint() {
            Plane3d plane = APyroTool.this.getWorkingPlane();
            return plane != null ? new PlanarConstraint(plane) : null;
        }
    }

    protected class CancelAction
    extends guiAction {
        private static final long serialVersionUID = -8734444625166746831L;

        public CancelAction() {
            super(Intl.intl("&Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            APyroTool.this.cancel();
        }
    }
}

