/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.manip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Matrix4d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.gui.actions.Actions;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import pyrosim.util.GeomUtil;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Task;

public class TransformMgr {
    private final PyroMod d_domain;
    private final DisplayManager d_dispMgr;
    private final DisplayManager d_xformDispMgr;
    private Collection<IPyroObject> d_xformObjs;
    private Set<IPyroGeomSrc> d_objSet;
    private ITransform d_xform;
    private boolean d_copyMode;
    private IDOF d_dof;

    public TransformMgr(PyroMod domain, DisplayManager dispMgr, DisplayManager xformDispMgr) {
        this.d_domain = domain;
        this.d_dispMgr = dispMgr;
        this.d_xformDispMgr = xformDispMgr;
        this.d_xformObjs = Collections.EMPTY_LIST;
        this.d_objSet = Collections.EMPTY_SET;
        this.d_xform = null;
        this.d_copyMode = false;
    }

    public PyroMod getDomain() {
        return this.d_domain;
    }

    public Collection<IPyroObject> getXformObjects() {
        return this.d_xformObjs;
    }

    public boolean canTransform() {
        return !this.d_domain.getSelectionModel().flatten(IPyroGeomSrc.class).isEmpty();
    }

    public boolean isTransforming() {
        return !this.d_xformObjs.isEmpty();
    }

    public boolean isTransforming(Object o) {
        return this.isTransforming() && !this.getCopyMode() && this.d_objSet.contains(o);
    }

    public boolean isTransformValid() {
        return this.isTransforming() && this.d_xform != null && !this.d_xform.isIdentity();
    }

    public IDOF getDOF() {
        if (this.d_dof == null) {
            this.begin();
            this.d_dof = GeomUtil.getDOF(Hierarchy.flatten(this.getXformObjects(), IPyroGeomSrc.class));
        }
        return this.d_dof;
    }

    public void setCopyMode(boolean copyMode) {
        if (this.d_copyMode == copyMode) {
            return;
        }
        this.d_copyMode = copyMode;
        if (this.isTransforming()) {
            this.setOriginalsVisible(this.d_copyMode);
        }
    }

    public boolean getCopyMode() {
        return this.d_copyMode;
    }

    public void begin() {
        if (this.isTransforming()) {
            return;
        }
        PyroSim app = PyroSim.getApp();
        Collection<IPyroObject> objs = Actions.getTransformObjs(app, app.getMediator(), new ArrayList<IPyroObject>(this.d_domain.getSelectionModel().getSelected(IPyroObject.class)));
        this.d_dispMgr.d_dispFilter.filterAllOfType(IHandle.class);
        this.d_xformObjs = objs;
        Collection<IPyroGeomSrc> flattened = Hierarchy.flatten(this.d_xformObjs, IPyroGeomSrc.class);
        this.d_objSet = new IdentityHashSet<IPyroGeomSrc>(flattened);
        this.d_xformDispMgr.add(flattened);
        this.setOriginalsVisible(this.d_copyMode);
    }

    public void modify(ITransform xform) {
        try {
            xform.invert();
        }
        catch (Throwable e) {
            System.err.println("Cannot invert matrix.  Skipping transform.");
            return;
        }
        this.d_xform = xform;
        Matrix4d mat = this.d_xform.toMatrix(false);
        this.applyToScenes(scene -> scene.setTransform(mat));
        if (!this.d_xform.isIdentity() && !this.isTransforming()) {
            this.begin();
        }
    }

    public void end(boolean commit) {
        TransformTask task = null;
        if (commit && this.d_xform != null && !this.d_xform.isIdentity()) {
            final ITransform xform = this.d_xform;
            int numCopies = this.d_copyMode ? 1 : 0;
            task = new TransformTask(this.d_domain, this.d_xformObjs, numCopies){

                @Override
                public ITransform getXFormForIteration(int i) {
                    return xform;
                }
            };
        }
        for (IPyroDisplayMgr dm : this.d_xformDispMgr.getDispManagers()) {
            dm.removeAll();
        }
        this.applyToScenes(scene -> scene.setTransform(null));
        this.setOriginalsVisible(true);
        this.d_xform = null;
        this.d_xformObjs = Collections.EMPTY_LIST;
        this.d_objSet = Collections.EMPTY_SET;
        this.d_copyMode = false;
        this.d_dof = null;
        this.d_dispMgr.d_dispFilter.removeFilter(IHandle.class);
        if (task != null) {
            this.d_domain.getTaskManager().exec((Task)task, Intl.intl("Transform Objects"), 1);
        }
    }

    private void applyToScenes(Consumer<ModelScene> function) {
        for (IPyroDisplayMgr dm : this.d_xformDispMgr.getDispManagers()) {
            for (RenderTarget target : RenderTarget.values()) {
                dm.getScenes().apply(target).ifPresent(function);
            }
        }
    }

    private void setOriginalsVisible(boolean visible) {
        Collection<IPyroGeomSrc> objs = Hierarchy.flatten(this.d_xformObjs, IPyroGeomSrc.class);
        if (!visible) {
            this.d_dispMgr.removeFromScene(objs);
        } else {
            this.d_dispMgr.addToScene(objs);
        }
    }
}

