/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.manip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.geom.Geometry;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.HandleDispMgr;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.manip.IManipListener;
import thunderheadeng.scene3d.manip.ManipEvent;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Task;

public class ManipHook
implements IManipListener,
IEventObserver {
    private final PyroMod d_domain;
    private final ModelView d_mv;
    private final ManipMgr d_manipMgr;
    private final HandleDispMgr d_dispMgr;
    private HandleSearcher d_handleSearcher;

    public ManipHook(PyroMod domain, ModelView mv, ManipMgr mgr, ModelScene handleScene, DisplayFilter displayFilter) {
        this.d_domain = domain;
        this.d_mv = mv;
        this.d_manipMgr = mgr;
        this.d_dispMgr = new HandleDispMgr(domain, handleScene, displayFilter);
        this.d_handleSearcher = null;
        domain.getEvents().addObserver(this);
        mgr.addListener(this);
    }

    @Override
    public void update(Events events) {
        IMutableGeomSrc source;
        IEventRecord<?> sevents;
        IEventRecord<PyroMod> pyroEvts = events.getEvents(PyroMod.class, new Class[0]);
        IEventRecord<IPyroGeomSrc> pevts = events.getEvents(IPyroGeomSrc.class, new Class[0]);
        if (pyroEvts.containsChange(PyroMod.EVT_MODEL_CHANGED) || pevts.hasAddedObjs() || pevts.hasRemovedObjs() || pevts.containsChange(PyroMod.EVT_SEL)) {
            IMutableGeomSrc selObj;
            IMutableGeomSrc newSrc = null;
            IFilteredCollection<IMutableGeomSrc> selGeoms = this.d_domain.getSelectionModel().getSelected(IMutableGeomSrc.class);
            if (selGeoms.size() == 1 && ManipMgr.canManipulate(selObj = (IMutableGeomSrc)selGeoms.iterator().next())) {
                newSrc = selObj;
            }
            this.d_manipMgr.setSource(newSrc);
        }
        if (this.d_manipMgr.getCurrentManipObj() != null && (sevents = events.getEvents((source = this.d_manipMgr.getCurrentManipObj()).getClass(), new Class[0])).isChanged(source)) {
            this.d_manipMgr.updateSource(source);
        }
    }

    @Override
    public void manipChanged(ManipEvent evt) {
        ManipEvent.Type type = evt.getType();
        switch (type) {
            case MANIP_STARTED: {
                this.begin();
                break;
            }
            case HANDLES_MODIFIED: {
                this.updateHandles();
                break;
            }
            case ACTIVE_HANDLE_CHANGED: {
                this.updateActiveHandle(evt.getOldHandle());
                break;
            }
            case MANIP_ENDED: {
                this.end();
                if (!evt.isCommitted()) break;
                this.commit(this.d_manipMgr.getCurrentManipObj(), evt.getNewNode());
            }
        }
    }

    protected void updateHandles() {
        Collection<IHandle> handles;
        if (this.d_handleSearcher != null) {
            this.d_dispMgr.removeDisplays(this.d_handleSearcher.d_handles);
            this.d_domain.getGeomLocator().remove(this.d_handleSearcher);
            this.d_handleSearcher = null;
        }
        if (!(handles = this.d_manipMgr.getCurrentHandles()).isEmpty()) {
            this.d_handleSearcher = new HandleSearcher(handles);
            this.d_domain.getGeomLocator().add(this.d_handleSearcher);
            this.d_dispMgr.addDisplays(handles);
            this.updateActiveHandle(null);
        }
    }

    protected void updateActiveHandle(IHandle oldHandle) {
        IHandle handle = this.d_manipMgr.getSelectedHandle();
        if (oldHandle != null) {
            this.d_dispMgr.updateSelected(oldHandle, false);
        }
        if (handle != null) {
            this.d_dispMgr.updateSelected(handle, true);
        }
    }

    protected void begin() {
    }

    protected void end() {
    }

    protected void commit(final IMutableGeomSrc src, IGeomNode newGeom) {
        newGeom = Geometry.finalize(newGeom, true);
        AReplaceRefTask<IGeomNode> t = new AReplaceRefTask<IGeomNode>((Object)src.getGeom(), (Object)newGeom){

            @Override
            protected void set(IGeomNode obj) {
                src.setGeom(obj);
            }
        };
        this.d_domain.getTaskManager().exec((Task)t, Intl.intl("Edit Object"), 1);
    }

    protected static class HandleSearcher
    implements IDisplayableGeomSrc,
    IPickable {
        private final List<IHandle> d_handles;
        private final AABox d_bounds;

        public HandleSearcher(Collection<? extends IHandle> handles) {
            this.d_handles = new ArrayList<IHandle>(handles);
            this.d_bounds = new AABox();
            for (IHandle handle : this.d_handles) {
                handle.getGeom().getBoundingBox(this.d_bounds);
            }
        }

        @Override
        public AABox getBounds() {
            return this.d_bounds;
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            return DisplayGeom.EMPTY;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean visible) {
        }

        private DisplayGeom getPickGeom(IHandle handle) {
            return new DisplayGeom(handle.getGeom(), DEF_PROPS);
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
            if (!filter.acceptPickObjType(IHandle.class)) {
                return;
            }
            for (IHandle handle : this.d_handles) {
                IPickable.pickPoints(handle, () -> this.getPickGeom(handle), isects, filter, rayBegin, rayEnd, rayDirN, tester);
            }
        }

        @Override
        public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
            if (!filter.acceptPickObjType(IHandle.class)) {
                return;
            }
            for (IHandle handle : this.d_handles) {
                IPickable.pickBox(handle, () -> this.getPickGeom(handle), result, filter, region);
            }
        }

        @Override
        public void getAll(Consumer<Object> result, IIsectFilter filter) {
            if (!filter.acceptPickObjType(IHandle.class)) {
                return;
            }
            for (IHandle handle : this.d_handles) {
                IPickable.getAll(handle, result, filter);
            }
        }
    }
}

