/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.mv.gui.ColorUtil;
import pyrosim.treeview.PyroTreeCellRenderer;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HoverWindow;
import thunderheadeng.gui.guiLabel;

public class SurfaceHover
extends HoverWindow {
    private static final long serialVersionUID = 6893727412437978513L;
    private Map<Color, String> d_colorNames;

    public SurfaceHover(Component parent) {
        this(SwingUtilities.getWindowAncestor(parent), parent);
    }

    public SurfaceHover(Window window, Component parent) {
        super(window, parent);
    }

    private Map<Color, String> mapColorNames(Object ... args) {
        assert (args.length % 2 == 0);
        HashMap<Color, String> names = new HashMap<Color, String>();
        int m = 0;
        while (m < args.length) {
            Color color = (Color)args[m++];
            String name = (String)args[m++];
            names.put(color, name);
        }
        return names;
    }

    public void update(String title, boolean pickSurf, Surface surf, boolean pickColor, Color color) {
        if (!pickSurf && !pickColor) {
            this.setVisible(false);
            return;
        }
        this.getContentPane().removeAll();
        GridBagHelper gb = new GridBagHelper(this.getContentPane());
        gb.d_rowSpace = 2;
        gb.addRow("<html><b>" + title + "</b></html>", 0);
        gb.indent();
        if (pickSurf) {
            guiLabel lbl = new guiLabel();
            PyroTreeCellRenderer.decorateLabel(PyroSim.getApp().getMediator(), lbl, surf);
            gb.addRow(Intl.intl("Surface:"), lbl, 0);
        }
        if (pickColor) {
            String name = ColorUtil.format(color);
            guiLabel label = new guiLabel(name);
            if (color != null) {
                label.setIcon(new ColorIcon(color, 16, 16, 3));
            }
            gb.addRow(Intl.intl("Color:"), label, 0);
        }
        gb.finalizeRows();
        this.pack();
        this.setVisible(true);
        this.repaint();
    }
}

