/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.Floor;
import pyrosim.domain.view.ClipPlane;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewMgr;
import pyrosim.geom.Geometry;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IProxyGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;

public class ClippingManager
implements Observer {
    private final PyroMod d_mod;
    private final ModelView d_mv;
    private UnitDouble[] d_floorClipping = null;
    private ConvexHull d_cachedHull = null;
    private IPropsSrc d_cachedClipProps = null;
    private ConvexHull d_currHull = new ConvexHull(new Plane3d[0]);
    private IPropsSrc d_currClipProps;
    private static final Predicate<Object> s_changeFilter = Filters.reject(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED);

    public ClippingManager(PyroMod mod, ModelView mv, DisplayFilter dispFilter) {
        this.d_currClipProps = DisplayGeom.EMPTY.props;
        this.d_mod = mod;
        this.d_mv = mv;
        dispFilter.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == EnableClipping.class) {
            System.out.println("updating filter");
            this.d_cachedHull = null;
            this.updateSceneClipping();
        }
    }

    public IPropsSrc getClipProps() {
        this.updateCache();
        return this.d_cachedClipProps;
    }

    public ConvexHull getClipRegion() {
        this.updateCache();
        return this.d_cachedHull;
    }

    private void updateCache() {
        if (this.d_cachedHull == null || this.d_cachedClipProps == null) {
            boolean sections = !this.d_mv.getDisplayManager().d_dispFilter.isFilteringAllOf(EnableClipping.class);
            Pair<ConvexHull, IPropsSrc> result = this.calcClipRegion(sections);
            this.d_cachedHull = (ConvexHull)result.v1;
            this.d_cachedClipProps = (IPropsSrc)result.v2;
        }
    }

    private Pair<ConvexHull, IPropsSrc> calcClipRegion(boolean sectionEnabled) {
        PropsBuilder pbuilder = new PropsBuilder();
        ArrayList<Plane3d> planes = new ArrayList<Plane3d>();
        this.getFloorClipPlanes(planes, pbuilder);
        this.getViewClipPlanes(planes, pbuilder);
        if (sectionEnabled) {
            this.getSectionBoxClipPlanes(planes, pbuilder, 6);
        }
        ConvexHull result = new ConvexHull(planes);
        int nfaces = result.getPlanes().length;
        result = result.optimize();
        IPropsSrc psrc = pbuilder.finalizeProps();
        if (result.getPlanes().length != nfaces) {
            psrc = result.getPlanes().length > 0 ? new UniformProps(psrc.get(0)) : DisplayGeom.EMPTY.props;
        }
        return new Pair<ConvexHull, IPropsSrc>(result, psrc);
    }

    private static double getFloorTolerance() {
        return 1.0E-4;
    }

    private void getFloorClipPlanes(List<Plane3d> planes, PropsBuilder pbuilder) {
        UnitDouble[] clipping = this.getFloorClipping();
        if (clipping[0] == null && clipping[1] == null) {
            return;
        }
        double tol = ClippingManager.getFloorTolerance();
        Color clipColor = Floor.DEFAULT_COLOR;
        Floor floor = this.d_mv.getCurrentFloor();
        if (floor != null) {
            clipColor = floor.getClipColor();
        }
        planes.add(new Plane3d(0.0, 0.0, 1.0, -clipping[1].getValue(Geometry.LU) + tol));
        planes.add(new Plane3d(0.0, 0.0, -1.0, clipping[0].getValue(Geometry.LU) - tol));
        pbuilder.add(new IPrimProps.Face(clipColor, null, 0), 2);
    }

    private UnitDouble[] getFloorClipping() {
        if (this.d_floorClipping == null) {
            this.d_floorClipping = this.calculateFloorClipping();
        }
        return this.d_floorClipping;
    }

    private UnitDouble[] calculateFloorClipping() {
        Collection floors = this.d_mod.getFloorManager().flatten();
        Floor floor = this.d_mv.getCurrentFloor();
        if (floor == null) {
            return new UnitDouble[]{null, null};
        }
        List<Floor> sortedFloors = Util.sort(floors, new Floor.CompareLevel());
        int ix = sortedFloors.indexOf(floor);
        Floor prevFloor = ix > 0 ? sortedFloors.get(ix - 1) : null;
        UnitDouble bottom = null;
        bottom = prevFloor != null && this.d_mv.getMainView().getCamera() instanceof OrthoCamera && Util3D.normalize(this.d_mv.getMainView().getCamera().getViewVector()).equals(GeomConstants.VEC3D_ZNEG) ? prevFloor.getElevation() : floor.getSlabBottom();
        UnitDouble top = floor.getCeilingLoc();
        return new UnitDouble[]{bottom, top};
    }

    private void getViewClipPlanes(List<Plane3d> planes, PropsBuilder pbuilder) {
        View aview = this.d_mod.getViews().getActiveView();
        if (aview == null) {
            return;
        }
        IPrimProps.Face fprops = new IPrimProps.Face(Color.ORANGE, null, 0);
        for (ClipPlane cp : aview.getClipPlanes()) {
            planes.add(cp.getPlane().get());
            pbuilder.add(fprops);
        }
    }

    private void getSectionBoxClipPlanes(List<Plane3d> planes, PropsBuilder pbuilder, int maxCount) {
        View aview = this.d_mod.getViews().getActiveView();
        if (aview == null) {
            return;
        }
        SectionBox sbox = aview.get(View.PROP_SECTION_BOX);
        if (sbox == null) {
            return;
        }
        IGeomNode boxGeom = sbox.getGeom();
        List faces = GeomUtil.explode(boxGeom.flatten().getLocalGeom(), IPolygon.class);
        IPrimProps.Face fprops = new IPrimProps.Face(sbox.getColor(), null, 0);
        Consumer<IPolygon> addPlane = p -> {
            planes.add(p.getPlane(true));
            pbuilder.add(fprops);
        };
        if (faces.size() + planes.size() <= maxCount) {
            faces.stream().forEach(addPlane);
            return;
        }
        AABoxGeom aageom = ClippingManager.findGeomType(boxGeom, AABoxGeom.class);
        if (aageom != null) {
            int[] preferredFaces = new int[]{0, 1, 2, 3, 4, 5};
            int[] nameIxMap = aageom.getNameToIndexFaceOrder();
            for (int m = 0; m < preferredFaces.length && planes.size() < maxCount; ++m) {
                IPolygon poly = (IPolygon)faces.get(nameIxMap[preferredFaces[m]]);
                addPlane.accept(poly);
            }
            return;
        }
        ExtrudedPoly epoly = ClippingManager.findGeomType(boxGeom, ExtrudedPoly.class);
        if (epoly != null) {
            int m;
            for (m = 0; m < faces.size() - 2 && planes.size() < maxCount; ++m) {
                addPlane.accept((IPolygon)faces.get(m + 2));
            }
            for (m = 0; m < 2 && planes.size() < maxCount; ++m) {
                addPlane.accept((IPolygon)faces.get(m));
            }
            return;
        }
        int toAdd = maxCount - planes.size();
        for (int m = 0; m < toAdd; ++m) {
            addPlane.accept((IPolygon)faces.get(m));
        }
    }

    private static <T extends IGeom> T findGeomType(IGeomNode node, Class<T> type) {
        T result = ClippingManager.findGeomType(node.getLocalGeom(), type);
        if (result != null) {
            return result;
        }
        for (IGeomNode iGeomNode : node.getChildren()) {
            result = ClippingManager.findGeomType(iGeomNode, type);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static <T extends IGeom> T findGeomType(IGeom geom, Class<T> type) {
        while (geom instanceof IProxyGeom) {
            geom = ((IProxyGeom)geom).getBase();
        }
        return (T)(type.isInstance(geom) ? (IGeom)type.cast(geom) : null);
    }

    private void markDirty(boolean hull, boolean props, boolean floorClipping) {
        if (hull) {
            this.d_cachedHull = null;
        }
        if (props) {
            this.d_cachedClipProps = null;
        }
        if (floorClipping) {
            this.d_floorClipping = null;
        }
    }

    public void processEvents(Events events) {
        if (this.getFloorChanged(events)) {
            this.markDirty(true, true, true);
        }
        if (this.getUpdateClipping(events)) {
            this.markDirty(true, true, false);
            this.updateSceneClipping();
            this.d_mv.getRenderComp().repaint();
        }
    }

    private boolean getFloorChanged(Events events) {
        return this.d_mv.getCurrentFloor() != null && events.getEvents(Floor.class, new Class[0]).isChanged(this.d_mv.getCurrentFloor());
    }

    private boolean getUpdateClipping(Events events) {
        if (this.getFloorChanged(events)) {
            return true;
        }
        IEventRecord<ViewMgr> mgrevt = events.getEvents(ViewMgr.class, new Class[0]);
        if (mgrevt.containsChange(ViewMgr.EVT_ACTIVE_VIEW)) {
            return true;
        }
        View aview = this.d_mod.getViews().getActiveView();
        if (aview != null) {
            IEventRecord<View> viewevt = events.getEvents(View.class, new Class[0]);
            if (viewevt.getChangedObjs(s_changeFilter).contains(aview)) {
                return true;
            }
            IEventRecord<ClipPlane> clipevt = events.getEvents(ClipPlane.class, new Class[0]);
            for (ClipPlane eplane : clipevt.getChangedObjs(s_changeFilter)) {
                if (eplane.getParent() != aview) continue;
                return true;
            }
            IEventRecord<SectionBox> sbevt = events.getEvents(SectionBox.class, new Class[0]);
            for (SectionBox sbox : sbevt.getChangedObjs(s_changeFilter)) {
                if (sbox.getParent() != aview) continue;
                return true;
            }
        }
        return false;
    }

    public void forceSceneClippingUpdate() {
        this.markDirty(true, true, true);
        this.updateSceneClipping();
    }

    private static boolean equal(IPropsSrc s1, IPropsSrc s2, int count) {
        for (int m = 0; m < count; ++m) {
            if (s1.get(m).equals(s2.get(m))) continue;
            return false;
        }
        return true;
    }

    private void updateSceneClipping() {
        this.updateCache();
        ConvexHull ch = this.getClipRegion();
        IPropsSrc props = this.getClipProps();
        if (!ch.equals(this.d_currHull) || !ClippingManager.equal(props, this.d_currClipProps, ch.getPlanes().length)) {
            this.d_currHull = ch;
            this.d_currClipProps = props;
            for (ModelScene scene : this.getClippingScenes()) {
                scene.removeAllCullBoxes();
            }
            if (!ch.acceptsAll()) {
                for (ModelScene scene : this.getClippingScenes()) {
                    scene.addCullBox(ch);
                }
            }
            this.d_mv.getDrawProps().setClippingManager(this);
            this.d_mv.getDisplayManager().updateClipping(this);
        }
    }

    public AABox getUnclippedBounds() {
        BoundsCalculator bc = new BoundsCalculator();
        for (ModelScene scene : this.getClippingScenes()) {
            scene.removeAllCullBoxes();
            scene.getBounds(bc);
        }
        AABox bounds = bc.getBounds();
        if (!this.d_currHull.acceptsNone()) {
            for (ModelScene scene : this.getClippingScenes()) {
                scene.addCullBox(this.d_currHull);
            }
        }
        return bounds;
    }

    public ModelScene[] getClippingScenes() {
        return new ModelScene[]{this.d_mv.getMainScene(), this.d_mv.getPatchScene()};
    }

    public List<IPyroDisplayMgr<?>> getClippedDisplayMgrs() {
        ArrayList result = new ArrayList();
        IdentityHashSet<ModelScene> clipScenes = Sets.fromArrayIHS(this.getClippingScenes());
        block0: for (IPyroDisplayMgr mgr : this.d_mv.getDisplayManager().getDispManagers()) {
            for (RenderTarget t : RenderTarget.values()) {
                Optional<ModelScene> scene = mgr.getScenes().apply(t);
                if (!scene.filter(s -> clipScenes.contains(s)).isPresent()) continue;
                result.add(mgr);
                continue block0;
            }
        }
        return result;
    }

    public static final class EnableClipping {
    }
}

