/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.IHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.JavaHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.theHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.theLinkedHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.theLinkedHashSet;

public class theHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    static final long serialVersionUID = -5024744406713321676L;
    private transient theHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public theHashSet() {
        this.map = new theHashMap();
    }

    public theHashSet(IHasher<E> hasher) {
        this.map = new theHashMap(hasher);
    }

    public theHashSet(Collection<? extends E> c) {
        this.map = new theHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public theHashSet(IHasher<E> hasher, Collection<? extends E> c) {
        this.map = new theHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16), hasher);
        this.addAll(c);
    }

    public theHashSet(int initialCapacity, float loadFactor) {
        this.map = new theHashMap(initialCapacity, loadFactor);
    }

    public theHashSet(int initialCapacity, float loadFactor, IHasher<E> hasher) {
        this.map = new theHashMap(initialCapacity, loadFactor, hasher);
    }

    public theHashSet(int initialCapacity) {
        this.map = new theHashMap(initialCapacity);
    }

    public theHashSet(int initialCapacity, IHasher<E> hasher) {
        this.map = new theHashMap(initialCapacity, hasher);
    }

    theHashSet(int initialCapacity, float loadFactor, boolean dummy) {
        this.map = new theLinkedHashMap<E, Object>(initialCapacity, loadFactor);
    }

    theHashSet(int initialCapacity, float loadFactor, boolean dummy, IHasher hasher) {
        this.map = new theLinkedHashMap<E, Object>(initialCapacity, loadFactor, hasher);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            theHashSet newSet = (theHashSet)super.clone();
            newSet.map = (theHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.map.getHasher());
        s.writeInt(this.map.capacity());
        s.writeFloat(this.map.loadFactor());
        s.writeInt(this.map.size());
        Iterator<E> i = this.map.keySet().iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        IHasher hasher = (IHasher)s.readObject();
        if (hasher.getClass().equals(IdentityHasher.class)) {
            hasher = IdentityHasher.INSTANCE;
        } else if (hasher.getClass().equals(JavaHasher.class)) {
            hasher = JavaHasher.INSTANCE;
        }
        int capacity = s.readInt();
        float loadFactor = s.readFloat();
        this.map = this instanceof theLinkedHashSet ? new theLinkedHashMap(capacity, loadFactor, hasher) : new theHashMap(capacity, loadFactor, hasher);
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this.map.put(e, PRESENT);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public int hashCode() {
        IHasher<E> hasher = this.map.getHasher();
        int hash = 0;
        for (E o : this) {
            if (o == null) continue;
            hash += hasher.hash(o);
        }
        return hash;
    }
}

