/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.io.Serializable;
import pyrosim.legacy_2012_1.thunderheadeng.util.AbstractValueRange;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;

public final class DoubleVR
extends AbstractValueRange<Double>
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final DoubleVR UNBOUNDED = new DoubleVR(0.0, 0.0, false, false, false, false);

    private DoubleVR(double min, double max, boolean checkMin, boolean checkMax, boolean minInclusive, boolean maxInclusive) {
        super(min, max, checkMin, checkMax, minInclusive, maxInclusive);
    }

    public static DoubleVR unbounded() {
        return UNBOUNDED;
    }

    public static DoubleVR above(double min, boolean inclusive) {
        return new DoubleVR(min, 0.0, true, false, inclusive, false);
    }

    public static DoubleVR below(double max, boolean inclusive) {
        return new DoubleVR(0.0, max, false, true, false, inclusive);
    }

    public static DoubleVR between(double min, double max, boolean minInclusive, boolean maxInclusive) {
        return new DoubleVR(min, max, true, true, minInclusive, maxInclusive);
    }

    @Override
    public String format(Object value) {
        return Global.format((Double)value);
    }

    @Override
    protected Double clampMaxUnincl(Double val) {
        assert (this.getMaxValue() != null);
        if (this.checksMin() && this.checksMax() && ((Double)this.getMinValue()).equals(this.getMaxValue())) {
            return null;
        }
        if (val != null && val >= (Double)this.getMaxValue()) {
            return (Double)this.getMaxValue() - this.getClampOffset();
        }
        return val;
    }

    @Override
    protected Double clampMinUnincl(Double val) {
        assert (this.getMinValue() != null);
        if (this.checksMin() && this.checksMax() && ((Double)this.getMinValue()).equals(this.getMaxValue())) {
            return null;
        }
        if (val != null && val <= (Double)this.getMinValue()) {
            return (Double)this.getMinValue() + this.getClampOffset();
        }
        return val;
    }

    private double getClampOffset() {
        if (this.checksMin() && this.checksMax()) {
            double diff = (Double)this.getMaxValue() - (Double)this.getMinValue();
            return diff * 1.0E-6;
        }
        return 0.01;
    }
}

