/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.units;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class UnitAABox
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public final double minx;
    public final double miny;
    public final double minz;
    public final double maxx;
    public final double maxy;
    public final double maxz;
    public final Unit unit;

    public UnitAABox() {
        this(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308, (Unit)SI.METER);
    }

    public UnitAABox(UnitAABox box) {
        this(box.minx, box.miny, box.minz, box.maxx, box.maxy, box.maxz, box.unit);
    }

    public UnitAABox(Point3d min, Point3d max, Unit u) {
        this(min.x, min.y, min.z, max.x, max.y, max.z, u);
    }

    public UnitAABox(double minx, double miny, double minz, double maxx, double maxy, double maxz, Unit u) {
        this.minx = minx;
        this.miny = miny;
        this.minz = minz;
        this.maxx = maxx;
        this.maxy = maxy;
        this.maxz = maxz;
        this.unit = u;
    }

    public UnitAABox(UnitPoint3D min, UnitPoint3D max) {
        this(min.getPoint3dValue(min.getUnit()), max.getPoint3dValue(min.getUnit()), min.getUnit());
    }

    public UnitAABox(AABox bb, Unit u) {
        this(bb.getMin(), bb.getMax(), u);
    }

    public boolean isValid() {
        return this.minx <= this.maxx && this.miny <= this.maxy && this.minz <= this.maxz;
    }

    public UnitAABox add(UnitAABox box) {
        double bminx = UnitDouble.convert(box.minx, box.unit, this.unit);
        double bminy = UnitDouble.convert(box.miny, box.unit, this.unit);
        double bminz = UnitDouble.convert(box.minz, box.unit, this.unit);
        double bmaxx = UnitDouble.convert(box.maxx, box.unit, this.unit);
        double bmaxy = UnitDouble.convert(box.maxy, box.unit, this.unit);
        double bmaxz = UnitDouble.convert(box.maxz, box.unit, this.unit);
        return new UnitAABox(Math.min(this.minx, bminx), Math.min(this.miny, bminy), Math.min(this.minz, bminz), Math.max(this.maxx, bmaxx), Math.max(this.maxy, bmaxy), Math.max(this.maxz, bmaxz), this.unit);
    }

    public UnitPoint3D getCenter() {
        return new UnitPoint3D((this.minx + this.maxx) * 0.5, (this.miny + this.maxy) * 0.5, (this.minz + this.maxz) * 0.5, this.unit);
    }

    public Point3d getMin(Unit u) {
        Converter converter = this.unit.getConverterTo(u);
        return new Point3d(converter.convert(this.minx), converter.convert(this.miny), converter.convert(this.minz));
    }

    public Point3d getMax(Unit u) {
        Converter converter = this.unit.getConverterTo(u);
        return new Point3d(converter.convert(this.maxx), converter.convert(this.maxy), converter.convert(this.maxz));
    }

    public UnitPoint3D getMin() {
        return new UnitPoint3D(this.minx, this.miny, this.minz, this.unit);
    }

    public UnitPoint3D getMax() {
        return new UnitPoint3D(this.maxx, this.maxy, this.maxz, this.unit);
    }

    public AABox getValue(Unit u) {
        Converter converter = this.unit.getConverterTo(u);
        return new AABox(converter.convert(this.minx), converter.convert(this.miny), converter.convert(this.minz), converter.convert(this.maxx), converter.convert(this.maxy), converter.convert(this.maxz));
    }

    public Object clone() {
        try {
            UnitAABox clone = (UnitAABox)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnitAABox)) {
            return false;
        }
        UnitAABox box = (UnitAABox)obj;
        return this.getMin().equals(box.getMin()) && this.getMax().equals(box.getMax());
    }

    public int hashCode() {
        return 947183593 + this.getMin().hashCode() + this.getMax().hashCode();
    }

    public UnitAABox transform(Matrix4d xform) {
        UnitPoint3D p1 = GeomUtil.xform(xform, this.getMin());
        UnitPoint3D p2 = GeomUtil.xform(xform, this.getMax());
        UnitPoint3D[] newPoints = GeomUtil.rectify(p1, p2);
        return new UnitAABox(newPoints[0], newPoints[1]);
    }
}

