/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.util.Observable;
import java.util.Observer;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ANativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;

public class SceneRenderOptions
extends ANativelyMirrored
implements Cloneable {
    private static final long serialVersionUID = -3325464809836791008L;
    private boolean d_lightingEnabled = true;
    private boolean d_smoothLighting = true;
    private boolean d_drawOutlines = true;
    private boolean d_drawWireframe = false;
    private boolean d_drawTextures = true;
    private boolean d_depthTestEnabled = true;
    private boolean d_drawSelectedFaceOutlines = true;
    private boolean d_autoClip = true;
    private float[] d_polygonOffset = new float[]{1.0f, 1.0f};
    private ObservableHelper d_observableHelper = new ObservableHelper();

    public SceneRenderOptions() {
        this.nativeConstructed(SceneRenderOptions.class);
    }

    public void addObserver(Observer observer) {
        this.d_observableHelper.addObserver(observer);
    }

    @Override
    public Object clone() {
        SceneRenderOptions props = (SceneRenderOptions)super.clone();
        return props;
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        writer.writeBoolean(this.d_lightingEnabled);
        writer.writeBoolean(this.d_smoothLighting);
        writer.writeBooleans(this.d_drawWireframe, this.d_drawOutlines, this.d_drawTextures);
        writer.writeBoolean(this.d_depthTestEnabled);
        writer.writeBoolean(this.d_drawSelectedFaceOutlines);
        writer.writeBoolean(this.d_autoClip);
        writer.writeFloats(this.d_polygonOffset[0], this.d_polygonOffset[1]);
    }

    @Override
    public Class resolveNativeClass() {
        return SceneRenderOptions.class;
    }

    @Override
    protected void forceUpdate() {
        super.forceUpdate();
        this.d_observableHelper.setChanged();
        this.d_observableHelper.notifyObservers(this);
    }

    public void setDepthTestEnabled(boolean enabled) {
        this.d_depthTestEnabled = enabled;
        this.markNativeDirty();
    }

    public boolean isDepthTestEnabled() {
        return this.d_depthTestEnabled;
    }

    public void setPolygonOffset(float factor, float units) {
        this.d_polygonOffset = new float[]{factor, units};
        this.markNativeDirty();
    }

    public float[] getPolygonOffset() {
        return this.d_polygonOffset;
    }

    public void setLightingEnabled(boolean enabled) {
        this.d_lightingEnabled = enabled;
        this.markNativeDirty();
    }

    public boolean isLightingEnabled() {
        return this.d_lightingEnabled;
    }

    public void setSmoothLightingEnabled(boolean use) {
        this.d_smoothLighting = use;
        this.markNativeDirty();
    }

    public boolean useSmoothLighting() {
        return this.d_smoothLighting;
    }

    public void setDrawOutlines(boolean drawOutlines) {
        this.d_drawOutlines = drawOutlines;
        this.markNativeDirty();
    }

    public boolean drawOutlines() {
        return this.d_drawOutlines;
    }

    public void setShowTextures(boolean drawTextures) {
        this.d_drawTextures = drawTextures;
        this.markNativeDirty();
    }

    public boolean showTextures() {
        return this.d_drawTextures;
    }

    public void setDrawWireframe(boolean drawWireframe) {
        this.d_drawWireframe = drawWireframe;
        this.markNativeDirty();
    }

    public boolean drawWireframe() {
        return this.d_drawWireframe;
    }

    public boolean drawSelectedFaceOutlines() {
        return this.d_drawSelectedFaceOutlines;
    }

    public void setDrawSelectedFaceOutlines(boolean enabled) {
        this.d_drawSelectedFaceOutlines = enabled;
        this.markNativeDirty();
    }

    public boolean getAutoClip() {
        return this.d_autoClip;
    }

    public void setAutoClip(boolean autoClip) {
        this.d_autoClip = autoClip;
        this.markNativeDirty();
    }

    private static class ObservableHelper
    extends Observable {
        private ObservableHelper() {
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }
}

